/* clierr.c - CLI error facility implementation */
#include "cvstags.h"
CVSTAG(clierr,"$Id: clierr.c,v 1.9 2005/05/08 23:51:40 knilch Exp $")

/* Ramdefrag Command Line Error Facility
 *  (c) 2004, 2005 Tobias 'knilch' Jordan <knilch@users.sourceforge.net>
 *
 *  Setting Orange, the 70th day of Chaos in the YOLD 3170
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/*
 * Heaven is down. Hell is up.
 * This is proven by the fact
 * that the planets and stars
 * are orderly in their
 * movements,
 * while down on earth
 * we come close to the
 * primal chaos.
 * There are four other
 * proofs,
 * but I forget them.
 *
 *        --Josh the Dill
 *          King Kong Kabal
 */

#include <stdio.h>

#include "clierr.h"
#include "support.h"

void clierr(const char* herbert) {
  if (herbert) fprintf(stderr,"%s: %s\n", PACKAGE_NAME, herbert);
}

void cliout(const char* harald) {
  if (harald) printf("%s",harald);
}

void press_h_for_help(const char* heinz) {
  if (heinz) fprintf(stderr,_("Try '%s -h' or '%s --help' for usage information.\n"), heinz, heinz);
}

