/* configf.h - header file for configuration file operations
 * $Id: configf.h,v 1.10 2005/05/08 23:51:40 knilch Exp $ */

/* Ramdefrag Configuration File Abstraction Layer
 *  (c) 2004, 2005 Tobias 'knilch' Jordan <knilch@users.sourceforge.net>
 *
 *  Prickle-Prickle, the 16th day of Discord in the YOLD 3170
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef CONFIGF_H
#define CONFIGF_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/*
 * All statements are true in some sense, false in some sense, meaningless
 * in some sense, true and false in some sense, true and meaningless in
 * some sense, false and meaningless in some sense, and true and false and
 * meaningless in some sense.
 * A public service clarification by the Sri Syadasti School of Spiritual
 * Wisdom, Wilmette.
 */

#define CFNAME ".ramdefragrc"

struct my_cnf {
  long int ts;
  char* df;
  char x[23];
} ;

/*
 * The teachings of the Sri Syadasti School of Spiritual School of
 * Spiritual Wisdom are true in some sense, false in some sense,
 * meaningless in some sense, true and false in some sense, true and
 * meaningless in some sense, false and meaningless in some sense, and
 * true and false and meaningless in some sense.
 * Patamunzo Lingananda School of Higher Spiritual Wisdom, Skokie.
 */

int readcf(struct my_cnf *c);

int writecf(struct my_cnf c);

#endif /* CONFIGF_H */

