#!/bin/sh

# $Id: update-ChangeLog.sh,v 1.2 2004/07/17 23:46:48 knilch Exp $
#
# (c) 2004 Tobias 'knilch' Jordan <knilch@users.sourceforge.net>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

if test ! -f ChangeLog ; then
  echo "ChangeLog not in current directory"
  exit
fi

if test ! -f ramdefrag.spec.in ; then
  echo "this doesn't look like the right directory (ramdefrag.spec.in not present)"
  exit
fi

cvs -q up -dP || exit

cp ChangeLog ChangeLog.$$
tools/cvs2cl.pl -I ChangeLog

if diff ChangeLog ChangeLog.$$  >/dev/null 2>&1 ; then
  echo "no differences.  `ddate '+(%{%a, %d. %b%} %Y)'`"
  rm -f ChangeLog.$$
  exit
else
  rm -f ChangeLog.$$
  cvs ci -m "regenerated ChangeLog.  `ddate '+(%{%a, %d. %b%} %Y)'`" ChangeLog
fi


