/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.Instrument;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.Parseable;
import org.linuxsampler.lscp.Parser;

public abstract class AbstractInstrument
implements Instrument,
Parseable {
    private String name = "Untitled";
    private String description = "";
    private String path = null;
    private int instrumentIndex = 0;
    private String formatFamily = "";
    private String formatVersion = "";
    private Integer[] keyMapping = new Integer[0];
    private Integer[] keyswitchMapping = new Integer[0];

    public AbstractInstrument() {
    }

    public AbstractInstrument(String[] stringArray) throws LscpException {
        for (String string : stringArray) {
            if (this.parse(string)) continue;
            Client.getLogger().info(LscpI18n.getLogMsg("unknownLine", string));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFilePath() {
        return this.path;
    }

    @Override
    public void setFilePath(String string) {
        this.path = string;
    }

    @Override
    public int getInstrumentIndex() {
        return this.instrumentIndex;
    }

    @Override
    public void setInstrumentIndex(int n) {
        this.instrumentIndex = n;
    }

    @Override
    public String getFormatFamily() {
        return this.formatFamily;
    }

    @Override
    public String getFormatVersion() {
        return this.formatVersion;
    }

    @Override
    public Integer[] getKeyMapping() {
        return this.keyMapping;
    }

    @Override
    public Integer[] getKeyswitchMapping() {
        return this.keyswitchMapping;
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (string.startsWith("NAME: ")) {
            this.setName(string.substring("NAME: ".length()));
        } else if (string.startsWith("DESCRIPTION: ")) {
            this.description = string.substring("DESCRIPTION: ".length());
            this.description = Parser.toNonEscapedString(this.description);
        } else if (string.startsWith("INSTRUMENT_FILE: ")) {
            this.setFilePath(string.substring("INSTRUMENT_FILE: ".length()));
        } else if (string.startsWith("INSTRUMENT_NR: ")) {
            string = string.substring("INSTRUMENT_NR: ".length());
            this.setInstrumentIndex(Parser.parseInt(string));
        } else if (string.startsWith("FORMAT_FAMILY: ")) {
            this.formatFamily = string.substring("FORMAT_FAMILY: ".length());
        } else if (string.startsWith("FORMAT_VERSION: ")) {
            this.formatVersion = string.substring("FORMAT_VERSION: ".length());
        } else if (string.startsWith("KEY_BINDINGS: ")) {
            string = string.substring("KEY_BINDINGS: ".length());
            this.keyMapping = Parser.parseIntList(string);
        } else if (string.startsWith("KEYSWITCH_BINDINGS: ")) {
            string = string.substring("KEYSWITCH_BINDINGS: ".length());
            this.keyswitchMapping = Parser.parseIntList(string);
        } else {
            return false;
        }
        return true;
    }
}

