/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.icon;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JSlider;
import javax.swing.JTree;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.substance.SubstanceSliderUI;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.painter.gradient.SubstanceGradientPainter;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.RolloverControlListener;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceOutlineUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.Trackable;

public class SubstanceIconFactory {
    private static LazyResettableHashMap<Icon> sliderHorizontalIcons = new LazyResettableHashMap("SubstanceIconFactory.sliderHorizontalIcon");
    private static LazyResettableHashMap<Icon> sliderRoundIcons = new LazyResettableHashMap("SubstanceIconFactory.sliderRoundIcon");
    private static LazyResettableHashMap<Icon> sliderVerticalIcons = new LazyResettableHashMap("SubstanceIconFactory.sliderVerticalIcon");
    private static LazyResettableHashMap<Icon> treeIcons = new LazyResettableHashMap("SubstanceIconFactory.treeIcon");
    private static final Map<IconKind, Map<SubstanceColorScheme, Icon>> titlePaneIcons = SubstanceIconFactory.createTitlePaneIcons();

    public static synchronized void reset() {
        titlePaneIcons.get((Object)IconKind.CLOSE).clear();
        titlePaneIcons.get((Object)IconKind.MINIMIZE).clear();
        titlePaneIcons.get((Object)IconKind.MAXIMIZE).clear();
        titlePaneIcons.get((Object)IconKind.RESTORE).clear();
    }

    public static Icon getSliderHorizontalIcon(int size, boolean isMirrorred) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(size, isMirrorred);
        if (sliderHorizontalIcons.get(key) == null) {
            SliderHorizontalIcon icon = new SliderHorizontalIcon(size, isMirrorred);
            sliderHorizontalIcons.put(key, icon);
        }
        return sliderHorizontalIcons.get(key);
    }

    public static Icon getSliderRoundIcon(int size) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(size);
        if (sliderRoundIcons.get(key) == null) {
            SliderRoundIcon icon = new SliderRoundIcon(size);
            sliderRoundIcons.put(key, icon);
        }
        return sliderRoundIcons.get(key);
    }

    public static Icon getSliderVerticalIcon(int size, boolean isMirrorred) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(size, isMirrorred);
        if (sliderVerticalIcons.get(key) == null) {
            SliderVerticalIcon icon = new SliderVerticalIcon(size, isMirrorred);
            sliderVerticalIcons.put(key, icon);
        }
        return sliderVerticalIcons.get(key);
    }

    public static Icon getTreeIcon(JTree tree, boolean isCollapsed) {
        int fontSize = SubstanceSizeUtils.getComponentFontSize(tree);
        int size = SubstanceSizeUtils.getTreeIconSize(fontSize);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(size, isCollapsed);
        if (treeIcons.get(key) == null) {
            TreeIcon icon = new TreeIcon(size, isCollapsed);
            treeIcons.put(key, icon);
        }
        return treeIcons.get(key);
    }

    private static Map<IconKind, Map<SubstanceColorScheme, Icon>> createTitlePaneIcons() {
        HashMap<IconKind, Map<SubstanceColorScheme, Icon>> result = new HashMap<IconKind, Map<SubstanceColorScheme, Icon>>();
        result.put(IconKind.CLOSE, new HashMap());
        result.put(IconKind.MINIMIZE, new HashMap());
        result.put(IconKind.MAXIMIZE, new HashMap());
        result.put(IconKind.RESTORE, new HashMap());
        return result;
    }

    public static Icon getTitlePaneIcon(IconKind iconKind, SubstanceColorScheme scheme) {
        Map<SubstanceColorScheme, Icon> kindMap = titlePaneIcons.get((Object)iconKind);
        Icon result = kindMap.get(scheme);
        if (result != null) {
            return result;
        }
        switch (iconKind) {
            case CLOSE: {
                result = SubstanceImageCreator.getCloseIcon(scheme);
                break;
            }
            case MINIMIZE: {
                result = SubstanceImageCreator.getMinimizeIcon(scheme);
                break;
            }
            case MAXIMIZE: {
                result = SubstanceImageCreator.getMaximizeIcon(scheme);
                break;
            }
            case RESTORE: {
                result = SubstanceImageCreator.getRestoreIcon(scheme);
            }
        }
        kindMap.put(scheme, result);
        return result;
    }

    public static enum IconKind {
        CLOSE,
        MINIMIZE,
        MAXIMIZE,
        RESTORE;

    }

    private static class TreeIcon
    implements Icon,
    UIResource {
        private static LazyResettableHashMap<Icon> icons = new LazyResettableHashMap("SubstanceIconFactory.TreeIcon");
        private boolean isCollapsed;
        private int size;

        public TreeIcon(int size, boolean isCollapsed) {
            this.isCollapsed = isCollapsed;
            this.size = size;
        }

        private static Icon getIcon(JTree tree, boolean isCollapsed) {
            ComponentState state = tree == null || tree.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(tree, state);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)tree, ColorSchemeAssociationKind.BORDER, state);
            int fontSize = SubstanceSizeUtils.getComponentFontSize(tree);
            HashMapKey key = SubstanceCoreUtilities.getHashKey(fontSize, fillScheme.getDisplayName(), borderScheme.getDisplayName(), isCollapsed);
            Icon result = icons.get(key);
            if (result != null) {
                return result;
            }
            result = new ImageIcon(SubstanceImageCreator.getTreeIcon(tree, fillScheme, borderScheme, isCollapsed));
            icons.put(key, result);
            return result;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JTree tree = c instanceof JTree ? (JTree)c : null;
            Icon iconToDraw = TreeIcon.getIcon(tree, this.isCollapsed);
            iconToDraw.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    private static class SliderVerticalIcon
    implements Icon,
    UIResource {
        private static LazyResettableHashMap<Icon> icons = new LazyResettableHashMap("SubstanceIconFactory.SliderVerticalIcon");
        private int size;
        private boolean isMirrorred;
        private WeakHashMap<JSlider, ButtonModel> models = new WeakHashMap();

        public SliderVerticalIcon(int size, boolean isMirrorred) {
            this.size = size;
            this.isMirrorred = isMirrorred;
        }

        private static Icon getIcon(ComponentState state, ComponentState prevState, JSlider slider, SliderVerticalIcon sliderIcon) {
            float cyclePos = state.getCyclePosition();
            SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, state);
            SubstanceColorScheme colorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(slider, prevState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)slider, ColorSchemeAssociationKind.BORDER, state);
            SubstanceColorScheme borderScheme2 = SubstanceColorSchemeUtilities.getColorScheme((Component)slider, ColorSchemeAssociationKind.BORDER, prevState);
            FadeTracker fadeTracker = FadeTracker.getInstance();
            int height = 2 * sliderIcon.size / 3;
            FadeState rolloverFadeState = fadeTracker.getFadeState(slider, FadeKind.ROLLOVER);
            FadeState pressFadeState = fadeTracker.getFadeState(slider, FadeKind.PRESS);
            if (rolloverFadeState != null) {
                cyclePos = rolloverFadeState.getFadePosition();
                if (rolloverFadeState.isFadingIn()) {
                    cyclePos = 1.0f - cyclePos;
                }
                height = (int)((double)sliderIcon.size * (2.0 + (double)rolloverFadeState.getFadePosition()) / 3.0);
            } else if (pressFadeState != null) {
                cyclePos = pressFadeState.getFadePosition();
                if (pressFadeState.isFadingIn()) {
                    cyclePos = 1.0f - cyclePos;
                }
                height = sliderIcon.size;
            } else {
                switch (state) {
                    case ROLLOVER_UNSELECTED: 
                    case ROLLOVER_SELECTED: 
                    case ACTIVE: 
                    case PRESSED_SELECTED: 
                    case PRESSED_UNSELECTED: {
                        height = sliderIcon.size;
                    }
                }
            }
            height = Math.min(height, sliderIcon.size - 2);
            int delta = (sliderIcon.size - height) / 2 - 1;
            HashMapKey key = SubstanceCoreUtilities.getHashKey(sliderIcon.size, height, slider.getComponentOrientation(), colorScheme.getDisplayName(), colorScheme2.getDisplayName(), borderScheme.getDisplayName(), borderScheme2.getDisplayName(), Float.valueOf(cyclePos));
            Icon result = icons.get(key);
            if (result != null) {
                return result;
            }
            SubstanceGradientPainter painter = SubstanceCoreUtilities.getGradientPainter(slider);
            SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(slider);
            int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(slider)) / 2.0);
            GeneralPath contour = SubstanceOutlineUtilities.getTriangleButtonOutline(height, sliderIcon.size, 2.0f, borderDelta);
            BufferedImage stateImage = SubstanceCoreUtilities.getBlankImage(sliderIcon.size - 1, sliderIcon.size - 1);
            Graphics2D g2d = stateImage.createGraphics();
            g2d.translate(delta, 0);
            painter.paintContourBackground(g2d, slider, height, sliderIcon.size, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(slider));
            GeneralPath contourInner = SubstanceOutlineUtilities.getTriangleButtonOutline(height, sliderIcon.size, 2.0f, borderThickness + borderDelta);
            borderPainter.paintBorder(g2d, slider, height, sliderIcon.size - 1, contour, contourInner, borderScheme, borderScheme2, cyclePos, borderScheme != borderScheme2);
            stateImage = sliderIcon.isMirrorred ? SubstanceImageCreator.getRotated(stateImage, 1) : SubstanceImageCreator.getRotated(stateImage, 3);
            if (!slider.getComponentOrientation().isLeftToRight()) {
                stateImage = SubstanceImageCreator.getRotated(stateImage, 2);
            }
            result = new ImageIcon(stateImage);
            icons.put(key, result);
            return result;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            SliderUI sliderUI = slider.getUI();
            ComponentState state = ComponentState.ACTIVE;
            if (sliderUI instanceof SubstanceSliderUI) {
                state = ComponentState.getState(((SubstanceSliderUI)sliderUI).getButtonModel(), null);
            } else {
                ButtonModel buttonModel = this.models.get(slider);
                if (buttonModel == null) {
                    buttonModel = new DefaultButtonModel();
                    buttonModel.setEnabled(slider.isEnabled());
                    RolloverControlListener listener = new RolloverControlListener(new TrackableSlider(slider), buttonModel);
                    slider.addMouseListener(listener);
                    slider.addMouseMotionListener(listener);
                    this.models.put(slider, buttonModel);
                }
                state = ComponentState.getState(buttonModel, null);
            }
            ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(slider);
            Icon iconToDraw = SliderVerticalIcon.getIcon(state, prevState, slider, this);
            iconToDraw.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.size - 1;
        }

        @Override
        public int getIconHeight() {
            return this.size - 1;
        }
    }

    private static class SliderRoundIcon
    implements Icon,
    UIResource {
        private static LazyResettableHashMap<Icon> icons = new LazyResettableHashMap("SubstanceIconFactory.SliderRoundIcon");
        private int size;
        private WeakHashMap<JSlider, ButtonModel> models = new WeakHashMap();

        public SliderRoundIcon(int size) {
            this.size = size;
        }

        private static Icon getIcon(ComponentState state, ComponentState prevState, JSlider slider, SliderRoundIcon sliderIcon) {
            float cyclePos = state.getCyclePosition();
            SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, state);
            SubstanceColorScheme colorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(slider, prevState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)slider, ColorSchemeAssociationKind.BORDER, state);
            SubstanceColorScheme borderScheme2 = SubstanceColorSchemeUtilities.getColorScheme((Component)slider, ColorSchemeAssociationKind.BORDER, prevState);
            FadeTracker fadeTracker = FadeTracker.getInstance();
            int width = 2 * sliderIcon.size / 3;
            FadeState rolloverFadeState = fadeTracker.getFadeState(slider, FadeKind.ROLLOVER);
            FadeState pressFadeState = fadeTracker.getFadeState(slider, FadeKind.PRESS);
            if (rolloverFadeState != null) {
                cyclePos = rolloverFadeState.getFadePosition();
                if (rolloverFadeState.isFadingIn()) {
                    cyclePos = 1.0f - cyclePos;
                }
                width = (int)((double)sliderIcon.size * (2.0 + (double)rolloverFadeState.getFadePosition()) / 3.0);
            } else if (pressFadeState != null) {
                cyclePos = pressFadeState.getFadePosition();
                if (pressFadeState.isFadingIn()) {
                    cyclePos = 1.0f - cyclePos;
                }
                width = sliderIcon.size;
            } else {
                switch (state) {
                    case ROLLOVER_UNSELECTED: 
                    case ROLLOVER_SELECTED: 
                    case ACTIVE: 
                    case PRESSED_SELECTED: 
                    case PRESSED_UNSELECTED: {
                        width = sliderIcon.size;
                    }
                }
            }
            width = Math.min(width, sliderIcon.size - 2);
            if (width % 2 == 0) {
                --width;
            }
            int delta = (sliderIcon.size - width) / 2;
            HashMapKey key = SubstanceCoreUtilities.getHashKey(sliderIcon.size, width, colorScheme.getDisplayName(), colorScheme2.getDisplayName(), borderScheme.getDisplayName(), borderScheme2.getDisplayName(), Float.valueOf(cyclePos));
            Icon result = icons.get(key);
            if (result != null) {
                return result;
            }
            SubstanceGradientPainter painter = SubstanceCoreUtilities.getGradientPainter(slider);
            SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(slider);
            int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(slider)) / 2.0);
            Ellipse2D.Float contour = new Ellipse2D.Float(borderDelta, borderDelta, width - 2 * borderDelta - 1, width - 2 * borderDelta - 1);
            BufferedImage stateImage = SubstanceCoreUtilities.getBlankImage(sliderIcon.size - 1, sliderIcon.size - 1);
            Graphics2D g2d = stateImage.createGraphics();
            g2d.translate(delta, delta);
            painter.paintContourBackground(g2d, slider, width, sliderIcon.size - 1, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(slider));
            Ellipse2D.Float contourInner = new Ellipse2D.Float(borderDelta + borderThickness, borderDelta + borderThickness, width - 2 * borderDelta - 2 * borderThickness - 1, width - 2 * borderDelta - 2 * borderThickness - 1);
            borderPainter.paintBorder(g2d, slider, width, sliderIcon.size - 1, contour, contourInner, borderScheme, borderScheme2, cyclePos, borderScheme != borderScheme2);
            result = new ImageIcon(stateImage);
            icons.put(key, result);
            return result;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            SliderUI sliderUI = slider.getUI();
            ComponentState state = ComponentState.ACTIVE;
            if (sliderUI instanceof SubstanceSliderUI) {
                state = ComponentState.getState(((SubstanceSliderUI)sliderUI).getButtonModel(), null);
            } else {
                ButtonModel buttonModel = this.models.get(slider);
                if (buttonModel == null) {
                    buttonModel = new DefaultButtonModel();
                    buttonModel.setEnabled(slider.isEnabled());
                    RolloverControlListener listener = new RolloverControlListener(new TrackableSlider(slider), buttonModel);
                    slider.addMouseListener(listener);
                    slider.addMouseMotionListener(listener);
                    this.models.put(slider, buttonModel);
                }
                state = ComponentState.getState(buttonModel, null);
            }
            ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(slider);
            Icon iconToDraw = SliderRoundIcon.getIcon(state, prevState, slider, this);
            iconToDraw.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.size - 1;
        }

        @Override
        public int getIconHeight() {
            return this.size - 1;
        }
    }

    private static class SliderHorizontalIcon
    implements Icon,
    UIResource {
        private static LazyResettableHashMap<Icon> icons = new LazyResettableHashMap("SubstanceIconFactory.SliderHorizontalIcon");
        private int size;
        private boolean isMirrorred;
        private WeakHashMap<JSlider, ButtonModel> models = new WeakHashMap();

        public SliderHorizontalIcon(int size, boolean isMirrorred) {
            this.size = size;
            this.isMirrorred = isMirrorred;
        }

        private static Icon getIcon(ComponentState state, ComponentState prevState, JSlider slider, SliderHorizontalIcon sliderIcon) {
            float cyclePos = state.getCyclePosition();
            SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(slider, state);
            SubstanceColorScheme colorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(slider, prevState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)slider, ColorSchemeAssociationKind.BORDER, state);
            SubstanceColorScheme borderScheme2 = SubstanceColorSchemeUtilities.getColorScheme((Component)slider, ColorSchemeAssociationKind.BORDER, prevState);
            FadeTracker fadeTracker = FadeTracker.getInstance();
            int width = 2 * sliderIcon.size / 3;
            FadeState rolloverFadeState = fadeTracker.getFadeState(slider, FadeKind.ROLLOVER);
            FadeState pressFadeState = fadeTracker.getFadeState(slider, FadeKind.PRESS);
            if (rolloverFadeState != null) {
                cyclePos = rolloverFadeState.getFadePosition();
                if (rolloverFadeState.isFadingIn()) {
                    cyclePos = 1.0f - cyclePos;
                }
                width = (int)((double)sliderIcon.size * (2.0 + (double)rolloverFadeState.getFadePosition()) / 3.0);
            } else if (pressFadeState != null) {
                cyclePos = pressFadeState.getFadePosition();
                if (pressFadeState.isFadingIn()) {
                    cyclePos = 1.0f - cyclePos;
                }
                width = sliderIcon.size;
            } else {
                switch (state) {
                    case ROLLOVER_UNSELECTED: 
                    case ROLLOVER_SELECTED: 
                    case ACTIVE: 
                    case PRESSED_SELECTED: 
                    case PRESSED_UNSELECTED: {
                        width = sliderIcon.size;
                    }
                }
            }
            width = Math.min(width, sliderIcon.size - 2);
            int delta = (sliderIcon.size - width) / 2;
            HashMapKey key = SubstanceCoreUtilities.getHashKey(sliderIcon.size, width, colorScheme.getDisplayName(), colorScheme2.getDisplayName(), borderScheme.getDisplayName(), borderScheme2.getDisplayName(), Float.valueOf(cyclePos));
            Icon result = icons.get(key);
            if (result != null) {
                return result;
            }
            SubstanceGradientPainter painter = SubstanceCoreUtilities.getGradientPainter(slider);
            SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(slider);
            int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(slider)) / 2.0);
            GeneralPath contour = SubstanceOutlineUtilities.getTriangleButtonOutline(width, sliderIcon.size - 1, 2.0f, borderDelta);
            BufferedImage stateImage = SubstanceCoreUtilities.getBlankImage(sliderIcon.size - 1, sliderIcon.size - 1);
            Graphics2D g2d = stateImage.createGraphics();
            g2d.translate(delta, 0);
            painter.paintContourBackground(g2d, slider, width, sliderIcon.size - 1, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(slider));
            GeneralPath contourInner = SubstanceOutlineUtilities.getTriangleButtonOutline(width, sliderIcon.size - 1, 2.0f, borderThickness + borderDelta);
            borderPainter.paintBorder(g2d, slider, width, sliderIcon.size - 1, contour, contourInner, borderScheme, borderScheme2, cyclePos, borderScheme != borderScheme2);
            g2d.translate(-delta, 0);
            if (sliderIcon.isMirrorred) {
                stateImage = SubstanceImageCreator.getRotated(stateImage, 2);
            }
            result = new ImageIcon(stateImage);
            icons.put(key, result);
            return result;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            SliderUI sliderUI = slider.getUI();
            ComponentState state = ComponentState.ACTIVE;
            if (sliderUI instanceof SubstanceSliderUI) {
                state = ComponentState.getState(((SubstanceSliderUI)sliderUI).getButtonModel(), null);
            } else {
                ButtonModel buttonModel = this.models.get(slider);
                if (buttonModel == null) {
                    buttonModel = new DefaultButtonModel();
                    buttonModel.setEnabled(slider.isEnabled());
                    RolloverControlListener listener = new RolloverControlListener(new TrackableSlider(slider), buttonModel);
                    slider.addMouseListener(listener);
                    slider.addMouseMotionListener(listener);
                    this.models.put(slider, buttonModel);
                }
                state = ComponentState.getState(buttonModel, null);
            }
            ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(slider);
            Icon iconToDraw = SliderHorizontalIcon.getIcon(state, prevState, slider, this);
            iconToDraw.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.size - 1;
        }

        @Override
        public int getIconHeight() {
            return this.size - 1;
        }
    }

    private static class TrackableSlider
    implements Trackable {
        private JSlider slider;
        private Field thumbRectField;

        public TrackableSlider(JSlider slider) {
            this.slider = slider;
            SliderUI sliderUI = slider.getUI();
            if (sliderUI instanceof BasicSliderUI) {
                try {
                    this.thumbRectField = BasicSliderUI.class.getDeclaredField("thumbRect");
                    this.thumbRectField.setAccessible(true);
                }
                catch (Exception exc) {
                    this.thumbRectField = null;
                }
            }
        }

        @Override
        public boolean isInside(MouseEvent me) {
            try {
                Rectangle thumbB = (Rectangle)this.thumbRectField.get(this.slider.getUI());
                if (thumbB == null) {
                    return false;
                }
                return thumbB.contains(me.getX(), me.getY());
            }
            catch (Exception exc) {
                return false;
            }
        }
    }
}

