
// <ACEStransformID>urn:ampas:aces:transformId:v1.5:ACEScsc.Academy.ACES_to_ACEScg.a1.0.3</ACEStransformID>
// <ACESuserName>ACES2065-1 to ACEScg</ACESuserName>

//
// ACES Color Space Conversion - ACES to ACEScg
//
// converts ACES2065-1 (AP0 w/ linear encoding) to 
//          ACEScg (AP1 w/ linear encoding)
//



import "ACESlib.Transform_Common";



void main
(   
    input varying float rIn,
    input varying float gIn,
    input varying float bIn,
    input varying float aIn,
    output varying float rOut,
    output varying float gOut,
    output varying float bOut,
    output varying float aOut
)
{
    float ACES[3] = { rIn, gIn, bIn};

    float ACEScg[3] = mult_f3_f44( ACES, AP0_2_AP1_MAT);

    rOut = ACEScg[0];
    gOut = ACEScg[1];
    bOut = ACEScg[2];
    aOut = aIn;
}