## ARRIRAW Converter
ARRI ALEXA Input Device Transforms (IDTs) can be applied using ARRIRAW Converter (ARC). 

ARRIRAW Converter can be downloaded from:
https://www.arri.com/camera/alexa/tools/arriraw_converter/


## CTL IDTs
The IDT maker package for the ARRI ALEXA camera includes the following files:

* README.md (this file)
* v2_IDT_maker.py
* v3_IDT_maker.py
* AlexaParameters-2013-Nov-13
  * Alexa_aces_matrix.txt
  * Alexa-st-nd-aces_matrix.txt
* idt_maker_script.csh

`v2_IDT_maker.py` generates IDTs appropriate for imagery produced with SUP 2.0 firmware loaded.

`v3_IDT_maker.py` generates IDTs appropriate for imagery produced with SUP 3.0 or later firmware loaded.

The 'raw' SUP 3.0 IDTs include a variant to handle the different colorimetry produced as a side effect of using the internal ALEXA Studio ND 1.3 filter; it is assumed that somewhere upstream, the corresponding ND 1.3-specific channel gains were used before the deBayer processing.

Both scripts depend on the open-source NumPy library. If running Mac OS X 10.6 or higher, numpy is pre-installed. Users of linux systems, Windows systems, or older Mac OS X systems can find the NumPy package at:
     http://sourceforge.net/projects/numpy/files/
     
`idt_maker_script.csh` was used to generate the files in the subdirectories v2 and v3.
These directories contain a series of .ctl idts created using `v2_IDT_maker.py` and `v3_IDT_maker.py` and exist as a convenience rather than running `v2_IDT_maker.py` and `v3_IDT_maker.py`.  If any additional IDTs are required or if the validity of a CTL file in these subdirectories is in question `v2_IDT_maker.py` and `v3_IDT_maker.py` should be used.