/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2019 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package blues.libbluray;

public class Sync {
    public static final int MODE_ASYNC = 0;
    public static final int MODE_SYNC = 1;
    public static final int MODE_INSYNC = 2;

    static int mode = Sync.MODE_ASYNC;
    static int timeout = 0;

    public static void setMode(int newMode) {
        mode = newMode;
    }

    public static int mode() {
        return mode;
    }

    public static int timeout() {
        return timeout;
    }

    public static boolean modeSync() {
        return ( (mode==MODE_SYNC) || (mode==MODE_INSYNC) );
    }

    public static void setTimeout(int newTimeout) {
        timeout = newTimeout;
    }

    public static void waitTimeout() {
        throw new RuntimeException("MODE_SYNC timeout");
    }
}
