/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2019 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.io;

public abstract class FsObject {

    public String path = null;
    public String nativePath = null;

    private boolean attributesPopulated = false;
    protected long lastModifiedTime = 0;
    protected int accessFlags = 0;

    public static final int BA_EXISTS = 0x01;
    public static final int BA_REGULAR = 0x02;
    public static final int BA_DIRECTORY = 0x04;

    public static final int ACCESS_EXECUTE = 0x01;
    public static final int ACCESS_WRITE = 0x02;
    public static final int ACCESS_READ = 0x04;

    protected abstract void populateAttributes();

    public abstract int getBooleanAttributes();

    public abstract void cleanup();

    protected synchronized void callPopulateAttributes() {
        if (attributesPopulated == false) {
            populateAttributes();
            attributesPopulated = true;
        }
    }

    public long getLastModifiedTime() {
        callPopulateAttributes();
        return lastModifiedTime;
    }

    public void setLastModifiedTime(long time) {
        callPopulateAttributes();
        lastModifiedTime = time;
    }

    public int getAccessFlags() {
        callPopulateAttributes();
        return accessFlags;
    }

    public void setAccessFlags(int flags) {
        callPopulateAttributes();
        accessFlags = flags;
    }

    protected void setPath(String apath, String anativePath) {
        path = apath;
        nativePath = anativePath;
    }

    protected void setPath(FsDir parent, String name, String anativePath) {
        StringBuilder sb = new StringBuilder(parent.path.length() + name.length() + 2);
        sb.append(parent.path);
        sb.append('/');
        sb.append(name);
        path = sb.toString();
        if (anativePath != null) {
            nativePath = anativePath;
        } else {
            if (parent.nativePath != null) {
                sb = new StringBuilder(parent.nativePath.length() + name.length() + 2);
                sb.append(parent.nativePath);
                sb.append('/');
                sb.append(name);
                nativePath = sb.toString();
            }
        }
    }

    public String getNativePath() {
        return (nativePath == null) ? path : nativePath;
    }

    public String getName() {
        int ls = path.lastIndexOf('/');
        return path.substring(ls + 1);
    }

}
