#!/usr/bin/env python
# coding: UTF-8

# Translation (C) 2011 Martin Pavlík <xpavli44@gmail.com>

class tragtorLang:
    
    language = "cz"

### ERRORS

    error_in_file_single = """Při otevírání se vyskytla chyba!\n Chcete zobrazit více informací?"""
    error_in_file_multi = """Při otevírání se vyskytla %i chyby, \n Chcete zobrazit více informací?"""
    
    error_in_file_not_accessible = """### CHYBA [není_dostupné]:
    Soubor '%s' není čitelný."""
    
    error_in_file_not_accessible_explain = """Ujistěte se prosím, že byl vybrán správný soubor a že k němu máte patřičná přístupová práva.
    Někdy se se tato chyba může objevit u souborů s nulovou velikostí.
"""
    error_in_file_not_readable = """### CHYBA [nečitelné]:
    Soubor '%s' nelze zpracovat. Není možné pokračovat s nečitelným souborem."""
    
    error_in_file_not_readable_explain = """### INFO [není_čitelné]:
    
    Určitě máte nainstalovány patřičné kodeky?
    V závislosti na způsobu jakým byl zkompilován ffmpeg, je také možné, že se jedná o problém s nastaveními při kompilaci.
    
    Například většina verzí UBUNTU postrádá podporu mp3 ve ffmpeg.
    Řešením je a) vlastní kompilace zdrojového kódu ffmpeg nebo
    b) pro UBUNTU - instalace balíčků z repozitářů medibuntu pomocí funkce 
    'vynutit verzi'- ve správci balíků (synaptics). Více informací najdete na:
    
    http://ffmpeg.mplayerhq.hu/
    http://www.thedesignexperience.org/weblog/one-entry?entry_id=113488
    http://wiki.ubuntuusers.de/FFmpeg (německy)
    
    a určitě také na http://www.google.com/search?q=ffmpeg"""
    
    ffmpeg_options = """### Nastavení-FFMPEG
    
# Vaše aktuální nastavení kompilace jsou uvedena níže:
    %s

# Čitelné formáty souborů:
    %s
    
# Zapisovatelné formáty souborů:
    %s

# Čitelné audio kodeky:
    %s
    
# Zapisovatelné audio kodeky:
    %s

# Čitelné video kodeky:
    %s

# Zapisovatelné video kodeky:
    %s
"""
    error_message_title = "Chyba!"
    error_message_file_not_readable = "Zdrojový soubor, který byl vybrán není čitelný!"
    error_message_file_not_in_media = "Zdrojový soubor, který byl vybrán nelze importovat!"
    error_message_file_not_writable = "Cílový soubor, který byl vybrán nelze zapsat!"
    error_message_file_not_out_media = "Cílový soubor, který byl vybrán nelze exportovat!"
    error_message_no_opener = "Tento soubor nelze otevřít protože není nainstalováno gnome-open či kde-open."
    error_message_no_audio = "Audio stopy nenalezeny"
    error_message_no_video = "Video stopy nenalezeny"
    
    error_message_delete_failed = """Tento soubor nemohl být smazán. 
Máte potřebná oprávnění?"""
    error_message_no_manual = "Není dostupná příručka pro FFmpeg."
    
    error_button_not_in_media = "Žádný zpracovatelný zdroj"
    error_button_not_writable = "Do cílového souboru nelze zapisovat"
    error_button_not_out_media = "Cílová soubor není zpracovatelným souborem médií"
    error_button_in_as_out = "Zdroj a cíl jsou shodné"
    error_button_duration = "Vaše nastavení času jsou chybná"
    error_button_size = "Pokoušíte se vytvořit video s nulovou velikostí"
    error_button_bitrate = "Tato hodnota datového toku je neplatná"
    error_button_frame_rate = "Tato hodnota framerate je neplatná"
    error_button_sample_rate = "Tato hodnota vzorkovací frekvence je neplatná"
    error_button_channels = "Tato hodnota audio kanálů je neplatná"
    error_button_no_audio = "Pokoušíte se vytvořit audio soubor neobsahující zvuk"
    error_button_no_content = "Pokoušíte se vytvořit prázdný soubor"
    error_button_no_audio_bitrate = "Pokoušíte se vytvořit 0 kb/s audio soubor"
    error_button_no_video_bitrate = "Pokoušíte se vytvořit 0 kb/s video soubor"
    
    error_cant_proceed = "S těmito nastaveními nelze pokračovat."
        
### BUTTONS

    proceed_button_active = "Budiž světlo!"
    proceed_button_overwrite = "Tady to je... ale\nsoubor bude přepsán"
    proceed_button_inactive = "Není možné pokračovat:\n%s"
    
### INFILE TEXTAREA

    in_file_textarea_pre = """### Informace o zdrojovém souboru:
"""
    in_file_textarea_post = ""
    in_file_format_info = """
    Soubor: %s
    Velikost: %sBytů
    Kontejner: %s
    Datový tok: %s k/bs
    Délka: %s
"""
    in_file_stream_main_info = """
    Stream-ID: %s
    Formát: %s
    Kodek: %s
"""    
    in_file_stream_audio_info = """    Vzorkovací frekvence: %s Hz
    Kanály: %s
    Audio- datový tok: %s kb/s
"""
    in_file_stream_video_info = """    Metoda: %s
    Velikost: %s
    Snímků/s: %s snímků/s
"""

### INFILE

    in_file_audio_label = "Audio stopy"
    in_file_video_label = "Video stopy"
    in_file_open_label = "vybrané soubory"
    in_file_add_label = "Více"
    in_file_select_label = "Jeden"
    
    in_file_open_remove = ""
    in_file_open_id = ""
    in_file_open_file = "Soubor"
    in_file_open_size = "Velikost"
    in_file_open_container = "Formát"
    in_file_open_duration = "Délka"
    
    in_file_audio_id = "⇨"
    in_file_audio_select = "♻"
    in_file_audio_file = ""
    in_file_audio_codec = "Kodek"
    in_file_audio_sample_rate = "Vzorkovací frekvence"
    in_file_audio_bitrate = "kb/s"
    in_file_audio_channels = "Kanály"
    in_file_audio_language = "Jazyk"
    
    in_file_video_preview = "▣"
    in_file_video_id = "⇨"
    in_file_video_select = "♻"
    in_file_video_file = ""
    in_file_video_codec = "Kodek"
    in_file_video_size = "Velikost"
    in_file_video_fps = "snímků/s"
    in_file_video_method = "Metoda"
    in_file_video_language = "Jazyk"
    
    in_file_menu_path = "Cesta jako výstup"
    in_file_menu_name = "Jméno jako výstup"
    in_file_menu_meta = "Použít ID3"
    
### META COMMENT
    
    meta_comment_text = """Enkodér ffmpeg & traGtor"""
    
### QUESTIONS/CONFIRMATIONS
    
    question_title = "Potvrzení"
    question_overwrite_preset = "Opravdu chcete přepsat %s?"
    question_delete_preset = "Opravdu chcete smazat %s?"
    question_delete_in_file = "Opravdu chcete smazat soubor #%i z disku? (Nelze vrátit!)"

### TEXTLABELS

    # page-labels
    in_file_label = """Nejdříve vyberte \
soubor k převodu. Pokud se jedná o zpracovatelný \
soubor médií, obsažené audio a video stopy\
se objeví vpravo ve výběru. \
Pokud je zapnut přepínač "více", vybrané soubory \
jsou přidány do seznamu, "Jeden" nahradí vše jením souborem.\
Pro zobrazení nabídky možností klikněte pravým tlačítkem na soubor."""
    suffix_label = "Kontejner:"
    meta_label = """Upravit metadata výsledného souboru. \
Tyto informace budou uloženy uvnitř souboru a neovlivňují \
žádné hodnoty spjaté se souborem jako například název souboru. (Některé formáty toto nemusí podporovat!)"""
    proceed_label = """Pokračovat s vybraným nastavením. \
Velké tlačítko vás bude informovat o průběhu. \
Pokud je tlačítko aktivní, před pokračováním bude vyžadováno potvrzení.
Výstup z FFmpeg se objeví zde po dokončení."""
    format_video_label = "Nastavení videa"
    format_audio_label = "Nastavení audia"
    format_render_label = "Nastavení renderování"
    format_results_label = "Výsledky"
    settings_label = """Zde je možné provést některá \
základní nastavení tohoto GUI."""
    
### NOTEBOOKS

    in_file_notebook = "Zdroje"
    format_notebook = "Formát"
    meta_notebook = "Meta"
    proceed_notebook = "Pokračovat"
    settings_notebook = "Nastavení"

### TITLES

    in_file_title = "Vybrat zdroj"
    format_title = "Nastavit formát"
    meta_title = "Změnit meta"
    proceed_title = "Pokračovat"
    settings_title = "Nastavení"

### INPUT_VALUES

    meta_title_label = "Titul:"
    meta_author_label = "Autor:"
    meta_copyleft_label = "Copyright:"
    meta_comment_label = "Komentář:"
    meta_toggle_label = "Použít meta"
    
    format_width_label = "Šířka:"
    format_height_label = "Výška:"
    format_ratio_label = "Poměr:"
    format_fixed_ratio_label = "Pevný poměr:"
    format_frame_rate_label = "Snímků za sekundu:"
    format_deinterlace_label = "Rozklad:"
    
    format_audio_sample_rate_label = "Vzorkovací frekvence:"
    format_audio_bitrate_label = "Datový tok (kb/s):"
    format_audio_codec_label = "Vynutit kodek:"
    format_audio_channels_label = "Audio kanály:"
    format_2_pass_label = "2-průchody:"
    format_2_pass_no_audio_label = "Přeskočit audio:"
    format_codec_label = "Vynutit kodek:"
    format_bitrate_label = "Datový tok (kb/s):"
    format_offset_label = "Počáteční ofset / s:"
    format_duration_label = "Délka / s:"
    format_scaling_label = "Škálování:"
    format_pad_color_label = "Barva výplně:"
    format_volume_label = "Zvuk:"
    format_user_defined_label = "Přídavná nastavení:"
    format_manual_button = "příručka k FFmpeg"
    
    format_tooltip_changed = "Reset to %s"
    
### PRESETS
    
    presets_label = "Přednastavení"
    presets_container = """Nastavit kontejner
výstupního souboru"""

### FORMAT-INFO
    
    format_target_info_av = """Soubor videa obsahující zvuk a video \
o délce <b>%s</b> zabere přibližně <b>%sBytů</b> místa."""
    format_target_info_video = """Čisté video bez jakékoliv audio stopy \
o délce <b>%s</b> zabere přibližně <b>%sBytů</b> místa."""
    format_target_info_audio = """Samotný soubor audio stopy \
o délce <b>%s</b> zabere <b>%s</b> při současném nastavení."""
    format_target_info = """%s<small>

(Velikost výsledného souboru se může lišit)</small>"""
    format_target_info_nothing = """Musíte aktivovat nejméně jednu \
ze stop (audio nebo video)."""
    format_target_no_file = "Nebyl zvolen žádný platný soubor."
    
### OUTPUT/PROCEED

    proceed_folder_label = """Folder"""
    proceed_suffix_label = """Container"""
    proceed_name_label = """Name"""
    
    frame_output = """Cíl"""
    frame_proceed = """Pokračovat"""
    
    out_file_menu_path = "Cesta jako Zdroje"
    out_file_menu_name = "Jméno jako Zdroje"
    
### SETTINGS
    
    settings_language_label ="Výběr jazyka"
    settings_reset_label = "Obnovit všechna nastavení a začít znova"
    settings_reset_button = "Reset"
    settings_video_filter_label = "Volba nastavení výplně a ořezu"
    settings_bitrate_mode_label = "Select Bitrate Option"
    settings_cpu_label = "využití CPU"
    settings_progress_actions = "Action After Progress"
    settings_cleanup_2_pass_label = "Remove Log After 2-Pass"
    settings_ffmpeg_label = "FFmpeg"
    settings_tragtor_label = "traGtor"
    settings_version_label = "Informace o FFmpeg a traGtor"
    settings_stream_label = "Select Stream Separator\n(.) if use avconv, (:) if use ffmpeg"
    settings_newstream_label = "Use \"new[audio|video]\" Option"
    
### LISTS

    format_scaling_methods_list = [ "Výplň", "Ořez", "Rozostření" ]
    output_file_suffix_auto = "jak je uvedeno níže"
    cpu_usage_modes = ["Soft", "Medium", "Aggressive"]
    video_filters = ["Pad, Crop & Size (Old)",
                     "Video Filter (x:y:w:h)",
                     "Video Filter (w:h:x:y)"]
    bitrate_modes = ["-b / -ab (old)",
                     "-b:v / -b:a (new)"]
    progress_actions = ["Nothing", "Play File", "Close Progress Window",
                     "Close traGtor", "Shutdown", "Hibernate",
                     "Suspend"]
    stream_separators = [".", ":"]
                     
### SYSTEM
    
    datestring = "%Y-%m-%d %I:%M:%S %p"
    hour = "hodina"
    hours = "hodin"
    minute = "minuta"
    minutes = "minut"
    second = "sekunda"
    seconds = "sekundy"
    frames = "snímky"
    _and = "a"
    
    changed = "změněno!"
    
    title_in_file_media_files = "Čitelné média soubory"
    title_in_file_all_files = "Všechny formáty souborů"
    title_out_file_media_files = "Zapisovatelné média soubory"
    title_out_file_all_files = "Všechny formáty souborů"

### CONFIRMATION-WINDOW

    title_confirmation_window = "Potvrzení"
    label_confirmation = """Prosím zkontrolujte nastavení \
vpravo. Určité změny lze provést pomocí \
příkazové řádky pro ffmpeg."""
    label_confirm_commandline = "Příkazová řádka"
    label_confirm_in_file = "<b>Zdroj:</b> %s"
    label_confirm_in_files = "<b>Zdroje:</b> %s"
    label_confirm_out_file = "<b>Cíl:</b> %s"
    label_confirm_in_size = "(%sB)"
    label_confirm_out_size = "(~ %sB)"
    label_confirm_pad_h = "<b>Výplň:</b> přidání %i pixelů k šířce"
    label_confirm_pad_v = "<b>Výplň:</b> přidání %i pixelů k výšce"
    label_confirm_crop_h = "<b>Ořez:</b> ořez %i pixelů šířky"
    label_confirm_crop_v = "<b>Ořez:</b> ořez %i pixelů výšky"
    label_confirm_distort_h = "<b>Škálování:</b> natáhnout šířku na %i\%"
    label_confirm_distort_v = "<b>Škálování:</b> natáhnout výšku na %i\%"
    label_confirm_format = "<b>Formát:</b> %s"
    label_confirm_audio = "<b>Audio:</b> %s"
    label_confirm_audio_disabled = "vypnuto"
    label_confirm_video = "<b>Video:</b> %s"
    label_confirm_duration = "<b>Délka:</b> %s"
    label_confirm_offset = "<b>Začátek:</b> %s"
    label_confirm_size = "<b>Velikost:</b> %s"

### PROCESS

    title_progress_window = "Probíhá..."
    title_progress_window_finished = "Dokončeno."
    title_progress_window_error = "Chyba!"
    title_progress_window_pass = "(průchod %i)"
    label_progress = "Tento soubor se zpracovává..."
    text_progress = "Stav souboru\n%s"

    label_progress_size = "<b>Velikost</b>"
    label_progress_bitrate = "<b>Datový tok</b>"
    label_progress_time = "<b>Čas</b>"
    label_progress_frame = "<b>Snímek</b>"
    label_progress_quantizer = "<b>Kvantovač</b>"
    label_progress_video = "<b>Video</b>"
    label_progress_audio = "<b>Audio</b>"
    label_progress_headers = "<b>Hlavičky</b>"
    label_progress_overhead = "<b>Režie</b>"
    
    label_progress_error = "<b>Chyba!</b>"
    label_progress_error_explain = "Zdá se, že se vyskytla chyba. \
Prosím podívejte se na textový výstup ffmpeg."
    label_progress_actions = "Finally"

### HELP-WINDOW

    title_help_window = "Nápověda"
    
### UOE window
    
    label_pass_1 = "Průchod 1"
    label_pass_2 = "Průchod 2"
    label_single = "Nastavení"
    label_UOE = """Zde upravte svá uživatelská nastavení.
Nepoužívejte žádná zalomení řádků
Pokud máte zapnuty
2 průchody obě
pole budou zřetězeny
pomocí roury | v
políčku nastavení."""
