/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.1";
	this.minVersion = "2.0.2a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.123video.nl/";
	this.ID = "123video.nl";
	this.caption = "123video";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_XML = "http://www.123video.nl/initialize_player_v3.asp";
	const XML_PARAMS  = "<movie><id>%1</id></movie>";
	// video information
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get video title
	result.title = copyBetween(html, "?title=", "&amp;");
	// get the video ID
	var videoID = copyBetween(html, "mediaSrc=", "&");
	// get the video xml
	var xml = http.downloadWebpagePost(URL_GET_XML, strFormat(XML_PARAMS, videoID));
	// get the host IP
	var hostIP = copyBetween(xml, "MediaIP=\"", "\"");
	// get the FLV url
	result.URL = strFormat("http://%1/%2/%3.flv", hostIP, strCopy(videoID, 0, 3), videoID);
	// add the referer header
	result.headers = "Referer=" + url + "|Connection=keep-alive";
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x02,0x16,0x49,0x44,0x41,0x54,0x78,0xda,0xc5,0x93,0xdf,0x4b,0x53,
		0x51,0x00,0xc7,0x2f,0xf4,0xd0,0x4b,0x50,0x0f,0xfd,0x1f,0xbd,0x0a,0x3d,0xf4,0x10,
		0x11,0x88,0x48,0xeb,0xa9,0x6c,0x0f,0x91,0x6e,0x6d,0xae,0x1f,0x8e,0x99,0xd6,0xbd,
		0xdb,0x84,0x31,0xd9,0x70,0x9b,0xb7,0xd9,0x88,0x45,0xe6,0x6d,0x3d,0xac,0x4d,0x17,
		0x62,0xed,0xba,0x28,0x62,0x69,0x3f,0x6e,0xd3,0xd8,0x66,0xda,0x9a,0x7a,0x4b,0xdd,
		0x15,0x09,0x16,0x41,0x83,0xc2,0xca,0xce,0xb7,0x73,0x6f,0x5c,0xb5,0x90,0x7a,0x88,
		0xe8,0xe1,0xc3,0xf7,0x9c,0xef,0xe1,0x7c,0x38,0x1c,0xce,0x61,0x00,0xfc,0x15,0xff,
		0x46,0x40,0x08,0xd9,0xbe,0x45,0xb7,0x63,0x4b,0xc1,0xd8,0xdc,0xf3,0xe0,0xe9,0xa4,
		0x4f,0x6e,0x4d,0x74,0xbf,0x55,0x53,0x9c,0x7e,0x94,0x20,0x5f,0x3f,0x1d,0x24,0xb3,
		0x81,0x12,0x79,0xd9,0x35,0x4d,0x4a,0x5d,0x32,0x99,0xe3,0x4b,0x64,0xed,0xf3,0x9e,
		0xa5,0xc1,0x41,0xa1,0xc8,0x71,0x72,0x91,0x65,0xe5,0x29,0xb7,0x5b,0xfe,0x50,0x2e,
		0x9f,0x61,0x5a,0x6f,0x76,0x2b,0xfb,0xf8,0x13,0x18,0xca,0xdf,0xc3,0xfe,0xb0,0x09,
		0x47,0xfa,0x3b,0x64,0x52,0x2b,0x1f,0xc7,0x84,0x11,0x58,0xb8,0x4a,0xb9,0x06,0x48,
		0x87,0x41,0x3e,0x2a,0xed,0x0f,0xeb,0xeb,0x31,0xe3,0xf5,0xa2,0xcc,0xf3,0xc8,0x99,
		0x4c,0x98,0x8f,0x46,0x25,0x2a,0xf0,0x2a,0x86,0x2b,0x6d,0x38,0x3f,0x7c,0x11,0x46,
		0xe1,0x02,0x15,0x9c,0xab,0x69,0x82,0xfc,0x49,0x60,0x79,0x08,0xa8,0x8e,0x03,0x05,
		0x9b,0x2a,0x30,0x8e,0x35,0x36,0xe2,0x69,0x53,0x13,0x4a,0x3d,0x3d,0x58,0x1e,0x19,
		0xd9,0x10,0xec,0x72,0xec,0x45,0xc3,0xe5,0x53,0x38,0xd0,0x67,0x56,0x05,0xab,0x9a,
		0x60,0x86,0xa3,0x82,0x14,0xb0,0xd0,0x0f,0x4c,0x1c,0x53,0x05,0x47,0xc7,0x0d,0x06,
		0xac,0x64,0x32,0x78,0x3d,0x30,0x80,0xa5,0x44,0xe2,0x87,0x60,0xb8,0xf0,0xe0,0xee,
		0xa1,0x68,0x9b,0x42,0x79,0xaf,0xe6,0x8d,0x67,0xb7,0x45,0xf2,0xa5,0x56,0x47,0xa6,
		0xec,0x8b,0x24,0x6f,0x79,0x45,0x51,0xc8,0x8b,0xf6,0x45,0x7a,0x2f,0x75,0xb3,0x97,
		0xfa,0x0a,0xb9,0xe6,0x66,0x25,0xd7,0xd2,0xa2,0xa8,0xf9,0x6e,0x72,0xd2,0xc3,0x54,
		0x2a,0x95,0xb3,0xe2,0xe8,0xe8,0x93,0x74,0x3a,0x7d,0x4b,0x14,0xc5,0xc7,0x34,0x25,
		0x1d,0x3a,0xbf,0x43,0x33,0xa5,0xb3,0x79,0x3d,0x93,0xc9,0x48,0xd5,0x6a,0xd5,0xcd,
		0xc4,0x62,0x31,0xc9,0x6c,0x36,0x43,0xc7,0x6e,0xb7,0x6b,0xe9,0x70,0x38,0xd6,0xbb,
		0x5f,0xd7,0x2d,0x16,0x8b,0x36,0xa6,0xc2,0xd4,0xba,0xc0,0xe5,0x72,0x21,0x10,0x08,
		0xc0,0x4b,0x6f,0x39,0x12,0x89,0x20,0x99,0x4c,0x22,0x1e,0x8f,0x23,0x14,0x0a,0x21,
		0x1c,0x0e,0x6b,0x1b,0x84,0xeb,0x02,0x04,0x41,0x80,0xcd,0x66,0xd3,0xe6,0xea,0xa9,
		0x18,0x5a,0xbc,0xd1,0xed,0x3e,0x9f,0x0f,0x2c,0xcb,0x22,0x18,0x0c,0x6a,0xf8,0xfd,
		0x7e,0x78,0x3c,0x1e,0x4d,0xda,0xd1,0xd9,0x09,0xa7,0xcb,0x89,0x5e,0xbe,0x17,0x56,
		0xab,0x75,0x43,0x90,0xcd,0x66,0xef,0x73,0x1c,0x87,0xdf,0xc1,0x72,0xec,0x37,0x9a,
		0xab,0x3f,0xf5,0x4e,0x6e,0xad,0x58,0x2c,0x46,0xb4,0x67,0x4b,0xd9,0xfd,0x07,0x76,
		0x52,0xb6,0x6d,0xee,0xf4,0xa7,0xfd,0xff,0x7f,0xe3,0x77,0xd3,0x79,0xd0,0x2b,0xbe,
		0xb8,0x40,0xc3,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
