/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
this.version = "1.0.1";
	this.minVersion = "2.3.1";
	this.author = "Xesc & Technology 2014";
	this.website = "http://www.atom.com/";
	this.ID = "atom.com";
	this.caption = "Atom";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_FEED = "http://www.atom.com/atom/feed/rss/?uri=%1";
	// init result
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get the uri
	var uri = copyBetween(html, "contentUri: '", "'");
	// download feed
	var feed = http.downloadWebpage(strFormat(URL_GET_FEED, uri));
	// get video title
	result.title = copyBetween(feed, "<title>", "</title>");
	// get flv xml url
	var mediaContent = copyBetween(feed, "<media:content", "/>");
	var xmlUrl = strReplace(copyBetween(mediaContent, 'url="', '"'), "&amp;", "&");
	// download flv xml
	var xml = http.downloadWebpage(xmlUrl);
	var item = "";
	// get flv url (get the max bitrate available)
	if (xml.toString().indexOf('bitrate="1000"') != -1)
		item = copyBetween(xml, 'bitrate="1000"', '</src>');
	else if (xml.toString().indexOf('bitrate="700"') != -1)
		item = copyBetween(xml, 'bitrate="700"', '</src>');
	else if (xml.toString().indexOf('bitrate="500"') != -1)
		item = copyBetween(xml, 'bitrate="500"', '</src>');
	else // we assume which is 300 or only one bitrate avaialbe
		item = copyBetween(xml, '<src>', '</src>');
	// get the video URL
	result.URL = copyBetween(item, "CDATA[", "]]");
	// RTMPE is not supported by versions of xVST previous to 2.4.1
	if (programVersionNumber() < 241) result.URL = strReplace(result.URL, "rtmpe://", "rtmp://");
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x02,0x1e,0x49,0x44,0x41,0x54,0x78,0xda,0xa5,0x93,0xeb,0x4b,0xd3,
		0x01,0x14,0x86,0xf7,0x21,0x08,0x89,0x6e,0x33,0xb2,0x45,0xb5,0xe9,0x96,0x41,0x41,
		0x4a,0xd2,0x87,0xc2,0x18,0x93,0x98,0x05,0x51,0x11,0xd8,0x22,0x21,0x74,0x51,0x39,
		0x9d,0x19,0x1a,0xd3,0x0c,0xc2,0x30,0xba,0xaa,0x99,0xa5,0x91,0xd2,0x85,0xac,0x40,
		0x66,0x32,0xc1,0xa6,0xe6,0x87,0xa2,0x0b,0x12,0x8b,0x56,0x5b,0x17,0x5b,0xea,0x56,
		0x56,0x6a,0xb8,0x99,0xd3,0x4c,0xb7,0xf5,0x7b,0x1a,0xec,0xc3,0xc0,0x88,0x64,0x3d,
		0x7f,0xc0,0x73,0x0e,0xe7,0xbc,0xaf,0x88,0xff,0xe4,0x4f,0xc1,0xaf,0x89,0xc8,0x04,
		0xfe,0xfe,0xf7,0x74,0x55,0xec,0xe1,0xbe,0x76,0x0d,0x1f,0x2e,0xee,0x23,0x30,0xf0,
		0x0e,0x7c,0x5e,0xf0,0xff,0x98,0x86,0xe0,0xe7,0x08,0xcf,0x0e,0x2b,0x39,0x24,0x17,
		0x63,0x50,0xaa,0xc8,0x57,0x44,0xd3,0x96,0xbe,0x02,0xd3,0xee,0x04,0x5a,0x33,0x93,
		0xe8,0xab,0x2f,0x44,0x18,0xea,0x65,0xd4,0xd2,0x44,0x4f,0x6d,0x1e,0x5f,0x1a,0x4a,
		0x82,0x03,0xbb,0xc2,0x82,0x80,0xcb,0xc2,0xb9,0xd5,0x51,0xd4,0x15,0x97,0x00,0x70,
		0xeb,0x78,0x29,0x5a,0x99,0x94,0x53,0x1a,0x0d,0x45,0x2a,0x15,0x05,0xcb,0xa2,0x68,
		0x49,0x8b,0xa3,0x3c,0x69,0x2e,0x7a,0x59,0x34,0x79,0x4b,0xa2,0x68,0x4f,0x8f,0x67,
		0xd2,0xf5,0x22,0x24,0x10,0xdc,0x4e,0x1a,0xb7,0xc7,0x92,0xbf,0x41,0x49,0x73,0xf5,
		0x65,0x5c,0x36,0x1b,0xc3,0x83,0x83,0x00,0x08,0x02,0xdc,0xab,0xbd,0x4a,0xb1,0x5a,
		0x4d,0x75,0x6e,0x70,0x7a,0x8f,0x93,0xc7,0x26,0x33,0xb9,0x41,0x91,0xe3,0x42,0x26,
		0x22,0x81,0x10,0xdf,0xcd,0x65,0xb4,0x6c,0x5d,0x48,0xc6,0x6c,0x11,0x77,0x2b,0x2a,
		0x99,0x4a,0x9f,0xa3,0x9b,0xee,0x97,0x36,0x00,0x7c,0xfe,0x00,0x39,0x2b,0xe3,0xb1,
		0x14,0xa9,0x43,0x1b,0x8c,0x3c,0xbd,0x4d,0x5b,0x46,0x22,0xe7,0xd7,0x8a,0xd1,0xce,
		0x9f,0x81,0xf1,0x6c,0x39,0x10,0x66,0xc0,0xf5,0x91,0x03,0x8a,0x58,0xb2,0xe3,0x24,
		0x54,0x65,0x1f,0xe4,0xe8,0xe6,0x2d,0x9c,0x5e,0x35,0x13,0x77,0x7b,0x0d,0xa2,0xf1,
		0xd7,0x1d,0xdc,0x50,0xce,0x43,0x9f,0x98,0x80,0xb1,0xb2,0x9a,0x47,0x8d,0x4d,0x8c,
		0x7a,0x3c,0x78,0xdd,0x43,0x38,0xed,0x6f,0xb0,0x3e,0x7c,0x82,0x61,0xe3,0x26,0xae,
		0x24,0x47,0x63,0x2d,0x54,0x52,0xa7,0x5a,0x84,0x71,0x9b,0x8c,0xaf,0x0d,0xc7,0x10,
		0xfc,0x13,0x88,0xec,0x27,0x77,0x92,0x23,0x97,0xe0,0xea,0x72,0x00,0x61,0x2e,0x65,
		0xe9,0xd8,0x2b,0x11,0x53,0x20,0x9b,0xc5,0x75,0xa5,0x98,0x6f,0xa6,0x33,0x30,0x39,
		0x06,0x1e,0x27,0x78,0xfb,0xc3,0x6f,0x7c,0xa0,0x5b,0x87,0x21,0x79,0x3d,0x53,0x39,
		0x91,0xb6,0x8b,0x3b,0xa9,0x31,0xb8,0x4d,0xa5,0xf8,0x9c,0x96,0xbf,0xe7,0xa0,0xbb,
		0x46,0x87,0x7e,0xe9,0x1c,0x3a,0xcd,0x1d,0x40,0x88,0x1e,0xfb,0x5b,0x74,0x0a,0x29,
		0xcf,0x8f,0xa4,0xfe,0x3b,0x89,0xbe,0xcf,0x76,0xcc,0x1a,0x39,0x3a,0xe9,0x02,0xca,
		0xb4,0xfb,0xa9,0xca,0xc9,0x23,0x6b,0xb9,0x8c,0xfa,0x14,0x31,0xe3,0xaf,0x5a,0xa7,
		0x17,0xe5,0xc9,0x5e,0x0b,0xb6,0xd2,0x1d,0xdc,0x54,0x2f,0xe6,0x5a,0x4a,0x0c,0x9d,
		0x05,0x2a,0xc6,0xac,0x2d,0x11,0x94,0x69,0xf8,0x53,0xe8,0x48,0x82,0x3f,0x82,0x36,
		0x46,0xc8,0x6f,0x3d,0xae,0x58,0xb5,0x79,0x16,0x55,0x86,0x00,0x00,0x00,0x00,0x49,
		0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
