/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.bebo.com/";
	this.ID = "bebo.com";
	this.caption = "Bebo";
	this.adultContent = false;
	this.aduiSite = false;
}

function getVideoInformation(url)
{
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// check if is an embeded youtube video
	if (strIndexOf(html, "http://www.youtube.com/") != -1)
		return getVideoFromYoutube(html);
	else if (strIndexOf(html, "http://www.motionbox.com/") != -1) // check if is a embeded motionbox video
		return getVideoFromMotionbox(html);
	else // unknown video source
		return new VideoDefinition();
}

function getVideoFromYoutube(html)
{
	// check if youtube plugin is installed
	if (isPluginInstalled("youtube") == true)
	{
		var youtubeUrl = copyBetween(html, "http://www.youtube.com/", "&quot;");
		return executePlugin("youtube", "http://www.youtube.com/" + youtubeUrl);
	}
	else // youtube plugin not installed
		return new VideoDefinition();
}

function getVideoFromMotionbox(html)
{
	const URL_GET_PREXML = "http://www.motionbox.com/external/hd_player/type=hd,video_uid=%1,autoPlay=true";
	const URL_GET_XML = "http://www.motionbox.com/v1/videos/%1/player_manifest.xml?api_privacy_token=%2&country%5Fcode=US&referrer=%3";
	// init result
	var result = new VideoDefinition();
	// get the video title
	result.title = copyBetween(html, "<h3>", "</h3>");
	// get video_uid
	var video_uid = copyBetween(html, "mbox_player_", "&");
	// download pre-xml
	var http = new Http();
	var preXml = http.downloadWebpage(strFormat(URL_GET_PREXML, video_uid));
	// get api_privacy_token
	var api_privacy_token = copyBetween(preXml, "api_privacy_token%3D", "\"");
	// referrer
	var referrerBlock = copyBetween(html, "<div class=\"video-main\">", "</iframe>");
	var referrer = cleanUrl(copyBetween(referrerBlock, "src=\"", "\""));
	// get final xml
	var xml = http.downloadWebpage(strFormat(URL_GET_XML, video_uid, api_privacy_token, referrer));
	// get flv url
	result.URL = copyBetween(xml, "<hd-url>", "</hd-url>");
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x01,0xcb,0x49,0x44,0x41,0x54,0x78,0xda,0x85,0x53,0xab,0x72,0x83,
		0x40,0x14,0x8d,0x8a,0x88,0x40,0x20,0x10,0xf9,0x80,0x88,0x7c,0x40,0x44,0x44,0x44,
		0x44,0x45,0x45,0x45,0x65,0x65,0x45,0x45,0x44,0x44,0x44,0x45,0x3e,0x20,0x22,0x1f,
		0x90,0x8f,0xa8,0x40,0x20,0x10,0x15,0x15,0x08,0x44,0x04,0x02,0x51,0x81,0x58,0x81,
		0x58,0x81,0x40,0x20,0x10,0x88,0xdc,0x9e,0x7b,0xba,0x09,0xed,0x0c,0x9d,0xee,0xcc,
		0x19,0x58,0x76,0xcf,0x63,0xf7,0x5e,0x46,0x43,0xe3,0x63,0x32,0x91,0x4f,0xcf,0x23,
		0x32,0x20,0xc5,0x3c,0x02,0x46,0xff,0x0c,0x12,0x9b,0x20,0x90,0x2e,0x98,0x4a,0xed,
		0xfb,0x52,0x7a,0xbe,0x18,0x08,0x14,0x4e,0x2c,0xc1,0xfa,0xdb,0x5f,0x42,0x70,0x22,
		0xb1,0xd9,0x6c,0xc5,0xe2,0xdd,0x38,0x52,0x0e,0x9c,0x27,0x9e,0xa8,0x78,0xa4,0x18,
		0x10,0xa1,0x33,0x5d,0x5f,0x5e,0xe4,0x72,0xb9,0x88,0xdd,0xed,0x7a,0x32,0xd6,0x62,
		0x47,0x0a,0xc7,0x8a,0x01,0x11,0x8d,0x5d,0x23,0x6e,0xf5,0xba,0xa7,0x40,0xb9,0xdd,
		0x92,0x9c,0xdd,0xdf,0xcb,0xe7,0xf1,0x28,0x67,0x08,0x47,0x30,0xb8,0x26,0x88,0x1d,
		0x6e,0xee,0x2d,0x16,0x11,0x5b,0x9d,0x29,0x60,0x40,0xd0,0xf3,0x96,0x51,0xa4,0x73,
		0xa2,0xab,0x1b,0xc9,0xf1,0xfd,0x1d,0xdf,0x95,0x73,0xbe,0x8a,0x20,0xaa,0x5e,0x18,
		0xcf,0x5c,0x6e,0x36,0xdc,0x9c,0x3f,0x3d,0xdd,0xe2,0xbe,0xaf,0xd7,0x92,0x3e,0x3f,
		0x4b,0x5b,0x55,0xd2,0x75,0x9d,0x64,0x77,0x77,0xac,0x0a,0xab,0xe3,0x04,0x78,0xdb,
		0xfa,0x2c,0x74,0x63,0xdb,0x4a,0x8a,0x24,0x91,0x73,0x4a,0xf8,0x04,0x66,0x33,0xae,
		0xd9,0x30,0xa4,0x3b,0x8e,0x48,0xf0,0xf6,0x8d,0x9b,0xa8,0x73,0xd3,0x34,0x92,0xee,
		0xf7,0x12,0x8f,0xbf,0x63,0x66,0x0e,0xea,0x66,0xe3,0x98,0xeb,0x39,0xde,0x0b,0xc7,
		0x1b,0xa5,0x3a,0x71,0xa5,0x4a,0x96,0x4b,0xa9,0x10,0xb5,0x17,0x70,0x0d,0xa5,0x8e,
		0x98,0xdb,0x24,0x91,0xca,0x18,0x12,0xad,0xeb,0x93,0x51,0xe4,0x36,0x69,0xcc,0x10,
		0x28,0xb3,0x4c,0x6c,0x51,0x48,0x1c,0x04,0x74,0x85,0x1b,0x05,0xcc,0x6a,0x45,0x71,
		0x7b,0x3a,0xf1,0xc2,0xb5,0x72,0x4c,0xa0,0x23,0xf9,0xd1,0x24,0xe9,0xc3,0xa3,0x6e,
		0xa4,0x48,0x71,0x38,0x88,0x41,0x69,0x4b,0x90,0xae,0xdf,0xea,0xf9,0x9c,0x25,0x47,
		0xdf,0xf4,0x7d,0xf0,0xd6,0xd7,0x97,0x49,0x32,0x88,0x20,0x89,0x92,0x7a,0xa0,0xa4,
		0xed,0x62,0x29,0x9d,0x92,0xa7,0x53,0x8a,0xfc,0xea,0xc6,0x70,0xdc,0xdf,0x7a,0x0a,
		0xf0,0xfc,0x8b,0x85,0x18,0x94,0xd1,0xce,0xe6,0xd2,0x68,0xab,0xe3,0xdc,0x17,0x90,
		0x5b,0x3f,0x18,0xfe,0x1f,0x22,0x27,0x90,0xbb,0xff,0x80,0x97,0xc5,0x3e,0x61,0x64,
		0x3a,0x37,0x3e,0x9c,0xff,0x1b,0x4e,0xe4,0x76,0xdb,0x95,0x47,0x0c,0x12,0xbf,0x00,
		0xab,0x68,0xdc,0x44,0x63,0x03,0xc3,0x04,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,
		0xae,0x42,0x60,0x82);
}
