/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.1";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2014";
	this.website = "http://videos.cinemavip.com/";
	this.ID = "cinemavip.com";
	this.caption = "CinemaVIP";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_XML = "%1/player_config.xml";
	// video information
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// Get the video title
	result.title = copyBetween(html, "<title>", "&lt;");
	// get the flv pre-path
	var xml = http.downloadWebpage(strFormat(URL_GET_XML, url));
	// get the flv url
	result.URL = cleanUrl(copyBetween(xml, "<file>", "</file>"));
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x03,0x00,0x00,0x00,0x28,0x2d,0x0f,
		0x53,0x00,0x00,0x00,0x60,0x50,0x4c,0x54,0x45,0x05,0x19,0x23,0x06,0x33,0x40,0x2b,
		0x4e,0x58,0x50,0x77,0x81,0x51,0x6c,0x74,0x55,0x80,0x8c,0x66,0x82,0x8b,0x69,0x94,
		0x9e,0x6e,0x8c,0x93,0x71,0x95,0x9e,0x76,0x84,0x87,0x77,0x8e,0x93,0x77,0x99,0xa1,
		0x86,0xa6,0xaf,0x8d,0x97,0x98,0x92,0xa0,0xa3,0x97,0xa8,0xad,0x9d,0xad,0xb2,0x9d,
		0xb5,0xbc,0xa7,0xb9,0xc0,0xb3,0xbd,0xc1,0xb8,0xca,0xd0,0xc0,0xc7,0xc8,0xc5,0xd4,
		0xd8,0xd6,0xd9,0xda,0xde,0xe4,0xe6,0xe7,0xeb,0xec,0xef,0xf2,0xf3,0xf5,0xf6,0xf7,
		0xf7,0xf9,0xf9,0xfb,0xfc,0xfd,0xff,0xff,0xff,0xe0,0xe3,0xdb,0x36,0x00,0x00,0x00,
		0xa9,0x49,0x44,0x41,0x54,0x18,0x19,0x05,0xc1,0x81,0x4e,0x02,0x31,0x10,0x45,0xd1,
		0x3b,0x6f,0xa6,0xdd,0x22,0x06,0xa3,0xd1,0xf0,0xff,0xdf,0xa7,0x11,0x44,0x44,0xb7,
		0xcb,0xb4,0x9e,0x63,0x66,0xf1,0x5c,0x45,0xde,0x3d,0x80,0x5c,0x43,0xaf,0x0d,0xe0,
		0xfb,0xeb,0xe1,0x0d,0x00,0xbd,0x34,0x00,0xa4,0x00,0x70,0x79,0x1b,0x6e,0xbd,0xab,
		0x96,0x9d,0xf7,0x1e,0xeb,0xcd,0xf3,0x52,0xeb,0xe7,0xb9,0xe5,0xbb,0xda,0xe9,0x7c,
		0xbd,0x76,0x89,0xce,0x1f,0xda,0xd8,0xd8,0x98,0x7b,0x53,0x70,0x4f,0x14,0x60,0xc8,
		0x9e,0x0e,0x45,0x66,0x7d,0x9b,0x12,0x00,0xd3,0x29,0xaa,0x36,0x3a,0x7b,0x03,0x00,
		0x48,0x29,0xb8,0xb0,0x00,0x00,0xe0,0xe2,0x71,0x0e,0x73,0x26,0x09,0xfc,0xe6,0x2a,
		0x16,0x9b,0xbb,0x82,0xb3,0x80,0xf5,0x8f,0x0c,0xea,0x31,0x8b,0xd1,0x8e,0x01,0x1c,
		0xe2,0x16,0x50,0x61,0x5a,0x04,0x30,0x69,0xc4,0x69,0xd6,0x82,0x01,0xe0,0xd8,0x18,
		0x3e,0x6f,0x3f,0x43,0x26,0x80,0x68,0x8d,0xfc,0x07,0x32,0x26,0x40,0x91,0xa6,0xe0,
		0x9f,0x4c,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
