/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "2.0.4";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://video.google.com/";
	this.ID = "video.google.";
	this.caption = "Google Video";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_SHEET = "http://video.google.com/videohosted?docid=%1";
	// init result
	var result = new VideoDefinition();
	// get the docid
	var docid = getUrlParam(url, "docid");
	// get the video-sheet
	var http = new Http();
	var html = http.downloadWebpage(strFormat(URL_GET_SHEET, docid));
	// get video title
	result.title = copyBetween(html, "<title>", "</title>");
	// delete the google video tag
	result.title = strReplace(result.title, "- Google Video", "");
	// get flv url
	result.URL = copyBetween(html, "videoUrl", "\\");
	// get the separator token
	var sep = strIndexOf(result.URL, "http");
	result.URL = strRemove(result.URL, 0, sep);
	// clean the video URL
	result.URL = cleanUrl(result.URL);
	// return the video information
	return result;
}

function searchVideos(keyWord, pageIndex)
{
	const URL_SEARCH = "http://www.google.com/search?q=%1&start=%2&hl=%3&tbs=vid:1";	
	const HTML_SEARCH_START = '<ol>';
	const HTML_SEARCH_FINISH = "</ol>";
	const HTML_SEARCH_ITEM_START = "<table ";
	const HTML_SEARCH_ITEM_END = "</table>";
	const HTML_SEARCH_SUMMARY_START = '<div id=resultStats>';
	const HTML_SEARCH_SUMMARY_END = "</div>";
	// replace all spaces for "+"
	keyWord = strReplace(keyWord, " ", "+");
	pageIndex = (pageIndex - 1) * 10;
	// init search results object
	var searchResults = new SearchResults();
	// init http object
	var http = new Http();
	var html = http.downloadWebpage(strFormat(URL_SEARCH, keyWord, pageIndex, searchResults.getUserLanguage()), false);
	// get the search summary
	searchResults.setSummary(copyBetween(html, HTML_SEARCH_SUMMARY_START, HTML_SEARCH_SUMMARY_END));
	// get results html block
	var htmlResults = copyBetween(html, HTML_SEARCH_START, HTML_SEARCH_FINISH);
	// if we found some results then...
	if (htmlResults != "")
	{
		var block = "";
		// iterate over results
		while ((block = copyBetween(htmlResults, HTML_SEARCH_ITEM_START, HTML_SEARCH_ITEM_END)) != "")
		{
			parseResultItem(searchResults, block);
			htmlResults = strRemove(htmlResults, 0, block.toString().length);
		}
		// get last result
		parseResultItem(searchResults, htmlResults);
	}
	// return search results
	return searchResults;
}

function parseResultItem(searchResults, html)
{
	var videoUrl, imageUrl, title, description, duration, rating;
	// get url and title block info
	var tmp = copyBetween(html, "<h3 class=r>", "</h3>");
	videoUrl = copyBetween(tmp, '<a href="', '"');
	title = em2b(copyBetween(tmp, ">", "</a>"));
	// get description and duration
	tmp = copyBetween(html, "<div>", "</div>");
	description = em2b(copyBetween(tmp, "<br>", "<br>"));
	duration = duration2Sec(copyBetween(tmp, '<span style="nobr">', '</span>'));
	// unaviable info
	imageUrl = "";
	rating = 0;
	// add to results list (if has info)
	if (title != "") searchResults.addSearchResult(videoUrl, imageUrl, title, description, duration, rating);
}

function em2b(html)
{
	return strReplace(strReplace(html, "</em>", "</b>"), "<em>", "<b>");
}

function duration2Sec(duration)
{
	var num = getToken(duration, " ", 0);
	var unit = getToken(duration, " ", 1);
	// convert to seconds
	if (unit == "min") return num * 60;
	else if (unit == "sec") return num;
	// impossible detect it
	return 0;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x00,0x09,0x70,0x48,0x59,0x73,0x00,0x00,0x0b,0x13,0x00,0x00,0x0b,
		0x13,0x01,0x00,0x9a,0x9c,0x18,0x00,0x00,0x03,0x06,0x49,0x44,0x41,0x54,0x38,0x11,
		0x05,0xc1,0x4b,0x68,0x9c,0x55,0x18,0x80,0xe1,0xf7,0x3b,0xe7,0xff,0x27,0x93,0xc9,
		0xe4,0x36,0x99,0xa4,0x09,0x6d,0x6c,0x6c,0x22,0x0d,0x4a,0x16,0x6d,0x44,0x21,0x48,
		0x03,0x56,0xdb,0x2e,0xbc,0x81,0x52,0x5c,0x58,0x5b,0x10,0xd4,0xad,0xba,0xec,0xb6,
		0x6a,0x37,0x6e,0x14,0x37,0xad,0x17,0xdc,0xc4,0x22,0xa2,0x88,0x20,0x06,0x09,0x08,
		0xb5,0xf5,0x82,0xb7,0xd8,0x1a,0xa3,0x29,0x24,0xa4,0x4d,0xa3,0x31,0xa6,0x33,0xe9,
		0xcc,0x64,0xfe,0x39,0x97,0xcf,0xe7,0x01,0xc0,0x79,0xd5,0x1f,0x97,0x56,0x75,0xe4,
		0xe4,0x8c,0x26,0x8f,0x7c,0xa0,0xaf,0x7d,0x3c,0xaf,0x41,0xbd,0x66,0xd5,0x5b,0x7a,
		0x71,0x7a,0x4a,0x7f,0x17,0xb4,0x65,0x8c,0x06,0xd0,0x80,0xd1,0x86,0xa0,0x5b,0xa0,
		0x00,0xc6,0x3b,0x55,0x6b,0xe1,0xcc,0x85,0x05,0x56,0x9a,0x7d,0xc4,0x5d,0xf7,0x70,
		0xf6,0x8b,0x7f,0x59,0x5e,0x6f,0x90,0xeb,0xec,0x64,0xf2,0xed,0xf3,0x94,0x3a,0x0a,
		0xd8,0x18,0x11,0xb1,0x20,0x11,0x80,0x48,0xc2,0x8a,0x41,0x8d,0x4d,0x20,0x78,0xcf,
		0xd5,0x7f,0x22,0x14,0xbb,0x89,0xd6,0xb2,0xbd,0x93,0xf2,0xe1,0xf7,0x2b,0x80,0x25,
		0x3f,0x7e,0x37,0xd9,0xd4,0x03,0x78,0x84,0x68,0x02,0x1e,0xa1,0xa5,0x16,0x15,0x8f,
		0x46,0x30,0x1a,0x21,0x91,0x84,0x5d,0x3d,0x79,0x4c,0x2b,0x62,0xc8,0x30,0x62,0xb9,
		0xba,0xec,0x41,0x3c,0x62,0x21,0x74,0x16,0x70,0x58,0x6c,0x84,0x44,0x0d,0x56,0x02,
		0x2d,0x05,0x67,0x2c,0x89,0x98,0x08,0xc0,0xd1,0x89,0x32,0x97,0xfe,0x58,0x27,0x69,
		0xeb,0x25,0xc6,0x0c,0x63,0x12,0x22,0x16,0x93,0xc1,0xc6,0xc2,0x22,0x6b,0x43,0x86,
		0x5b,0x9d,0xbd,0xa4,0x2d,0x18,0xa8,0xd4,0xe8,0xdf,0x76,0x38,0x0d,0x24,0xd7,0x56,
		0x2b,0x8c,0xde,0x51,0xe2,0xf9,0x63,0x63,0xcc,0x5c,0xbc,0xce,0xe2,0xdf,0x55,0xba,
		0xda,0x23,0xa7,0xa6,0xf7,0x20,0x08,0xe7,0x66,0xdf,0xe1,0xcc,0xd1,0x26,0xd7,0xef,
		0x3a,0x80,0x95,0x1c,0x21,0x44,0xda,0x1b,0x8e,0x03,0xd7,0x76,0x78,0xe2,0xf2,0x2a,
		0xb2,0xff,0xd9,0xf7,0xf5,0xd5,0x53,0xf7,0xf3,0xe4,0xf4,0x38,0x95,0xba,0xe3,0xb3,
		0x9f,0xd6,0x98,0x1a,0xed,0x66,0x74,0xb8,0x97,0xb3,0xb3,0xe7,0x39,0xfd,0xc3,0x5b,
		0xd8,0xc1,0x6e,0x88,0x4a,0x88,0x01,0x30,0x88,0x13,0xd4,0xa4,0x48,0xcd,0x22,0xfd,
		0xc7,0x2f,0xa8,0xcb,0x6a,0x1c,0x1c,0x29,0xf0,0xe0,0xe4,0x20,0xa7,0x9f,0x39,0x04,
		0xa2,0x7c,0xbd,0xf4,0x33,0x87,0xdf,0x3d,0x4e,0x1c,0x1b,0x80,0x68,0x40,0x40,0x5a,
		0x29,0x00,0xea,0x3c,0xe2,0x53,0xf0,0x82,0x29,0xd9,0x16,0xc5,0x5c,0x9e,0xcb,0x4b,
		0x4d,0xde,0x98,0xf9,0x8b,0x95,0x8d,0x3a,0xaa,0x96,0x7d,0xa5,0xdd,0x8c,0x8d,0x1e,
		0x84,0xac,0x89,0x89,0x06,0x13,0x12,0x14,0x8f,0x44,0x45,0x48,0x11,0x40,0x4d,0x0b,
		0xe3,0x2a,0x9b,0xec,0x69,0xcf,0x78,0xec,0xde,0x32,0x27,0x8e,0x8d,0x53,0xd9,0x0e,
		0xa8,0xc0,0x70,0xdf,0x10,0x97,0x9e,0x3e,0xc7,0x91,0xf2,0x21,0xb4,0x51,0x23,0xaa,
		0x80,0x5a,0xa2,0x80,0x02,0x51,0x01,0x97,0x22,0x33,0x5f,0xfd,0xaa,0x0f,0x4f,0x4e,
		0xd0,0xd7,0x6b,0xf0,0xd5,0x05,0xb6,0xfe,0x5b,0xa2,0xb1,0x7d,0x93,0xa1,0xb1,0xa7,
		0xc8,0x17,0xfb,0x71,0xc1,0xf3,0xf8,0x47,0x2f,0xf3,0xe5,0xfa,0x1c,0x9a,0xeb,0x82,
		0x60,0x31,0x2e,0x12,0x83,0x85,0x00,0xa2,0x41,0xb5,0xb6,0x39,0xcf,0xd2,0xb7,0x2f,
		0xd2,0xcb,0x6f,0x24,0x69,0x03,0xcd,0x0c,0x35,0x37,0xce,0xee,0xc3,0x9f,0xd2,0x55,
		0x1a,0x65,0x71,0xe3,0x06,0xf7,0xbd,0x77,0x92,0xdb,0x85,0x16,0xd6,0x5b,0x34,0x08,
		0xd1,0x0b,0x78,0x30,0x59,0xac,0xf3,0xe7,0xdc,0x0b,0xdc,0x99,0x7c,0xc7,0xde,0xfe,
		0x26,0x83,0x5d,0x05,0xca,0x3d,0x6d,0x94,0x65,0x81,0x8d,0x6f,0x5e,0x42,0x31,0xec,
		0x2f,0xef,0x65,0xb0,0x63,0x00,0x32,0x47,0x10,0x25,0x06,0x48,0x7d,0x8a,0x78,0x48,
		0x5a,0xd5,0x0d,0x8a,0xfe,0x06,0xf9,0xb4,0x87,0xdb,0x35,0x8f,0x78,0x4b,0x0c,0x50,
		0x68,0x2f,0x11,0x9a,0x6b,0x88,0xab,0xb3,0x63,0x3a,0x68,0xd6,0xea,0x20,0x29,0xc6,
		0xe7,0x88,0xe2,0x08,0x1a,0xd0,0xa8,0x98,0xf6,0x9e,0x11,0xda,0xfa,0x1f,0xa2,0xbe,
		0xe5,0xd1,0x66,0x01,0x0d,0x39,0x12,0x29,0x12,0x76,0x2c,0x6d,0x43,0x8f,0xa2,0xb9,
		0x22,0x9f,0xff,0x32,0xcb,0xcd,0xea,0x3a,0x12,0x0c,0x12,0x22,0xec,0x18,0x62,0x2b,
		0x42,0xcc,0x91,0xa4,0x89,0x11,0x57,0xdb,0xd4,0xca,0xfc,0x30,0x5a,0xbd,0x82,0xb8,
		0x06,0x2e,0xc9,0xd3,0x36,0x76,0x84,0xfc,0xc4,0x73,0x5c,0x59,0x5d,0xe6,0x95,0x4f,
		0xde,0x24,0x24,0x16,0x93,0x25,0x04,0x04,0x34,0x00,0x29,0xbc,0x3e,0x27,0xff,0x03,
		0xc9,0x90,0x7b,0x91,0xe4,0x11,0x92,0xff,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,
		0xae,0x42,0x60,0x82);
}
