/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.2";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.metacafe.com/";
	this.ID = "metacafe.com";
	this.caption = "Metacafe";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_FLV = "%1?__gda__=%2&";
	// video information
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get the video title
	result.title = copyBetween(html, "<title>", "- Video</title>");
	// get the flv url and params
	flv_url = cleanUrl(copyBetween(html, "mediaURL=", "&"));
	gda = copyBetween(html, "gdaKey=", "&");
	// build final url
	result.URL = strFormat(URL_GET_FLV, flv_url, gda);
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x00,0xad,0x49,0x44,0x41,0x54,0x78,0xda,0xad,0x92,0xd1,0x09,0x43,
		0x21,0x0c,0x45,0x3b,0xc2,0x1b,0x41,0xe8,0x02,0x4e,0xd1,0xef,0x8e,0xf0,0x46,0x70,
		0x83,0x76,0x83,0x37,0x92,0x23,0x64,0x04,0x47,0xf0,0xa7,0xff,0x79,0x37,0x90,0x92,
		0x10,0x28,0x6a,0x5b,0xe1,0x7c,0x18,0xcc,0xd1,0x2b,0xb9,0x30,0xf3,0x4f,0xfc,0x47,
		0x30,0xbb,0x5e,0x8f,0x54,0x40,0x73,0xa5,0x65,0x01,0x01,0x06,0x79,0x59,0x80,0xa6,
		0x04,0x58,0x79,0x7e,0x23,0x28,0x4e,0x40,0xab,0x02,0x7b,0xbe,0x91,0x4c,0x30,0x6e,
		0xde,0x00,0x07,0xca,0x8a,0x60,0x77,0x8d,0xdd,0x62,0xa8,0x60,0x80,0x08,0xaa,0x36,
		0x35,0xdd,0x5b,0x0c,0x29,0xbc,0xad,0x23,0x4c,0xe8,0x62,0x68,0x21,0x03,0x9a,0x11,
		0xf4,0xdb,0xb5,0x3b,0x09,0x89,0xc0,0x7f,0xd4,0xf1,0xe9,0x56,0x6d,0x6e,0x80,0x41,
		0xd3,0x7d,0x89,0x9f,0x28,0xa2,0x7b,0x88,0x44,0x7a,0x98,0x03,0x04,0xb2,0x17,0xc4,
		0xa9,0xab,0xfe,0x25,0x41,0xd2,0xa7,0x06,0x49,0x46,0x36,0xe6,0x07,0x55,0x25,0x59,
		0xce,0x9c,0xb2,0x89,0xab,0xcb,0xa4,0x76,0xe3,0x2f,0x00,0x00,0x00,0x00,0x49,0x45,
		0x4e,0x44,0xae,0x42,0x60,0x82);
}
