/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.1";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.myspass.de/";
	this.ID = "myspass.de";
	this.caption = "MySpass";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_XML = "http://www.myspass.de/myspass/includes/apps/video/getvideometadataxml.php?id=%1";
	// video information
	var result = new VideoDefinition();
	// get id
	var id = getToken(url, "/", getTokenCount(url, "/") - 2); //getUrlParam(url, "id");
	// download xml
	var http = new Http();
	var xml = http.downloadWebpage(strFormat(URL_GET_XML, id));
	// get video information
	result.title = copyBetween(xml, "<title><![CDATA[", "]");
	result.URL = copyBetween(xml, "<url_flv><![CDATA[", "]");
	// clear and get the final url
	result.URL = cleanUrl(result.URL);
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x02,0xdc,0x49,0x44,0x41,0x54,0x38,0x11,0x75,0xc1,0xcb,0x6b,0x5c,
		0x65,0x18,0xc0,0xe1,0xdf,0xfb,0x9e,0x73,0x66,0x26,0x19,0x33,0x34,0x2d,0x92,0x8e,
		0x44,0x52,0x2f,0x71,0x6a,0xa7,0x41,0x4d,0x2a,0xad,0xa2,0x05,0x17,0xd2,0x14,0x2f,
		0xa8,0x14,0xaa,0x20,0x65,0x36,0xa2,0x6d,0xdc,0xf8,0x0f,0xf8,0x27,0x88,0x9b,0x76,
		0x1d,0x2a,0xea,0x42,0x90,0x7a,0x09,0x62,0x49,0xbd,0x51,0xba,0x28,0xd8,0x55,0x82,
		0x4d,0xb0,0xa4,0x36,0x31,0x61,0x42,0xc6,0x66,0x32,0x93,0xcc,0xb9,0x7c,0xe7,0x7b,
		0xad,0x97,0xe2,0xca,0xe7,0x11,0x77,0xf1,0x04,0x58,0x06,0xe6,0x80,0x52,0x85,0x95,
		0x1b,0x67,0xe8,0x35,0x4f,0x51,0xbc,0xa7,0x86,0x46,0x8a,0x4b,0x20,0xde,0xf4,0x66,
		0xb2,0x20,0x95,0x91,0xf3,0x44,0x76,0x8e,0xed,0xe6,0x16,0x5e,0x31,0x09,0x11,0x77,
		0xe9,0x35,0xb0,0x0c,0x76,0x4a,0xe3,0x2c,0x5f,0x9d,0x96,0xfb,0x0f,0xd5,0x19,0x3e,
		0xac,0xb6,0xbd,0x0a,0xdd,0x15,0x24,0x69,0x63,0x59,0x8a,0xc4,0x1d,0x6c,0xfd,0x57,
		0x4f,0x50,0x99,0x67,0x78,0xa2,0x41,0x6b,0xee,0x1a,0x52,0x40,0xdc,0x77,0x2f,0x83,
		0x1b,0x9a,0x60,0x69,0x66,0x46,0x0e,0xbf,0x37,0x64,0x74,0xe1,0xb7,0x0b,0xd0,0xf9,
		0x1d,0xd2,0x04,0xb2,0x0c,0x32,0x07,0x3e,0x82,0x68,0x17,0xf4,0xba,0xe0,0xb4,0x69,
		0x07,0x5e,0x79,0x41,0x5a,0xd7,0x7f,0x96,0xec,0x87,0x37,0x07,0x64,0xe9,0xf2,0x15,
		0x39,0x72,0xfa,0xa0,0xb9,0x75,0x6c,0xe5,0x02,0x38,0x0f,0xa9,0x43,0xb2,0x0c,0x92,
		0x14,0xd2,0x0c,0xd2,0x1e,0x24,0x0e,0xe8,0xc3,0x12,0x07,0xe5,0xea,0x1c,0x23,0xcf,
		0x3c,0xad,0xb4,0xd6,0xa6,0xa8,0x8d,0xd5,0x19,0x28,0x62,0x5b,0xb3,0xd0,0x5f,0x86,
		0x42,0x11,0x29,0x84,0x10,0x84,0x10,0x05,0x10,0x85,0x10,0x14,0xb0,0x48,0x21,0xf7,
		0x04,0x47,0xdf,0x47,0x36,0x57,0xeb,0xec,0xb4,0xa6,0x94,0xce,0x62,0x43,0xaa,0x47,
		0xc5,0x5a,0xdf,0x22,0x5a,0x40,0x44,0x91,0x40,0x41,0x14,0x02,0x01,0x09,0x40,0x05,
		0x02,0x45,0x54,0x61,0xe0,0x3e,0x64,0x7c,0x0a,0xdb,0xf7,0x9c,0xb0,0x3e,0xd7,0x50,
		0xf2,0xf6,0x28,0xbd,0x16,0x74,0x9b,0x90,0x3b,0xcc,0x7b,0x30,0xc3,0x00,0x13,0x41,
		0x44,0x00,0xc5,0x44,0x20,0x07,0x79,0x72,0x0a,0x4a,0x83,0xe8,0x23,0xcf,0x43,0xa7,
		0x39,0xaa,0xe2,0x9c,0x4a,0x69,0x14,0x8b,0x53,0x48,0x53,0x24,0x73,0xf8,0xdc,0x21,
		0x79,0x8e,0x78,0x8f,0x99,0x01,0x06,0xb9,0x83,0x91,0x49,0x64,0xec,0x6d,0x0c,0x43,
		0xf6,0x1c,0x00,0xef,0x54,0xe9,0xed,0x40,0xb9,0x8e,0x1e,0xfc,0x00,0xcb,0x4b,0x58,
		0xaf,0x8d,0xa4,0x19,0x96,0xe7,0x90,0x1b,0xb8,0x14,0xcb,0x62,0xf4,0xe1,0x93,0xe8,
		0xb1,0x8f,0x20,0x2a,0x23,0xfc,0x27,0xb4,0x2c,0xf0,0xd6,0xbc,0xaa,0x32,0xf6,0x2e,
		0xc1,0xb3,0x4f,0x60,0xcb,0x9f,0x63,0x6b,0x97,0x90,0xee,0x2a,0x68,0x09,0x2a,0x75,
		0xf4,0xc1,0xd7,0xe1,0xde,0x43,0x88,0x86,0xdc,0x65,0x7f,0x2c,0x20,0x1a,0x7a,0x49,
		0x3f,0xac,0x5e,0xd7,0xe1,0xc7,0x6b,0xfa,0xea,0x17,0xa0,0x21,0xc2,0x1d,0x3e,0xc7,
		0x7c,0x02,0x12,0x42,0x50,0xe0,0x2e,0x41,0xf8,0x5b,0x9e,0xe1,0x3f,0x7d,0x91,0x7c,
		0x63,0x6e,0x41,0x6d,0xef,0xc4,0x34,0x8b,0xb3,0xc6,0xda,0x15,0x84,0x7f,0x69,0x88,
		0x84,0x65,0x24,0x28,0x22,0x08,0x82,0x20,0x08,0x86,0x61,0x66,0xd8,0xf2,0x4f,0xd8,
		0xd2,0xf7,0xe6,0x87,0x9f,0x9a,0x56,0x1b,0x7a,0xec,0xac,0xef,0x1b,0x9a,0xf7,0x5f,
		0x9d,0xc6,0xba,0xb7,0x30,0xfe,0x9f,0x70,0x47,0x7b,0x09,0xff,0xe5,0x3b,0xf8,0xca,
		0xde,0x79,0xaa,0x47,0xce,0x6a,0xe0,0xe2,0x4e,0xb2,0xff,0x64,0xc3,0xda,0xab,0x4d,
		0xff,0xc9,0x71,0x58,0xbb,0x0c,0x3e,0xe3,0x2f,0x06,0x18,0xff,0x30,0x9f,0x61,0xcb,
		0x3f,0xe2,0x3f,0x9e,0xc4,0xe2,0x8d,0x66,0xf2,0xe8,0x1b,0x8d,0x30,0xdb,0xea,0x48,
		0xfa,0xf5,0x5b,0x48,0x69,0x90,0x2c,0xee,0x8c,0x17,0x6e,0xcc,0x4c,0xd3,0x6d,0xd6,
		0xd9,0x7f,0x4c,0x65,0xf4,0x38,0xec,0xae,0x21,0x06,0xd6,0xfa,0x05,0x16,0xbf,0xc1,
		0x16,0x2f,0x7a,0xa9,0x54,0xe7,0x93,0x87,0x5e,0x6a,0x14,0xfa,0x07,0xaf,0x59,0xbc,
		0x89,0xa4,0x9f,0x9d,0x40,0xfa,0x06,0xa1,0x58,0x41,0xa2,0xbe,0x0a,0x37,0x67,0xcf,
		0x70,0xfb,0xe6,0x29,0xb6,0x37,0x6a,0x88,0x53,0x0c,0x90,0xc8,0x5b,0xff,0x9e,0x05,
		0xd9,0xbd,0xef,0x3c,0x0f,0x4c,0x9e,0x23,0x8b,0xb7,0x2c,0xed,0x62,0xf1,0x26,0x7f,
		0x02,0x18,0x7a,0x62,0x87,0x5e,0xca,0xde,0x53,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,
		0x44,0xae,0x42,0x60,0x82);
}
