/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.1";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.redtube.com/";
	this.ID = "redtube.com";
	this.caption = "RedTube";
	this.adultContent = true;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	// video information
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	// download html
	var html = http.downloadWebpage(url);
	// get video information
	result.title = copyBetween(html, "<h1 class='videoTitle'>", "</td>");
	result.URL = generateUrl(copyBetween(url + "/", ".com/", "/"));
	// return the video information
	return result;
}

function generateUrl(id)
{
	var l1, l2, l5, l6, l7, l8, l9;

	// first param
	l1 = id.toString();
	l2 = (Math.floor(parseFloat(l1) / 1000)).toString();
	l1 = strRemove("0000000", 0, l1.length) + l1;
	l2 = strRemove("0000000", 0, l2.length) + l2;
	// second param
	l5 = new Array("R", "1", "5", "3", "4", "2", "O", "7", "K", "9", "H", "B",
				   "C", "D", "X", "F", "G", "A", "I", "J", "8", "L", "M", "Z",
				   "6", "P", "Q", "0", "S", "T", "U", "V", "W", "E", "Y", "N");
	l7 = 0;
	for (var n = 0; n < 7; n++)
		l7 = l7 + parseInt(l1.charAt(n)) * (n + 1);
	l8 = l7.toString();
	l7 = 0;
	for (var n = 0; n < l8.length; n++)
		l7 = l7 + parseInt(l8.charAt(n));
	l9 = l7 >= 10 ? l7.toString() : "0" + l7;
	// generate FLV name
	l6 = "";
	l6 = l6 + l5[l1.charCodeAt(3) - 48 + l7 + 3];
	l6 = l6 + l9.charAt(1);
	l6 = l6 + l5[l1.charCodeAt(0) - 48 + l7 + 2];
	l6 = l6 + l5[l1.charCodeAt(2) - 48 + l7 + 1];
	l6 = l6 + l5[l1.charCodeAt(5) - 48 + l7 + 6];
	l6 = l6 + l5[l1.charCodeAt(1) - 48 + l7 + 5];
	l6 = l6 + l9.charAt(0);
	l6 = l6 + l5[l1.charCodeAt(4) - 48 + l7 + 7];
	l6 = l6 + l5[l1.charCodeAt(6) - 48 + l7 + 4];
	// return final url
	return strFormat("http://dl.redtube.com/_videos_t4vn23s9jc5498tgj49icfj4678/%1/%2.flv?start=0", l2, l6);
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x02,0x00,0x00,0x00,0x90,0x91,0x68,
		0x36,0x00,0x00,0x00,0x09,0x70,0x48,0x59,0x73,0x00,0x00,0x0b,0x13,0x00,0x00,0x0b,
		0x13,0x01,0x00,0x9a,0x9c,0x18,0x00,0x00,0x02,0x3f,0x49,0x44,0x41,0x54,0x18,0x19,
		0x35,0xc1,0x3d,0x8f,0x94,0x55,0x18,0x06,0xe0,0xfb,0x9c,0xf7,0xdd,0x21,0xee,0x30,
		0x33,0x14,0x7e,0x2c,0x1a,0x43,0x34,0xc6,0x5d,0x97,0x2d,0xe8,0x36,0x68,0x65,0x4b,
		0x0c,0xc1,0xf8,0x03,0xfc,0x07,0x26,0x34,0x26,0x16,0x36,0x5a,0x18,0x6b,0x2d,0x8c,
		0x8d,0xda,0x51,0x90,0xd8,0xd1,0x10,0xec,0x48,0x40,0x63,0xbb,0x8a,0x1f,0x20,0x2c,
		0x2c,0xac,0x38,0xee,0xce,0xec,0xcc,0x7b,0xce,0x79,0xce,0xf3,0x3c,0xb7,0xfa,0xaa,
		0xd7,0x15,0x28,0x92,0xde,0x7b,0xdf,0x7f,0x7f,0x1c,0x63,0x88,0x46,0x84,0x60,0xaa,
		0x5e,0x15,0x56,0x41,0x67,0x16,0x4a,0x71,0x11,0x5f,0x19,0x34,0x2f,0x9c,0x9a,0x7c,
		0xf6,0x69,0xf3,0x6e,0x57,0xc3,0xfe,0xe3,0x10,0x1b,0x8f,0x31,0x82,0x34,0x81,0x79,
		0x50,0x65,0x11,0x4a,0x66,0x11,0xef,0x12,0x72,0xb1,0xd9,0xdc,0x7e,0xbd,0x5d,0x6f,
		0x7e,0xd7,0xfa,0xfe,0xa3,0x96,0x84,0x23,0x00,0x1c,0x1e,0x0f,0x71,0x0c,0xad,0x94,
		0x1a,0x73,0xb6,0xe5,0xd2,0xd3,0x8c,0x29,0x79,0x29,0x2c,0x05,0x6a,0xb2,0xf3,0x43,
		0x1b,0x18,0x88,0x08,0xb0,0x19,0x4d,0xd6,0xbe,0xf8,0x3c,0x89,0xa0,0x17,0x43,0x7c,
		0xea,0xf8,0xf0,0xed,0x97,0xd7,0x2f,0x9e,0x38,0xc1,0x7b,0xbb,0x2c,0x62,0xb5,0xda,
		0xee,0xfd,0x16,0xa6,0x0e,0x44,0xa7,0x03,0xf3,0x94,0x9c,0xc4,0xff,0xee,0x1d,0xc8,
		0x87,0x37,0x6f,0x7c,0xff,0xe2,0x4b,0x5f,0x0e,0x47,0xbe,0x58,0xb8,0xaa,0xab,0x46,
		0x2f,0xe2,0xb9,0x68,0x4a,0x34,0x43,0xaf,0x6d,0x9a,0x77,0xce,0xbe,0xf6,0xd6,0xe9,
		0xad,0x18,0x02,0x80,0x2b,0xb7,0x7f,0x49,0x93,0x91,0xd5,0x6a,0xaa,0xee,0xde,0xa2,
		0x14,0x80,0x34,0xb7,0x9c,0xd1,0x3b,0xd6,0x34,0x1f,0xbc,0xb2,0x45,0xb3,0x6f,0x1f,
		0x3c,0xd8,0x3d,0x3c,0x00,0xf0,0x93,0xc8,0x86,0xbb,0xab,0xba,0x7b,0xeb,0x52,0x48,
		0x80,0x8c,0x6a,0xe8,0x75,0x22,0x9b,0x97,0x2f,0x2d,0xa4,0xcc,0x73,0x06,0x30,0x68,
		0x9a,0xcd,0x52,0x4d,0x95,0x66,0x0a,0xb4,0x56,0x84,0x4e,0x80,0x28,0x05,0x3d,0x02,
		0x7b,0xf3,0x19,0x7a,0xab,0x2b,0x83,0xaf,0xb7,0x5f,0xc5,0xce,0x2d,0xad,0x55,0x49,
		0x25,0xa3,0x77,0x89,0x29,0x71,0xb1,0x44,0x49,0xe8,0xb5,0x31,0x9e,0xdf,0x3c,0x8d,
		0xde,0xb1,0xb6,0x39,0x53,0x44,0x66,0xb3,0x6a,0x26,0xee,0x42,0x46,0x76,0x1d,0x53,
		0x87,0xd4,0xb1,0xcb,0xe8,0x0d,0x9a,0xf6,0xab,0x8d,0xad,0xa7,0x87,0x43,0x00,0x07,
		0x29,0x7d,0xbc,0x9c,0xdb,0x78,0x58,0xa9,0x85,0x5a,0xe8,0xd1,0xba,0xa5,0x1e,0x2d,
		0xea,0xfc,0x48,0x53,0xc2,0x7f,0x58,0xee,0xfc,0xf6,0xd1,0xc6,0x26,0x7a,0x9f,0xfc,
		0xb8,0x73,0x74,0xea,0xb9,0xd4,0x84,0x04,0x0a,0x34,0xd6,0x94,0x25,0xa5,0x9c,0x52,
		0x9e,0xcd,0xf0,0x2f,0xf2,0xf0,0xe0,0x8f,0xb3,0xd3,0x3f,0x9f,0x1f,0x8d,0x01,0x54,
		0xf7,0x8b,0x7b,0x7b,0x69,0xf5,0x89,0x0c,0x4b,0xf0,0x70,0x6b,0xf4,0x24,0x01,0xab,
		0xd5,0xda,0x36,0x3c,0x7b,0x32,0x0c,0x56,0xea,0xe2,0x28,0x3f,0xbc,0xaf,0x66,0xed,
		0xda,0xda,0xca,0x64,0x2c,0xee,0x65,0x3a,0x2d,0xd3,0x69,0x36,0x73,0x20,0xdc,0x7d,
		0xe3,0xcd,0xc3,0xab,0xd7,0xb2,0x99,0x92,0x4e,0xaa,0x57,0x85,0x3b,0x40,0x50,0x41,
		0x02,0x06,0x38,0x40,0xc0,0x80,0x67,0xb6,0xb7,0x03,0x45,0x7e,0x3e,0x77,0x61,0xff,
		0xda,0x37,0x0a,0x28,0xe9,0xa8,0x02,0x08,0x48,0xfc,0x8d,0x0e,0x54,0xfc,0x63,0x32,
		0x1e,0xaf,0xae,0xaf,0xbf,0x7e,0xfd,0xfa,0x5f,0xa3,0x65,0xb5,0x96,0x8f,0x31,0xdb,
		0xae,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
