/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.spankwire.com/";
	this.ID = "spankwire.com";
	this.caption = "Spankwire";
	this.adultContent = true;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_INFO = "http://www.spankwire.com/Player/VideoXML.aspx?id=%1";
	// init result
	var result = new VideoDefinition();
	// get videoId
	var videoId = copyBetween(url, "/video", "/");
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get video title
	result.title = copyBetween(html, "<title>", "</title>");
	// download xml
	var xml = http.downloadWebpage(strFormat(URL_GET_INFO, videoId));
	// get video url
	result.URL = copyBetween(xml, '<url type="string">', '</url>');
	result.URL = strReplace(result.URL, "&amp;", "&");
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x01,0xed,0x49,0x44,0x41,0x54,0x78,0xda,0xad,0x93,0xdf,0x4b,0x54,
		0x41,0x14,0xc7,0xfb,0x07,0x7b,0x8f,0x1e,0xfa,0x49,0x5a,0xb9,0x59,0x9a,0x81,0x14,
		0xd5,0x4b,0x10,0x44,0x3d,0xf4,0x56,0xf4,0x03,0xa2,0xa0,0x48,0x82,0x28,0xdc,0x75,
		0xd5,0x0c,0x6b,0xdb,0x5f,0x65,0xae,0x8b,0xda,0x9a,0x25,0x19,0x6b,0xad,0x52,0xad,
		0x28,0x7a,0xe7,0xde,0xb9,0x73,0x3f,0xdd,0x73,0x90,0x6d,0xdb,0x65,0x7b,0xea,0x0b,
		0xc3,0x65,0xee,0x9c,0xf3,0x99,0x39,0xdf,0x33,0xb3,0xeb,0xbf,0x88,0xf3,0x1f,0x61,
		0xa0,0xf8,0xf7,0x38,0x95,0x87,0x44,0x16,0xfa,0x0a,0xf2,0x95,0x79,0x5b,0x8c,0xe4,
		0x29,0x40,0x26,0xa6,0x67,0xac,0x31,0xbc,0xc3,0x29,0x82,0x1b,0x25,0xdc,0xbb,0x1a,
		0xa6,0x7f,0x02,0x37,0xbd,0x4a,0x70,0x6b,0x06,0x6f,0xcf,0x33,0xcc,0xb1,0x51,0x4c,
		0x42,0xe3,0x04,0xd2,0x01,0xb0,0x3f,0x89,0x7d,0xba,0x08,0x5e,0x48,0x70,0xb5,0x88,
		0xc8,0xde,0x9f,0xc5,0x0e,0x2d,0xe0,0x9f,0x7b,0x8d,0xe9,0x4e,0xb7,0x00,0xce,0xc4,
		0x80,0xae,0x34,0xde,0xa1,0x14,0x0a,0x38,0x18,0x03,0x1e,0xce,0x13,0x2d,0xfc,0xc2,
		0x3e,0x98,0x23,0x5a,0xac,0x63,0x1f,0x7d,0x40,0xe4,0x5f,0xc8,0x60,0x8e,0x8c,0xb4,
		0x00,0x4e,0xe6,0xf1,0x2f,0xe7,0xb1,0xf7,0x66,0xf5,0x88,0x0a,0xb8,0x3d,0x43,0x38,
		0xb2,0x44,0xf8,0x62,0x19,0xf7,0xa6,0x0a,0xeb,0x06,0x97,0xa9,0xe2,0xed,0x1b,0xc6,
		0x13,0xc0,0xd1,0x74,0x13,0xa0,0x3b,0x83,0x2b,0x7c,0x47,0xe4,0x0f,0x4e,0xc6,0x25,
		0x0c,0x63,0xef,0x96,0x89,0x2a,0x3f,0x25,0x49,0x4f,0x41,0x6d,0x0b,0xff,0x62,0x46,
		0xe1,0xae,0xbc,0x16,0x7b,0x34,0x0d,0x3d,0xd9,0x1d,0xc0,0x89,0x1c,0xc1,0xf5,0x29,
		0xdc,0x54,0x0d,0xd3,0x3b,0x8e,0xb7,0xf7,0x39,0x2e,0xb7,0x42,0x43,0xdb,0x96,0xe0,
		0x66,0x89,0xed,0xdd,0x4f,0xb0,0x8f,0x2b,0x00,0xe2,0x8d,0x74,0xa7,0xc9,0x44,0x31,
		0x46,0x8e,0x7f,0x20,0xa9,0xe5,0xb0,0xb2,0x49,0xb4,0xb4,0x0e,0xd5,0x4d,0xa8,0x1b,
		0x5c,0xe1,0x9b,0xfa,0x10,0x7d,0xdd,0xc0,0xbf,0x94,0xc5,0xc4,0x7e,0x89,0x77,0x0d,
		0x80,0x18,0x23,0x0b,0xee,0xfd,0x2a,0x6c,0x59,0x00,0xf1,0x44,0x5b,0x17,0x26,0x3f,
		0x03,0x28,0xc8,0xf4,0x4d,0x48,0x19,0xed,0x6d,0x94,0x2e,0xf8,0x67,0x5f,0xd1,0xac,
		0xe0,0xda,0xdb,0x38,0x38,0x45,0x34,0xff,0x03,0x05,0x0e,0x55,0xc4,0x44,0x4d,0x6e,
		0x07,0x1c,0x1f,0x55,0x67,0xa3,0x39,0x09,0x56,0xe9,0x45,0x8a,0x96,0x37,0x10,0x85,
		0x63,0x5f,0x64,0x67,0x89,0xeb,0x00,0x90,0x9f,0x5d,0x71,0x19,0x03,0x2f,0x89,0x3e,
		0xd5,0x69,0x95,0xbd,0x53,0x96,0xee,0x48,0x5c,0x67,0x80,0x5e,0x51,0xe9,0x71,0x62,
		0x5c,0x13,0x5c,0x69,0xed,0x4f,0xed,0x83,0x93,0x62,0xf4,0x3f,0x01,0x8d,0x21,0xdd,
		0x90,0xdd,0xa4,0xa4,0xe0,0x4a,0x41,0xae,0xaf,0x9c,0x4e,0x36,0xe8,0x00,0x90,0xd7,
		0x78,0xba,0xd8,0x3c,0x74,0x91,0xfe,0x9d,0x97,0xd8,0x9b,0x93,0x79,0x5b,0x8c,0xe4,
		0xfd,0x06,0xac,0x9f,0xf2,0x98,0x14,0x89,0xec,0x34,0x00,0x00,0x00,0x00,0x49,0x45,
		0x4e,0x44,0xae,0x42,0x60,0x82);
}
