/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "crapmaster & Xesc & Technology 2014";
	this.website = "http://www.totallynsfw.com/";
	this.ID = "totallynsfw.com";
	this.caption = "Totally NSFW";
	this.adultContent = true;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	// video information
	var result = new VideoDefinition();

	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);

	// get video title
	result.title = copyBetween(html, '<div class="hdr"><h2>', '</h2></div>');

	// get the config object url
	var configUrl = copyBetween(html, 's1.addVariable("config","', '");');

	// Load the Config Object URL
	var config= http.downloadWebpage(configUrl);

	// get video url
	var videoUrl = copyBetween(config, '<file>', '</file>');

	result.URL=cleanUrl(videoUrl );

	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x00,0x01,0x73,0x52,0x47,0x42,0x00,0xae,0xce,0x1c,0xe9,0x00,0x00,
		0x00,0x06,0x62,0x4b,0x47,0x44,0x00,0xff,0x00,0xff,0x00,0xff,0xa0,0xbd,0xa7,0x93,
		0x00,0x00,0x00,0x09,0x70,0x48,0x59,0x73,0x00,0x00,0x0b,0x13,0x00,0x00,0x0b,0x13,
		0x01,0x00,0x9a,0x9c,0x18,0x00,0x00,0x00,0x07,0x74,0x49,0x4d,0x45,0x07,0xdb,0x07,
		0x0a,0x12,0x35,0x19,0xb0,0x48,0x67,0x50,0x00,0x00,0x02,0x5b,0x49,0x44,0x41,0x54,
		0x38,0xcb,0x8d,0x93,0x3d,0x4c,0x93,0x41,0x18,0xc7,0x7f,0x77,0x6d,0x69,0x0b,0x05,
		0x5a,0x3e,0x52,0x42,0x20,0x01,0x34,0x28,0x0a,0x46,0x43,0x1c,0xab,0x71,0x50,0xf1,
		0xdb,0x18,0x57,0x17,0x1d,0x89,0x93,0xbb,0x4e,0x3a,0xb9,0xe8,0x6c,0x08,0xae,0x7e,
		0x30,0x68,0x34,0x86,0x04,0x07,0x07,0x12,0x0b,0x03,0x1a,0x6b,0x48,0x14,0x84,0x28,
		0x18,0xa5,0x14,0x4a,0xe9,0xc7,0x5b,0xde,0xbb,0xc7,0xa1,0xe1,0x95,0x9a,0x90,0xf8,
		0x4f,0x9e,0xe9,0x7e,0xf7,0xbf,0xff,0xf3,0xdc,0x9d,0xb2,0xd6,0x96,0xd9,0x29,0x01,
		0x67,0xe2,0x2b,0xa5,0xa7,0x1f,0xb5,0x99,0x4d,0x2b,0xac,0xe0,0xeb,0x69,0x92,0xe0,
		0xe5,0x03,0x36,0x74,0xb1,0x0f,0x7c,0xba,0x0a,0x57,0x22,0x62,0x00,0x0d,0x20,0x8e,
		0x4b,0xf6,0xee,0x04,0xce,0xf8,0x17,0xd0,0x8a,0x60,0xa2,0x1b,0xca,0x06,0x67,0x72,
		0x01,0x80,0xc0,0xd1,0x4e,0xa2,0xf7,0x86,0xd0,0x0d,0xa1,0xed,0xfd,0xd6,0x33,0x10,
		0x6b,0x59,0xbb,0x33,0x4e,0xf1,0xcd,0x2c,0x28,0x45,0xec,0xf6,0x49,0xc2,0xe7,0xfa,
		0x40,0x60,0x75,0x78,0x0c,0x67,0xfa,0x3b,0x00,0x35,0x83,0x1d,0xb4,0x3c,0xb8,0x8c,
		0x0a,0xfa,0x01,0xac,0x97,0x27,0xff,0x22,0x45,0xee,0xf5,0x67,0x5c,0x6b,0xa0,0x2d,
		0x42,0xf8,0xcc,0x7e,0x94,0x52,0x28,0xad,0x08,0x0d,0xed,0xc3,0xb5,0x06,0xd7,0x1a,
		0x0a,0x53,0x8b,0x64,0x47,0xde,0x23,0x22,0xb0,0x1d,0xdd,0x6c,0x94,0x48,0x3f,0x7c,
		0x87,0x31,0x06,0x23,0x42,0x28,0xd1,0x8d,0xda,0xd1,0x6b,0x38,0xd1,0x83,0x6a,0xa9,
		0xc3,0x18,0x8b,0x31,0x96,0xb5,0xd1,0x24,0xee,0x8f,0xf5,0xbf,0x06,0xd9,0xe7,0x33,
		0x94,0xd3,0x39,0x5c,0x6b,0xa8,0xbf,0x36,0x48,0xd3,0x70,0xa2,0x6a,0x50,0x3a,0x1a,
		0x46,0x22,0x01,0x2f,0xc5,0x56,0xd1,0x21,0xf3,0x38,0x59,0x59,0x13,0x6b,0xc9,0x8c,
		0xcd,0xe0,0x1a,0x83,0x6b,0x0c,0x75,0xc7,0xf7,0xb2,0xf9,0x32,0x55,0x3d,0x69,0xad,
		0xa8,0xbf,0x72,0x08,0xa2,0x21,0x8f,0x5b,0x7f,0xf5,0x09,0x5b,0x28,0xa3,0x9d,0xf9,
		0x34,0xc5,0xb9,0x15,0x8c,0x58,0x8c,0x58,0x02,0x1d,0x51,0xca,0x62,0x70,0xd7,0x0a,
		0x55,0x26,0x35,0x46,0xe3,0xef,0x8a,0x79,0x5c,0x39,0x5b,0x60,0x73,0x6a,0x11,0x9d,
		0x4b,0x2e,0x60,0xc4,0x78,0x25,0xae,0x21,0x7a,0xfe,0x20,0x3f,0x9f,0x24,0x11,0x2b,
		0x88,0x08,0x2b,0x23,0x93,0xfc,0x7a,0x36,0xcd,0x56,0xb6,0x50,0xc5,0xe6,0x92,0xdf,
		0xd0,0xf9,0xd4,0xb2,0xe7,0x6a,0xc4,0x52,0x5a,0x58,0xc5,0x17,0x09,0xd1,0x7a,0xe9,
		0x48,0xe5,0x55,0x01,0xd9,0xd4,0x12,0xe9,0xb9,0x25,0x02,0x7d,0xf1,0x2a,0x36,0x9f,
		0x5a,0x46,0xe7,0xe7,0x57,0x70,0xc5,0x7a,0x95,0xfb,0x50,0xb9,0xef,0x50,0x5b,0x23,
		0x4a,0x6b,0x94,0x52,0xec,0xb9,0x7f,0x95,0xc3,0x6f,0x6f,0x11,0xbb,0x30,0x80,0x6e,
		0x8d,0x78,0x6c,0x7e,0x31,0x8d,0x2e,0x2e,0xad,0x62,0xb0,0x5e,0x05,0xbb,0x9a,0xf9,
		0x57,0x4a,0x29,0x82,0xf1,0x46,0x1a,0x06,0x3a,0x69,0xbf,0x79,0xc2,0x63,0x9d,0x4c,
		0x0e,0x5d,0xce,0x15,0xd1,0xb1,0x5a,0x8c,0x82,0x50,0x6f,0x9c,0xe6,0xd3,0xfd,0xec,
		0x26,0x1d,0x09,0x12,0x3d,0xd6,0x8b,0x41,0x30,0xd6,0xb2,0x55,0x2a,0x6b,0x5d,0xdb,
		0xdf,0x4e,0xff,0xe8,0x0d,0xc4,0x07,0xcd,0x67,0x07,0x50,0x5a,0xed,0x6a,0xa0,0xb4,
		0xa2,0x26,0xde,0x40,0xb0,0xa7,0x05,0xb7,0x32,0x07,0xeb,0x1f,0x78,0x74,0x1d,0xac,
		0xe0,0x8f,0x37,0xd0,0x72,0x6a,0xf7,0xd3,0x77,0x2a,0x10,0xaf,0xc7,0x97,0xd9,0xa4,
		0x26,0x56,0x8b,0xf2,0xbe,0xb3,0x08,0x28,0xf5,0x5f,0x06,0x5b,0xeb,0x05,0x9c,0xdf,
		0x1b,0x3a,0xd2,0xdb,0x66,0xff,0x00,0x09,0xa2,0x58,0x43,0x42,0x5f,0x0b,0x00,0x00,
		0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
