/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://watch.tsn.ca/";
	this.ID = "watch.tsn.ca";
	this.caption = "TSN";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_XML = "http://esi.ctv.ca/datafeed/flv/urlgenjs.aspx?vid=%1";
	// init result
	var result = new VideoDefinition();
	// get videoId
	var videoId = copyBetween(url + "/", "#clip", "/");
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get video title
	result.title = copyBetween(html, "#clip" + videoId, "</dt>");
	result.title = copyBetween(result.title, "Title:'", "'");
	// download xml
	var xml = http.downloadWebpage(strFormat(URL_XML, videoId));
	// get video url
	result.URL = copyBetween(xml, "url:'", "'");
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x01,0x87,0x49,0x44,0x41,0x54,0x78,0xda,0x85,0x92,0x5f,0x4a,0x02,
		0x61,0x14,0xc5,0xef,0x0a,0x5c,0x81,0x2b,0x70,0x03,0xae,0xc0,0x15,0xb8,0x02,0x57,
		0x30,0x1b,0x70,0x05,0xbe,0x95,0x4d,0x4e,0x92,0x52,0x1a,0xa6,0xa5,0x45,0x0d,0x85,
		0x9a,0xff,0xa6,0x30,0x41,0x22,0x29,0xa8,0xa0,0x10,0x22,0xe8,0x21,0xa8,0x20,0x5a,
		0xc0,0xd7,0xb9,0x70,0x66,0x18,0x67,0x1e,0x7a,0xf8,0xf1,0x79,0xef,0x9c,0x73,0xee,
		0xfd,0xf0,0x93,0x99,0x88,0x19,0x03,0x17,0x34,0x40,0x05,0x38,0x64,0x4b,0x6b,0xf6,
		0x5d,0xea,0xa6,0xc0,0x03,0x03,0x70,0x06,0xc4,0x37,0x95,0xc0,0x26,0x8d,0xdb,0x21,
		0xd3,0x24,0x64,0xea,0x81,0x13,0xd0,0x21,0x47,0x40,0x6c,0x9a,0xab,0x60,0x9f,0xa9,
		0x43,0x30,0xe2,0x79,0x0e,0x8e,0x41,0x3b,0x30,0x11,0xd6,0xd2,0xa4,0x68,0xc4,0x15,
		0xbb,0x3a,0x85,0x86,0x43,0x8a,0x08,0x7b,0xab,0x48,0x30,0x25,0xfc,0x21,0x22,0x3e,
		0x88,0x12,0x0e,0xb8,0xce,0x66,0xcd,0xad,0x65,0x05,0x2c,0xc0,0x20,0x9d,0x36,0x5e,
		0x26,0xa3,0xbf,0x03,0xe6,0xb9,0x9c,0x99,0x42,0xeb,0xd7,0xaa,0x3d,0x4d,0x26,0x8d,
		0x7c,0x2f,0x16,0xe6,0x77,0xb9,0x5c,0xe1,0xdd,0x75,0x63,0xbd,0x17,0xc7,0x89,0xf5,
		0xd4,0x2b,0x5d,0x4c,0x9b,0x21,0xfd,0xb5,0xd1,0x30,0x97,0x98,0xa0,0xf5,0x63,0xa1,
		0xa0,0x75,0x00,0xcc,0x81,0xe6,0x0a,0x9a,0x3e,0x34,0x4f,0xd0,0x68,0x88,0xd4,0x45,
		0xcc,0x03,0x8b,0x56,0x22,0x61,0xf6,0x50,0x73,0xab,0xf8,0x06,0xd4,0xd4,0xa0,0x79,
		0xc3,0x96,0x9f,0xba,0x41,0x13,0x0d,0x35,0x3c,0x43,0xa0,0xe6,0x21,0xee,0x7e,0x63,
		0x59,0x01,0x6a,0xd2,0xc9,0x7a,0xde,0x63,0x50,0x19,0x9a,0x3a,0xee,0xfe,0x83,0x7a,
		0x9e,0xcf,0x1b,0x99,0x60,0x25,0xfd,0xe8,0xe1,0xd4,0x6d,0x3e,0x3c,0x6f,0x65,0xf2,
		0x17,0xc2,0xef,0x60,0x54,0x83,0x8b,0x70,0x47,0xff,0x6e,0x5c,0x47,0xeb,0x56,0x2a,
		0x65,0x44,0x1f,0xcf,0x2e,0xd8,0x01,0x35,0x52,0x05,0x65,0xff,0x75,0x92,0x12,0x71,
		0x22,0xc8,0x8c,0xef,0xba,0x4d,0xe3,0x06,0x28,0x02,0x9b,0xc6,0x28,0xa5,0x08,0xe2,
		0xf1,0xbd,0x8f,0x41,0x1f,0x74,0x18,0x64,0x33,0xcc,0xfe,0x2f,0xe0,0x42,0x37,0x20,
		0x43,0x0d,0xe2,0xe9,0x82,0x3a,0xd7,0x2c,0x12,0x3b,0x16,0xc8,0x00,0x9f,0x41,0x88,
		0x11,0xe9,0x71,0xab,0x0a,0x43,0xd6,0xc0,0x7a,0x28,0xf4,0x0f,0xe4,0xd9,0x20,0x0a,
		0x06,0x64,0x5f,0x7d,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82,
	);
}
