/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.1.0";
	this.minVersion = "2.2.0";
	this.author = "Xesc & Technology 2014";
	this.website = "http://www.tv3.cat/";
	this.ID = "tv3.cat";
	this.caption = "TV3 a la Carta";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_INFO_XML  = "http://www.tv3.cat/pvideo/FLV_bbd_dadesItem.jsp?idint=%1";
	const URL_VIDEO_XML = "http://www.tv3.cat/su/tvc/tvcConditionalAccess.jsp?ID=%1&QUALITY=H&FORMAT=%2";
	// init result
	var result = new VideoDefinition();
	// get the video id
	var videoId = copyBetween(url + "/", "videos/", "/");
	// create http class
	var http = new Http();
	// download info xml
	var xml_info = http.downloadWebpage(strFormat(URL_INFO_XML, videoId), false);
	// set video information
	var format = copyBetween(xml_info, "<format>", "</format>");
	result.title = copyBetween(xml_info, "<title>", "</title>") + " - " + copyBetween(xml_info, "<promo>", "</promo>");
	// download video xml
	var xml_url = http.downloadWebpage(strFormat(URL_VIDEO_XML, videoId, format));
	// set video url
	result.URL = "rtmp:" + copyBetween(xml_url, "rtmp:", "</media>");
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x00,0xa1,0x49,0x44,0x41,0x54,0x38,0xcb,0x63,0x60,0x18,0xf6,0x40,
		0x00,0x88,0x17,0x00,0xf1,0x7f,0x24,0x3c,0x01,0x43,0xd5,0x66,0x65,0x71,0x05,0x20,
		0x16,0xc0,0x62,0x00,0xba,0x66,0xec,0x86,0x00,0x35,0x1b,0x00,0xf1,0x03,0x20,0x6e,
		0x40,0x33,0x00,0xa6,0x61,0x3d,0x94,0x3f,0x1f,0x49,0x0c,0xc3,0x80,0x08,0x20,0x9e,
		0x0f,0x35,0x28,0x00,0x87,0x97,0x1a,0xa0,0x9a,0xdf,0x63,0xf3,0xc2,0x79,0x20,0x3e,
		0x00,0x35,0x68,0x3f,0x94,0x6d,0x00,0x55,0xe2,0x80,0xe6,0x85,0x04,0x74,0x03,0x1c,
		0x40,0xce,0x07,0xe2,0x4c,0x20,0xbe,0x0f,0xc4,0x13,0x80,0x38,0x9a,0x14,0x03,0xe4,
		0x81,0xb8,0x1e,0x88,0x3f,0x00,0xb1,0x0f,0x92,0x46,0x5c,0x5e,0xf8,0x8f,0xcd,0x05,
		0x1b,0x80,0x58,0x0f,0x47,0x20,0x6e,0xc0,0x12,0x2b,0x02,0xc4,0x44,0xe3,0x7e,0x1c,
		0xd1,0xb8,0x9f,0x94,0x84,0xb4,0x1f,0x8b,0x66,0x01,0x52,0x53,0xa4,0x02,0x10,0xdb,
		0x93,0xa3,0x91,0xf6,0x00,0x00,0xd3,0x80,0x5a,0x7a,0x6b,0xde,0xb1,0x63,0x00,0x00,
		0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}