/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.6";
	this.minVersion = "2.3.1";
	this.author = "Xesc & Technology 2014";
	this.website = "http://www.xtube.com/";
	this.ID = "xtube.com";
	this.caption = "XTube";
	this.adultContent = true;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_POST_XML = "http://www.xtube.com/find_video.php";
	const URL_POST_XML_PARAMS = "clip_id=%2&user_id=%1&video_id=%3";
	// video information
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get video title
	result.title = copyBetween(html, '<div class="font_b_12px">', '</div>');
	// get subdomain
	var userd_id  = copyBetween(html, 'so_s.addVariable("owner_u", "', '"');
	var video_id = copyBetween(html, 'so_s.addVariable("video_id", "', '"');
	var clip_id = copyBetween(html, 'so_s.addVariable("clip_id", "', '"');
	var main_swf = copyBetween(html, 'SWFObject("', '"');
	// prepare the xml request
	http.addHeaderParameter("Referer", main_swf);
	http.addHeaderParameter("Origin", getUrlHost(main_swf));
	http.addHeaderParameter("Content-Type", "application/x-www-form-urlencoded");
	// prepare post params
	var post_params = strFormat(URL_POST_XML_PARAMS, userd_id, clip_id, video_id);
	post_params = strReplace(post_params, "_", "%5F");
	post_params = strReplace(post_params, "-", "%2D");
	// get xml
	var xml = http.downloadWebpagePost(URL_POST_XML, post_params);
	var hash = copyBetween(xml+"&", "hash%3D", "&");
	// get video url
	result.URL = cleanUrl(copyBetween(xml, "filename=", "%25"))+"%&hash="+hash;
	// get cookies
	result.cookies = http.getCookies("|");
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x02,0x00,0x00,0x00,0x90,0x91,0x68,
		0x36,0x00,0x00,0x00,0x09,0x70,0x48,0x59,0x73,0x00,0x00,0x0b,0x13,0x00,0x00,0x0b,
		0x13,0x01,0x00,0x9a,0x9c,0x18,0x00,0x00,0x01,0x6a,0x49,0x44,0x41,0x54,0x28,0x91,
		0x63,0xf8,0x4f,0x22,0x60,0x40,0xe6,0xdc,0x5c,0xba,0xf4,0x52,0x67,0xe7,0xd9,0xf0,
		0xf0,0xd3,0xe6,0xe6,0x70,0xc1,0xaf,0xaf,0x5f,0x5f,0xb4,0xb2,0x3a,0xc7,0xcc,0x7c,
		0xd0,0xcb,0x0b,0x5d,0xc3,0x8d,0x85,0x0b,0x9f,0xb8,0xb9,0x3d,0xb2,0xb2,0xba,0xc6,
		0xcb,0xfb,0x64,0xff,0x7e,0x88,0xe0,0x19,0x07,0x87,0xa3,0xcc,0xcc,0x5b,0xad,0xad,
		0xb1,0xd8,0xf0,0xf5,0xe5,0xcb,0xdb,0x5a,0x5a,0x0f,0xb4,0xb5,0xaf,0x0b,0x0a,0x9e,
		0xaf,0xad,0x05,0x8a,0x9c,0x8e,0x88,0x38,0xc6,0xcc,0xbc,0x45,0x54,0xf4,0xf3,0xf3,
		0xe7,0x58,0x34,0x00,0xc1,0x29,0x67,0xe7,0x07,0x7a,0x7a,0xb7,0x94,0x94,0x4e,0x85,
		0x86,0x9e,0xc9,0xca,0x3a,0xcd,0xce,0xbe,0x95,0x8b,0xeb,0xf9,0xf9,0xf3,0xd8,0xfd,
		0x00,0x04,0xe7,0xab,0xaa,0x1e,0x1a,0x19,0xdd,0xd7,0xd4,0xbc,0x29,0x2c,0x7c,0x84,
		0x8b,0x6b,0x07,0x33,0xf3,0xd5,0x25,0x4b,0x70,0x7a,0x1a,0x08,0x9e,0x1e,0x3a,0xf4,
		0xd0,0xcc,0xec,0xae,0x84,0xc4,0x21,0xb0,0xea,0x03,0xd9,0xd9,0xf8,0x42,0x09,0x02,
		0xee,0x9a,0x99,0xdd,0x11,0x13,0xdb,0xc7,0xc6,0xb6,0x03,0x1c,0x2c,0x04,0x34,0x3c,
		0x3d,0x76,0xec,0x9a,0x8d,0xcd,0x3d,0x39,0xb9,0x43,0x6c,0x6c,0x07,0x31,0x8c,0x47,
		0xd7,0xf0,0xe6,0xfa,0xf5,0xcb,0x9e,0x9e,0x8f,0x80,0x1a,0x64,0x65,0x8f,0xb1,0xb3,
		0x6f,0x87,0x05,0x25,0x4e,0x0d,0xe7,0xbc,0xbd,0x6f,0xab,0xa8,0x5c,0x13,0x10,0xb8,
		0x2b,0x2e,0x7e,0x02,0x18,0x3e,0x0a,0x0a,0xf8,0x34,0x9c,0x89,0x89,0xb9,0xca,0xcd,
		0x7d,0x88,0x99,0xf9,0x68,0x54,0x14,0xd0,0x0f,0x27,0x38,0x38,0xb6,0x71,0x71,0xe1,
		0xd4,0x70,0xbe,0xbe,0xfe,0x22,0x37,0xf7,0x2e,0x66,0xe6,0x73,0x13,0x26,0xdc,0x5a,
		0xb2,0xe4,0x86,0xb0,0xf0,0x71,0x41,0xc1,0x3d,0x6c,0x6c,0xd8,0x35,0x00,0x53,0xc1,
		0x49,0x76,0xf6,0x9d,0xb0,0x40,0xbc,0xb1,0x64,0xc9,0x41,0x36,0xb6,0xdd,0xc0,0x50,
		0x62,0x66,0x7e,0x81,0x14,0x65,0x50,0x0d,0xaf,0x2f,0x5c,0xd8,0x6b,0x6d,0x0d,0x0c,
		0x10,0x78,0x04,0x5d,0x5f,0xb2,0x04,0x98,0x16,0x80,0x9a,0x8f,0x81,0x53,0x07,0x3e,
		0x4f,0x13,0x03,0x00,0x8b,0xfd,0x5d,0x83,0xd3,0x02,0x1e,0xa4,0x00,0x00,0x00,0x00,
		0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
