/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "3.1.2";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2014";
	this.website = "http://www.youtube.com/";
	this.ID = "youtube.com";
	this.caption = "YouTube";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_YOUTBE = "http://www.youtube.com/watch?v=%1";
	// init result
	var result = new VideoDefinition();
	// default URL
	var youTubeURL = strReplace(url, "watch#!", "watch?");
	// replace "popup" watch for standard watch
	youTubeURL = strReplace(youTubeURL, "watch_popup?", "watch?");
	// check if is an embeded video, and get the "real url" of youtube
	if (youTubeURL.toString().indexOf(".youtube.com/v/") != -1)
	{
		var embededID = youTubeURL;
		embededID = strRemove(embededID, 0, embededID.lastIndexOf("/v/") + 3);
		youTubeURL = strFormat(URL_YOUTBE, embededID);
	}
	// cehck if is an embeded video (v2)
	else if (youTubeURL.toString().indexOf("/embed/") != -1)
	{
		var embededID = copyBetween(youTubeURL + "?", "/embed/", "?");
		youTubeURL = strFormat(URL_YOUTBE, embededID);
	}
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(youTubeURL);
	// get cookies
	result.cookies = http.getCookies("|");
	// get video information
	var videoInformationJSON = getVideoInformationJSON(html);
	// get the video title
	result.title = videoInformationJSON.args.title;
	// check if this video need a login
	result.needLogin = videoInformationJSON.needLogin || strIndexOf(html, 'id="verify-details"') != -1;
	// if we can continue (no loggin needed)
	if (result.needLogin) return result;
	// get the video URL and extension
	var videoInfo = getVideoUrlAndExtension(videoInformationJSON);
	result.URL = videoInfo.url;
	result.extension = videoInfo.extension;
	result.needLogin = videoInfo.needLogin;
	// return the video information
	return result;
}

function getVideoInformationJSON(html)
{
	var playerConfig = /ytplayer.config\s*=\s*\{(.*?)\};/g;
	return eval('({' + playerConfig.exec(html)[1] + '})');
}

function getVideoUrlAndExtension(videoInformationJSON)
{
	// if no url then we assume that this video requires login...
	if (typeof videoInformationJSON.args.url_encoded_fmt_stream_map == 'undefined') return { needLogin: true };
	// get the video url
	var url_encoded_fmt_stream_map = videoInformationJSON.args.url_encoded_fmt_stream_map;
	// split into small chunks
	var url_encoded_fmt_stream_map_arr = url_encoded_fmt_stream_map.split(",");
	var videos_arr = new Array();
	// get video formats
	for (var n in url_encoded_fmt_stream_map_arr)
	{
		videos_arr.push(getVideoObjectFromEncodedParam(url_encoded_fmt_stream_map_arr[n]));
	}
	// get the first video
	var video = videos_arr[0];
	// init result
	return {
		url: video.url + "&signature=" + video.sig,
		extension: extensionFromVideoType(getToken(video.type, ";", 0))
	};
}

function getVideoObjectFromEncodedParam(encodedParam)
{
	var json = "";
	var params_arr = encodedParam.split("&");
	// convert each "line" into json objects
	for (var i in params_arr)
	{
		json += '"' + strReplace(params_arr[i], '=', '":"') + '"';
		if (i < params_arr.length - 1) json += ",";
	}
	// parse json and convert it
	var video = eval('({' + json + '})');
	// clean up object variables
	for (var member in video)
	{
		video[member] = cleanUrl(video[member]);
	}
	// add this new one
	return video;
}

function extensionFromVideoType(vtype)
{
	if (vtype == "video/x-flv") return ".flv";
	if (vtype == "video/mp4") return ".mp4";
	if (vtype == "video/webm") return ".webm";
	// default extension
	return ".flv";
}

/*
	This function "normalizeSpaces(str)" will be deprecated on next xVST version
	and replaced with the new "simplifyString(str)" function (added in xVST 2.3.1)
*/
function normalizeSpaces(str)
{
	var result = "";
	var parts = splitString(str, " ", false);
	// join again each part
	for (var n = 1; n < parts.length; n++)
		result += parts[n] + " ";
	// return the normalized string
	return trimString(result);
}

function searchVideos(keyWord, pageIndex)
{
	const URL_SEARCH = "http://gdata.youtube.com/feeds/api/videos?q=%1&orderby=published&start-index=%2&max-results=%3&v=2&alt=jsonc&hl=%4";
	const RESULTS_COUNT = 10
	// init search results object
	var searchResults = new SearchResults();
	// replace all spaces for "+"
	keyWord = strReplace(keyWord, " ", "+");
	// update the page index
	var firstResult = (pageIndex - 1)*RESULTS_COUNT + 1;
	// init http object
	var http = new Http();
	var json = http.downloadWebpage(strFormat(URL_SEARCH, keyWord, firstResult, RESULTS_COUNT, searchResults.getUserLanguage()));
	var results = eval('(' + json + ')');
	// set summary
	searchResults.setSummary(results.data.totalItems + " results");
	// fill with search results
	for (var index in results.data.items)
	{
		var result = results.data.items[index];
		searchResults.addSearchResult(result.player['default'], result.thumbnail.sqDefault, result.title, result.description, result.duration, 0);
	}
	// return search results
	return searchResults;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x01,0xb2,0x49,0x44,0x41,0x54,0x78,0xda,0xa5,0x92,0xbf,0x4b,0x82,
		0x61,0x10,0xc7,0x25,0x70,0xb1,0xa1,0x34,0x08,0x1a,0xb2,0x70,0x28,0xa1,0x48,0xc4,
		0x7e,0x38,0xe8,0x10,0x38,0x05,0x0d,0x0d,0x2a,0x19,0x0d,0x51,0x0e,0x2d,0x12,0x0e,
		0x49,0xd0,0x54,0x14,0xfe,0x15,0x51,0x82,0x41,0x21,0x26,0x3a,0x48,0xb8,0x35,0x08,
		0x91,0x4b,0xe0,0x10,0x81,0x15,0x0d,0x8d,0x06,0x0d,0x2e,0x0d,0x9f,0xb8,0xf7,0xe0,
		0x41,0x24,0xa2,0xe8,0x0b,0xc7,0xdd,0xbd,0xdc,0x7d,0xee,0x9e,0xf7,0x79,0x6c,0xa0,
		0xb2,0xd9,0x6c,0xc6,0xff,0x45,0x56,0x75,0xab,0xd5,0xb2,0x1a,0xb3,0xd9,0xac,0x78,
		0xc9,0xff,0x02,0x50,0x65,0x32,0x19,0xab,0x39,0x1a,0x8d,0xd2,0x6e,0xb7,0xf1,0x78,
		0x3c,0x92,0x8b,0x37,0x9b,0x35,0x1a,0x0d,0x9c,0x4e,0xe7,0xb7,0x00,0x69,0x32,0x45,
		0x22,0x69,0x94,0x6f,0xd2,0x50,0xab,0xd5,0x7e,0x02,0x18,0xfd,0x0c,0xd0,0x23,0xfe,
		0x0a,0xf0,0xed,0x11,0x02,0x81,0x80,0xe4,0x62,0x3d,0x80,0x7f,0x4a,0x01,0x57,0x57,
		0x30,0x31,0x01,0xae,0x21,0x18,0x77,0xcb,0x38,0x98,0x9f,0x87,0x60,0x10,0xc6,0xdc,
		0x30,0x33,0x03,0xf1,0x38,0x64,0x8f,0xe1,0xe6,0x06,0xee,0xef,0xe1,0xf2,0xb2,0x0b,
		0x30,0x32,0x02,0x0f,0x0f,0x18,0x4d,0x4e,0xc2,0xe0,0x20,0xc8,0xba,0x1f,0x1f,0xe0,
		0xf3,0x49,0xac,0x43,0xdc,0x6e,0xb8,0xb8,0x80,0xdd,0x5d,0x03,0xd0,0x89,0x76,0x3b,
		0x96,0x96,0x96,0xd4,0x96,0x97,0x61,0x6e,0x0e,0x9e,0x9e,0xa0,0x5c,0x86,0x85,0x05,
		0x70,0xb9,0xe0,0xfc,0x1c,0xa6,0xa6,0x20,0x1c,0xee,0x02,0xcc,0xce,0x42,0x5f,0x1f,
		0x74,0x3a,0x3a,0xfd,0xed,0x0d,0x4e,0x4e,0xe0,0xfa,0x1a,0xce,0xce,0xe0,0xfd,0x5d,
		0xe3,0xd3,0x53,0x78,0x7d,0x85,0xe7,0x67,0xa9,0xef,0xd9,0xa0,0xbf,0x1f,0x3e,0x3f,
		0x35,0xae,0xd7,0xe1,0xe8,0x08,0x72,0x39,0x28,0x14,0x60,0x6d,0x4d,0x7d,0xb5,0x0a,
		0x8f,0x8f,0x20,0x2f,0x75,0x60,0xa0,0x07,0xe0,0x70,0x60,0xb6,0xb9,0xbb,0x83,0x74,
		0x1a,0xf2,0x79,0x28,0x95,0x60,0x73,0x13,0x2a,0x15,0xb8,0xbd,0xd5,0x9f,0xb9,0xb7,
		0x27,0x0f,0xa5,0x0b,0x10,0x0a,0x59,0x00,0x03,0x6b,0x36,0x01,0x04,0xa0,0xab,0x8b,
		0x8a,0x45,0xd8,0xdf,0xd7,0xf8,0xe5,0x05,0x86,0x87,0xbb,0x00,0xeb,0xeb,0x30,0x3d,
		0x0d,0x8b,0x8b,0xe0,0xf5,0xea,0xf5,0x45,0x22,0x7a,0x7d,0x7e,0x3f,0xac,0xac,0x48,
		0xac,0x6b,0x27,0x93,0x30,0x3a,0x0a,0x89,0x84,0x01,0xa8,0x0e,0x0f,0x61,0x7b,0x1b,
		0x52,0x29,0xd8,0xd8,0x80,0xd5,0x55,0x29,0x52,0x8b,0xc5,0x60,0x6b,0x0b,0x76,0x76,
		0xf4,0x38,0x07,0x07,0xa6,0xed,0x0b,0xd9,0x64,0x1a,0x67,0x99,0x78,0xec,0x66,0x00,
		0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
