/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.zedge.net/";
	this.ID = "zedge.net";
	this.caption = "Zedge";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_XML = "http://www.zedge.net/zedge-api/api-video-player.php";
	const XML_PARAMS = "zapi_session_id=%1&video_id=%2&get_video=";
	// video information
	var result = new VideoDefinition();
	// download html
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get the video id
	var html = copyBetween(html, "<embed flashvars=", "</embed>");
	var zapId = copyBetween(html, "sessionid=", "&");
	var vidID = copyBetween(html, "vid=", "&");
	// get xml file
	var xml = http.downloadWebpagePost(URL_GET_XML, strFormat(XML_PARAMS, zapId, vidID));
	// get the video title
	result.title = copyBetween(xml, "vtitle=", "&");
	result.title = strReplace(result.title, "+", " ");
	// get the flv url
	result.URL = cleanUrl(copyBetween(xml, "vflv=", "&"));
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x03,0x3d,0x49,0x44,0x41,0x54,0x38,0x11,0x05,0xc1,0xcd,0x4f,0x1c,
		0x75,0x1c,0xc0,0xe1,0xcf,0x6f,0x66,0x77,0xf6,0x65,0x76,0xf7,0xb7,0x2f,0x74,0x81,
		0x42,0x15,0x29,0x35,0xd2,0x22,0x4d,0x3d,0x98,0xe8,0xc1,0x86,0xe0,0xc5,0xa2,0x26,
		0x9a,0x9e,0x2a,0xda,0x58,0x6e,0xa2,0xf7,0x1a,0xf5,0xa2,0xfd,0x03,0x1a,0xa3,0xf1,
		0xa0,0x07,0xdf,0xd0,0x43,0xe1,0xd2,0xa6,0x29,0xd1,0xa4,0x26,0xa5,0xc6,0x83,0x31,
		0x62,0x14,0xc2,0x5b,0x17,0x76,0xa1,0xd0,0xf2,0xbe,0x2f,0xb3,0xcb,0xce,0xce,0xcc,
		0xd7,0xe7,0x51,0x0d,0xa7,0x52,0x52,0x4a,0xa5,0x7c,0xd3,0xe0,0xcf,0xab,0x1f,0xb1,
		0x3d,0x73,0x9f,0xa1,0x9f,0x27,0xd0,0xbd,0x4f,0x11,0x78,0x1e,0x66,0x38,0x8c,0x88,
		0x10,0xb8,0x2e,0x81,0xef,0xa3,0x94,0x02,0x00,0x00,0xa8,0x18,0x22,0x92,0x15,0x11,
		0x5d,0xa9,0x54,0xb4,0x33,0x70,0x46,0x1f,0xcc,0xcd,0xe9,0xd5,0x89,0x09,0x1d,0x80,
		0x6e,0xec,0xee,0xea,0xb5,0x3b,0xd3,0x7a,0xf9,0xfb,0x1f,0xb5,0x5b,0xad,0x6a,0x65,
		0x9a,0x5a,0x44,0xb4,0x88,0x68,0x11,0xd1,0x22,0x92,0x0d,0x89,0x88,0x17,0x8a,0xc5,
		0xb0,0xea,0x75,0xac,0xae,0x2e,0xe2,0xe7,0x9e,0x63,0xf1,0xcb,0xaf,0xa8,0x95,0x36,
		0x38,0x2a,0xad,0x23,0x5e,0x13,0x09,0x04,0xcf,0xf7,0xe8,0x1f,0xbb,0x82,0x5b,0xa9,
		0xa0,0x94,0x02,0xa5,0x40,0xc4,0x53,0x87,0x8f,0xb7,0x0e,0x0b,0x37,0x6e,0xe8,0x9d,
		0x7b,0xf7,0xd9,0x59,0x5c,0xa0,0xb6,0xbc,0x82,0x5f,0xaf,0x13,0x57,0x06,0xe9,0x7c,
		0x9e,0xd8,0xf1,0x4e,0x22,0x9d,0xed,0x34,0x94,0xc1,0xf3,0x5f,0x7c,0x4e,0x2c,0x9f,
		0x47,0x3c,0x0f,0x00,0xa0,0x1c,0xda,0xaf,0x96,0x59,0xf8,0xe5,0x57,0x1e,0xdf,0xbc,
		0x85,0x01,0x04,0x80,0x1d,0x0e,0x93,0x1a,0x38,0x83,0x1e,0x3c,0x8b,0xd5,0xff,0x34,
		0x6e,0x69,0x03,0x77,0x66,0x86,0xb5,0xc9,0x29,0xfa,0x3f,0x78,0x1f,0x71,0x5d,0x44,
		0x04,0x10,0x42,0x87,0x35,0x07,0x86,0x86,0xb0,0xee,0xde,0x25,0x1c,0x08,0xe7,0x3e,
		0xf9,0x18,0xa3,0xbb,0x1b,0xbf,0xe7,0x09,0x82,0x64,0x9a,0x9d,0x83,0x3d,0x3a,0xce,
		0xc7,0x09,0x0a,0x05,0x1e,0xdd,0xbc,0x45,0xfb,0xf9,0x97,0xc8,0x9c,0xee,0x27,0x68,
		0x36,0x01,0x30,0xe2,0x96,0x45,0xa4,0xb7,0x87,0xfc,0xc8,0x08,0x2d,0xcf,0x23,0x77,
		0xb2,0x97,0xc8,0xf0,0x30,0xd5,0x56,0x0b,0x75,0x54,0xe7,0x58,0x34,0x82,0xd2,0x29,
		0xf2,0xaf,0xbf,0x86,0xb7,0xb3,0x4d,0x61,0xe2,0x27,0x44,0x04,0x00,0x44,0x50,0x1b,
		0x6b,0xcb,0x87,0xff,0x2e,0x2e,0xeb,0x68,0xb9,0xca,0xfa,0xd5,0x0f,0x51,0xf1,0x18,
		0xaf,0xde,0xbe,0x4d,0xc3,0x0a,0x63,0x99,0x26,0xc9,0x64,0x12,0x33,0x12,0xc3,0x2d,
		0x97,0x99,0x79,0x7b,0x14,0x77,0x6b,0x8b,0x67,0xae,0x7d,0x46,0xfe,0xc5,0x17,0xf0,
		0x1b,0x8d,0xb2,0x11,0x89,0x44,0xd1,0xd1,0x28,0xf5,0xb4,0xa6,0x6b,0xf4,0x2d,0x36,
		0xff,0x9b,0x63,0xe9,0xdb,0xef,0xe8,0xec,0x38,0x4e,0xee,0x58,0x3b,0x56,0x34,0x8e,
		0xa9,0x14,0xb1,0x74,0x9a,0x9e,0xcb,0x97,0xf1,0x5a,0x2d,0x8a,0x93,0x93,0xb8,0x75,
		0x87,0x00,0x30,0x40,0xc8,0xe4,0xb2,0x1c,0xd5,0xaa,0x44,0x5f,0x1e,0x26,0xd9,0x77,
		0x92,0xbf,0xae,0x5f,0x67,0xf3,0x8f,0xdf,0x01,0x70,0x9c,0x1a,0x4b,0x85,0x07,0xb8,
		0x9e,0xcf,0x93,0x23,0x17,0xd0,0xa7,0xfb,0x71,0x17,0x16,0xd9,0x9f,0x9b,0x07,0x53,
		0x61,0x48,0x10,0x90,0x48,0xd8,0x58,0x86,0xa2,0x6e,0x98,0x9c,0x1a,0x1f,0xc7,0x3d,
		0x38,0xe0,0xde,0x7b,0xe3,0x94,0x8b,0x6b,0x44,0xec,0x04,0x49,0x9d,0xc2,0x0a,0x99,
		0x04,0x4d,0x97,0xa0,0xe9,0x12,0xb1,0xe3,0xb8,0xbb,0x3b,0x04,0xca,0xc0,0x68,0x79,
		0x2d,0x4c,0x43,0x91,0xd1,0x69,0xf6,0x1e,0x6e,0x90,0x7f,0xe5,0x02,0xdd,0x17,0x2f,
		0x52,0x9a,0xfd,0x87,0xe9,0x37,0xde,0x64,0x75,0xe2,0x07,0xcc,0x62,0x89,0x95,0xa9,
		0x29,0x7e,0xbb,0x74,0x89,0xa3,0xc5,0x65,0xbc,0xa3,0x26,0x4a,0x29,0x82,0xa0,0x45,
		0x08,0x40,0x29,0x48,0x67,0xd2,0x14,0x4b,0x25,0x0e,0xf6,0xb6,0x39,0x7b,0xed,0x53,
		0xb2,0x99,0x34,0xb3,0x5f,0x7f,0xc3,0xa3,0xd1,0x77,0x88,0xd8,0x36,0x4d,0xc7,0x21,
		0x0e,0xb4,0x77,0x75,0xd3,0x8a,0xc5,0x88,0x9e,0xea,0x43,0x3c,0x9f,0x90,0xef,0x79,
		0x88,0x61,0x90,0x4c,0xda,0xe4,0xda,0xda,0xd8,0x5c,0x2d,0x90,0xc9,0xe4,0x88,0x5e,
		0x19,0xe3,0x44,0x22,0x41,0xf9,0xce,0x34,0xee,0xea,0x2a,0x21,0xa0,0x65,0xdb,0xec,
		0xd9,0x71,0x4e,0x8c,0xbd,0x8b,0xd5,0x96,0xa3,0xd5,0x68,0xa0,0x8a,0x2b,0xf3,0x35,
		0xc0,0x36,0x0c,0x83,0x72,0xd5,0x61,0xf6,0xef,0x59,0x50,0x8a,0x54,0xb6,0x0d,0x22,
		0x16,0xcd,0xbd,0x7d,0x0e,0x97,0x16,0x10,0xc7,0xc1,0xb4,0x6d,0x3a,0x9e,0x1d,0xa0,
		0x6f,0x70,0x90,0xb8,0x12,0x02,0x11,0x47,0x15,0x57,0xe6,0x4b,0x40,0x0a,0x00,0x14,
		0xa5,0xf5,0x87,0x3c,0x28,0x14,0xf0,0x7d,0x9f,0x50,0x38,0x4c,0x36,0x9b,0x23,0x95,
		0x49,0xa3,0x42,0x26,0x31,0xcb,0x22,0x95,0x4c,0x10,0x0f,0x99,0x04,0x22,0x00,0x95,
		0xff,0x01,0x7d,0x67,0x7b,0x8c,0xcc,0x0f,0xef,0xdd,0x00,0x00,0x00,0x00,0x49,0x45,
		0x4e,0x44,0xae,0x42,0x60,0x82);
}
