/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.model;

import at.laborg.briss.model.PageCluster;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterDefinition {
    private final List<PageCluster> clusters = new ArrayList<PageCluster>();

    public final PageCluster getSingleCluster(int pageNumber) {
        for (PageCluster cluster : this.clusters) {
            if (!cluster.getAllPages().contains(pageNumber)) continue;
            return cluster;
        }
        return null;
    }

    public final List<PageCluster> getClusterList() {
        return this.clusters;
    }

    public final void addOrMergeCluster(PageCluster tmpCluster) {
        PageCluster existingCluster = this.findNearlyEqualCluster(tmpCluster);
        if (existingCluster != null) {
            existingCluster.mergeClusters(tmpCluster);
        } else {
            this.clusters.add(tmpCluster);
        }
    }

    private PageCluster findNearlyEqualCluster(PageCluster clusterToCheck) {
        for (PageCluster cluster : this.clusters) {
            if (!cluster.isClusterNearlyEqual(clusterToCheck)) continue;
            return cluster;
        }
        return null;
    }

    public final void selectAndSetPagesForMerging() {
        for (PageCluster cluster : this.clusters) {
            cluster.choosePagesToMerge();
        }
    }

    public final int getNrOfPagesToRender() {
        int size = 0;
        for (PageCluster cluster : this.clusters) {
            size += cluster.getPagesToMerge().size();
        }
        return size;
    }
}

