/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.io.RandomAccessIO;

public class IISRandomAccessIO
implements RandomAccessIO {
    private ImageInputStream iis;

    public IISRandomAccessIO(ImageInputStream imageInputStream) {
        if (imageInputStream == null) {
            throw new IllegalArgumentException("iis == null!");
        }
        this.iis = imageInputStream;
    }

    public void close() throws IOException {
        this.iis.close();
    }

    public int getPos() throws IOException {
        long l = this.iis.getStreamPosition();
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public void seek(int n) throws IOException {
        this.iis.seek(n);
    }

    public int length() throws IOException {
        long l;
        int n;
        long l2 = this.iis.length();
        if (l2 != -1L) {
            return l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
        }
        this.iis.mark();
        int n2 = 1024;
        byte[] byArray = new byte[n2];
        for (l = this.iis.getStreamPosition(); l < Integer.MAX_VALUE && (n = this.iis.read(byArray, 0, n2)) != -1; l += (long)n) {
        }
        this.iis.reset();
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public int read() throws IOException {
        return this.iis.read();
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.iis.readFully(byArray, n, n2);
    }

    public int getByteOrdering() {
        return this.iis.getByteOrder() == ByteOrder.BIG_ENDIAN ? 0 : 1;
    }

    public byte readByte() throws IOException {
        return this.iis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.iis.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.iis.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.iis.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.iis.readInt();
    }

    public long readUnsignedInt() throws IOException {
        return this.iis.readUnsignedInt();
    }

    public long readLong() throws IOException {
        return this.iis.readLong();
    }

    public float readFloat() throws IOException {
        return this.iis.readFloat();
    }

    public double readDouble() throws IOException {
        return this.iis.readDouble();
    }

    public int skipBytes(int n) throws IOException {
        return this.iis.skipBytes(n);
    }

    public void flush() {
    }

    public void write(int n) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    public void writeByte(int n) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    public void writeShort(int n) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    public void writeInt(int n) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    public void writeLong(long l) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    public void writeFloat(float f) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    public void writeDouble(double d) throws IOException {
        throw new IOException("Writing is not supported!");
    }
}

