/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.fileformat.writer;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import jj2000.j2k.fileformat.FileFormatBoxes;
import jj2000.j2k.io.BEBufferedRandomAccessFile;
import org.w3c.dom.NodeList;

public class FileFormatWriter
implements FileFormatBoxes {
    private File file;
    private ImageOutputStream stream;
    private int height;
    private int width;
    private int nc;
    private int[] bpc;
    private boolean bpcVaries;
    private int clength;
    private static final int CSB_LENGTH = 15;
    private static final int FTB_LENGTH = 20;
    private static final int IHB_LENGTH = 22;
    private static final int BPC_LENGTH = 8;
    private ColorModel colorModel;
    private SampleModel sampleModel;
    private J2KMetadata metadata;
    private boolean isIndexed = false;
    private int otherLength;
    J2KMetadataFormat format;

    public FileFormatWriter(File file, ImageOutputStream imageOutputStream, int n, int n2, int n3, int[] nArray, int n4, ColorModel colorModel, SampleModel sampleModel, J2KMetadata j2KMetadata) {
        this.height = n;
        this.width = n2;
        this.nc = n3;
        this.bpc = nArray;
        this.file = file;
        this.stream = imageOutputStream;
        this.clength = n4;
        this.colorModel = colorModel;
        this.sampleModel = sampleModel;
        this.metadata = j2KMetadata;
        if (colorModel instanceof IndexColorModel) {
            this.isIndexed = true;
        }
        this.bpcVaries = false;
        int n5 = nArray[0];
        for (int i = n3 - 1; i > 0; --i) {
            if (nArray[i] == n5) continue;
            this.bpcVaries = true;
        }
    }

    public int writeFileFormat() throws IOException {
        this.writeMetadata(this.metadata);
        this.writeContiguousCodeStreamBox();
        return 15 + this.otherLength;
    }

    private void writeMetadata(J2KMetadata j2KMetadata) throws IOException {
        if (j2KMetadata == null) {
            return;
        }
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)j2KMetadata.getAsTree("com_sun_media_imageio_plugins_jpeg2000_image_1.0");
        if (iIOMetadataNode == null) {
            return;
        }
        this.format = (J2KMetadataFormat)j2KMetadata.getMetadataFormat("com_sun_media_imageio_plugins_jpeg2000_image_1.0");
        this.writeSuperBox(iIOMetadataNode);
    }

    private void writeSuperBox(IIOMetadataNode iIOMetadataNode) throws IOException {
        NodeList nodeList = iIOMetadataNode.getChildNodes();
        String string = iIOMetadataNode.getNodeName();
        if (string.startsWith("JPEG2000")) {
            this.stream.writeInt(this.computeLength(iIOMetadataNode));
            this.stream.writeInt(Box.getTypeInt(Box.getTypeByName(string)));
            this.otherLength += 8;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)nodeList.item(i);
            string = iIOMetadataNode2.getNodeName();
            if (string.startsWith("JPEG2000") && this.format.isLeaf(string)) {
                this.writeBox(iIOMetadataNode2);
                continue;
            }
            this.writeSuperBox(iIOMetadataNode2);
        }
    }

    private void writeBox(IIOMetadataNode iIOMetadataNode) throws IOException {
        int n = Box.getTypeInt((String)Box.getAttribute(iIOMetadataNode, "Type"));
        int n2 = new Integer((String)Box.getAttribute(iIOMetadataNode, "Length"));
        Box box = Box.createBox(n, iIOMetadataNode);
        this.otherLength += n2;
        this.stream.writeInt(n2);
        this.stream.writeInt(n);
        byte[] byArray = box.getContent();
        this.stream.write(byArray, 0, byArray.length);
    }

    private int computeLength(IIOMetadataNode iIOMetadataNode) {
        NodeList nodeList = iIOMetadataNode.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)nodeList.item(i);
            String string = iIOMetadataNode2.getNodeName();
            if (this.format.isLeaf(string)) {
                n += new Integer((String)Box.getAttribute(iIOMetadataNode2, "Length")).intValue();
                continue;
            }
            n += this.computeLength(iIOMetadataNode2);
        }
        return n + (iIOMetadataNode.getNodeName().startsWith("JPEG2000") ? 8 : 0);
    }

    public void writeContiguousCodeStreamBox() throws IOException {
        int n;
        if (this.metadata != null) {
            this.stream.writeInt(this.clength + 8);
            this.stream.writeInt(1785737827);
        }
        BEBufferedRandomAccessFile bEBufferedRandomAccessFile = new BEBufferedRandomAccessFile(this.file, "rw+");
        byte[] byArray = new byte[1024];
        for (int i = this.clength; i > 0; i -= n) {
            n = i > 1024 ? 1024 : i;
            bEBufferedRandomAccessFile.readFully(byArray, 0, n);
            this.stream.write(byArray, 0, n);
        }
        bEBufferedRandomAccessFile.close();
    }
}

