/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.CIDEncodings;
import org.jpedal.objects.raw.FontObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class PdfFont
implements Serializable {
    public Font javaFont = null;
    private Rectangle BBox = null;
    private static final int noWidth = -1;
    protected boolean containsHexNumbers = false;
    protected boolean allNumbers = false;
    protected String embeddedFontName = null;
    protected String embeddedFamilyName = null;
    protected String copyright = null;
    private float missingWidth = -1.0f;
    protected boolean isFontVertical = false;
    private float lastWidth = -1.0f;
    public PdfJavaGlyphs glyphs = new PdfJavaGlyphs();
    private String[] cachedValue = new String[256];
    private static final int[] powers = new int[]{1, 16, 256, 4096};
    private String rawFontName = null;
    private float currentWidth;
    protected String substituteFont = null;
    protected boolean renderPage = false;
    private static final float xscale = 0.001f;
    protected int embeddedEnc = 1;
    protected String[] diffs;
    public boolean isFontEmbedded = false;
    protected boolean TTstreamisCID = false;
    protected String fontID = "";
    protected int maxCharCount = 256;
    protected boolean hasEncoding = true;
    private boolean isDoubleByte = false;
    protected int fontTypes;
    protected String substituteFontFile = null;
    protected String substituteFontName = null;
    private int spaceChar = -1;
    String[] diffTable;
    private int[] diffCharTable;
    protected Map diffLookup = null;
    private float[] widthTable;
    private float possibleSpaceWidth = -1.0f;
    protected PdfObjectReader currentPdfFile;
    protected ClassLoader loader = this.getClass().getClassLoader();
    public double[] FontMatrix = new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};
    public float[] FontBBox = new float[]{0.0f, 0.0f, 1000.0f, 1000.0f};
    protected boolean isHex = false;
    private String[] unicodeMappings;
    protected int fontEnc = -1;
    protected boolean isCIDFont = false;
    private String[] CMAP;
    private String CIDfontEncoding;
    private float defaultWidth = 1.0f;
    protected boolean isFontSubstituted = false;
    protected int italicAngle = 0;
    boolean hasMatrixSet = false;
    boolean hasFBoxSet = false;
    private static boolean isCidJarPresent;

    public PdfFont() {
    }

    public void createFont(String string) throws Exception {
    }

    public PdfFont(PdfObjectReader pdfObjectReader) {
        this.init(pdfObjectReader);
    }

    private static void setStandardFontMappings() {
        String string;
        String string2;
        int n;
        int n2 = StandardFonts.files_names.length;
        for (n = 0; n < n2; ++n) {
            string2 = StandardFonts.files_names_bis[n].toLowerCase();
            if (string2.equals(string = StandardFonts.javaFonts[n].toLowerCase()) || FontMappings.fontSubstitutionAliasTable.containsKey(string2)) continue;
            FontMappings.fontSubstitutionAliasTable.put(string2, string);
        }
        for (n = 0; n < n2; ++n) {
            string2 = StandardFonts.files_names[n].toLowerCase();
            if (!string2.equals(string = StandardFonts.javaFonts[n].toLowerCase()) && !FontMappings.fontSubstitutionAliasTable.containsKey(string2)) {
                FontMappings.fontSubstitutionAliasTable.put(string2, string);
            }
            StandardFonts.javaFontList.put(StandardFonts.files_names[n], "x");
        }
    }

    public boolean isFontSubstituted() {
        return this.isFontSubstituted;
    }

    public boolean isDoubleByte() {
        return this.isDoubleByte;
    }

    private void setCIDFontWidths(String string) {
        if ((string = string.substring(1, string.length() - 1).trim()).length() == 0) {
            return;
        }
        this.widthTable = new float[65536];
        for (int i = 0; i < 65536; ++i) {
            this.widthTable[i] = -1.0f;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " []", true);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() && (string4 = stringTokenizer.nextToken()).equals(" ")) {
        }
        boolean bl = false;
        while (!bl) {
            int n3;
            if (string4.equals("R")) {
                String string5 = string3 + ' ' + string2 + " R";
                n3 = Integer.parseInt(string3);
                int n4 = Integer.parseInt(string2);
                n = n2;
                FontObject fontObject = new FontObject(string5);
                byte[] byArray = this.currentPdfFile.getObjectReader().readObjectAsByteArray(fontObject, this.currentPdfFile.getObjectReader().isCompressed(n3, n4), n3, n4);
                StringTokenizer stringTokenizer2 = new StringTokenizer(new String(byArray), " []");
                while (stringTokenizer2.hasMoreTokens()) {
                    String string6 = stringTokenizer2.nextToken();
                    this.widthTable[n] = Float.parseFloat(string6) / 1000.0f;
                    ++n;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    while (stringTokenizer.hasMoreTokens() && (string4 = stringTokenizer.nextToken()).equals(" ")) {
                    }
                    continue;
                }
                bl = true;
                continue;
            }
            string3 = string2;
            string2 = string4;
            n2 = n;
            n = Integer.parseInt(string2);
            while ((string2 = stringTokenizer.nextToken()).equals(" ")) {
            }
            if (string2.equals("[")) {
                while (true) {
                    if ((string2 = stringTokenizer.nextToken()).equals(" ")) {
                        continue;
                    }
                    if (string2.equals("]")) break;
                    this.widthTable[n] = Float.parseFloat(string2) / 1000.0f;
                    ++n;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    while (stringTokenizer.hasMoreTokens() && (string4 = stringTokenizer.nextToken()).equals(" ")) {
                    }
                    continue;
                }
                bl = true;
                continue;
            }
            int n5 = 1 + Integer.parseInt(string2);
            string3 = string2;
            while ((string2 = stringTokenizer.nextToken()).equals(" ")) {
            }
            if (stringTokenizer.hasMoreTokens()) {
                while (stringTokenizer.hasMoreTokens() && (string4 = stringTokenizer.nextToken()).equals(" ")) {
                }
            } else {
                bl = true;
            }
            if (string4.equals("R")) continue;
            for (n3 = n; n3 < n5; ++n3) {
                this.widthTable[n3] = Float.parseFloat(string2) / 1000.0f;
            }
        }
    }

    public final boolean isCIDFont() {
        return this.isCIDFont;
    }

    protected final void init(PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
        if (this.isCIDFont) {
            this.maxCharCount = 65536;
        }
        this.glyphs.init(this.maxCharCount, this.isCIDFont);
    }

    private final String getUnicodeMapping(int n) {
        if (this.unicodeMappings == null) {
            return null;
        }
        return this.unicodeMappings[n];
    }

    protected final void putFontEncoding(int n) {
        if (n == 2 && this.getBaseFontName().equals("Symbol")) {
            this.putFontEncoding(4);
            n = 4;
        }
        this.fontEnc = n;
        StandardFonts.checkLoaded(n);
    }

    public final String getUnicodeValue(String string, int n) {
        String string2 = this.getUnicodeMapping(n);
        if (string2 == null) {
            string2 = string;
        }
        if (string.length() > 0) {
            char c = string.charAt(0);
            switch (c) {
                case '\u00ad': {
                    if (this.fontEnc != 2 && this.fontEnc != 1) break;
                    string2 = "-";
                    break;
                }
                case '\ufb00': {
                    string2 = "ff";
                    break;
                }
                case '\ufb01': {
                    string2 = "fi";
                    break;
                }
                case '\ufb04': {
                    string2 = "ffl";
                }
            }
        }
        return string2;
    }

    public final String getGlyphValue(int n) {
        if (this.cachedValue[n] != null) {
            return this.cachedValue[n];
        }
        String string = null;
        if (this.isCIDFont) {
            String string2 = this.getUnicodeMapping(n);
            if (string2 != null) {
                string = string2;
            }
            if (string == null) {
                String string3 = this.CIDfontEncoding;
                if (this.diffTable != null) {
                    string = this.diffTable[n];
                } else if (string3 != null) {
                    String string4;
                    if (string3.startsWith("Identity-")) {
                        string = String.valueOf((char)n);
                    } else if (this.CMAP != null && (string4 = this.CMAP[n]) != null) {
                        string = string4;
                    }
                }
                if (string == null) {
                    string = String.valueOf((char)n);
                }
            }
        } else {
            string = this.getStandardGlyphValue(n);
        }
        this.cachedValue[n] = string;
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final String handleCIDEncoding(PdfObject var1_1) throws PdfFontException {
        block35: {
            var2_2 = null;
            var3_3 = var1_1.getGeneralType(1232564598);
            var4_4 = CIDEncodings.getNameForEncoding(var3_3);
            if (var4_4 == null) {
                if (var3_3 == 2038913669) {
                    var4_4 = "Identity-H";
                } else if (var3_3 == 2038913683) {
                    var4_4 = "Identity-V";
                    this.isFontVertical = true;
                } else {
                    var4_4 = var1_1.getGeneralStringValue();
                }
            }
            if ((var5_5 = var1_1.getName(827223669)) != null) {
                var6_6 = this.currentPdfFile.readStream(var1_1, true, true, false, false, false, var1_1.getCacheName(this.currentPdfFile.getObjectReader()));
                var4_4 = var5_5;
                var2_2 = new BufferedReader(new StringReader(new String(var6_6)));
            }
            v0 = var6_7 = var3_3 == 2038913669 || var3_3 == 2038913683;
            if (var2_2 == null) {
                this.CIDfontEncoding = var4_4;
            }
            if (var6_7) {
                this.isDoubleByte = true;
                this.glyphs.setIsIdentity(true);
            } else {
                block33: {
                    if (!PdfFont.isCidJarPresent && var2_2 == null) {
                        PdfFont.isCidJarPresent = true;
                        var7_8 = PdfFont.class.getResourceAsStream("/org/jpedal/res/cid/00_ReadMe.pdf");
                        if (var7_8 == null) {
                            throw new PdfFontException("cid.jar not on classpath");
                        }
                    }
                    this.glyphs.setIsIdentity(false);
                    this.CMAP = new String[65536];
                    this.glyphs.CMAP_Translate = new int[65536];
                    this.isDoubleByte = CIDEncodings.isDoubleByte(var3_3);
                    try {
                        if (var2_2 == null) {
                            var2_2 = new BufferedReader(new InputStreamReader(this.loader.getResourceAsStream("org/jpedal/res/cid/" + var4_4), "Cp1252"));
                        }
                    }
                    catch (Exception var7_9) {
                        if (!LogWriter.isOutput()) break block33;
                        LogWriter.writeLog("1.Problem reading encoding for CID font " + this.fontID + " encoding=" + var4_4 + " Check CID.jar installed");
                    }
                }
                if (var2_2 != null) {
                    var7_8 = "";
                    var11_11 = false;
                    var12_12 = false;
                    while (true) {
                        block34: {
                            try {
                                var7_8 = var2_2.readLine();
                            }
                            catch (Exception var13_17) {
                                if (!LogWriter.isOutput()) break block34;
                                LogWriter.writeLog("[PDF] Error reading line from font");
                            }
                        }
                        if (var7_8 == null) break;
                        if (var7_8.indexOf("endcidrange") != -1) {
                            var11_11 = false;
                        } else if (var7_8.indexOf("endcidchar") != -1) {
                            var12_12 = false;
                        }
                        if (var11_11) {
                            var13_16 = new StringTokenizer((String)var7_8, " <>[]");
                            var14_19 = false;
                            if (var7_8.indexOf(91) != -1) {
                                var14_19 = true;
                            }
                            var8_13 = Integer.parseInt(var13_16.nextToken(), 16);
                            var9_14 = Integer.parseInt(var13_16.nextToken(), 16);
                            var10_15 = Integer.parseInt(var13_16.nextToken(), 16);
                            for (var15_20 = var8_13; var15_20 < var9_14 + 1; ++var15_20) {
                                if (var14_19) {
                                    var10_15 = Integer.parseInt(var13_16.nextToken(), 16);
                                    this.CMAP[var15_20] = String.valueOf((char)var10_15);
                                    continue;
                                }
                                this.CMAP[var15_20] = String.valueOf((char)var10_15);
                                ++var10_15;
                            }
                        } else if (var12_12) {
                            try {
                                var13_16 = new StringTokenizer((String)var7_8, " <>[]");
                                if (var13_16.countTokens() != 2) ** GOTO lbl86
                                var8_13 = Integer.parseInt(var13_16.nextToken(), 16);
                                this.glyphs.CMAP_Translate[var8_13] = var9_14 = Integer.parseInt(var13_16.nextToken());
                            }
                            catch (Exception var13_18) {
                                var13_18.getStackTrace();
                            }
                        }
lbl86:
                        // 6 sources

                        if (var7_8.indexOf("begincidrange") != -1) {
                            var11_11 = true;
                            continue;
                        }
                        if (var7_8.indexOf("begincidchar") == -1) continue;
                        var12_12 = true;
                    }
                }
            }
            if (var2_2 != null) {
                try {
                    var2_2.close();
                }
                catch (Exception var7_10) {
                    if (!LogWriter.isOutput()) break block35;
                    LogWriter.writeLog("2.Problem reading encoding for CID font " + this.fontID + ' ' + var4_4 + " Check CID.jar installed");
                }
            }
        }
        return var5_5;
    }

    private String getStandardGlyphValue(int n) {
        String string = this.getUnicodeMapping(n);
        if (string != null) {
            return string;
        }
        String string2 = "";
        int n2 = this.getFontEncoding(true);
        String string3 = this.getMappedChar(n, true);
        if (string3 != null) {
            String string4 = StandardFonts.getUnicodeName(this.fontEnc + string3);
            if (string4 != null) {
                string2 = string4;
            } else {
                string4 = StandardFonts.getUnicodeName(string3);
                if (string4 != null) {
                    string2 = string4;
                } else if (string3.length() == 1) {
                    string2 = string3;
                } else if (string3.length() > 1) {
                    int n3;
                    char c = string3.charAt(0);
                    char c2 = string3.charAt(1);
                    if (c == 'B' || c == 'C' || c == 'c' || c == 'G') {
                        string3 = string3.substring(1);
                        try {
                            n3 = this.isHex ? Integer.valueOf(string3, 16) : Integer.parseInt(string3);
                            string2 = String.valueOf((char)n3);
                        }
                        catch (Exception exception) {
                            string2 = "";
                        }
                    } else {
                        string2 = "";
                    }
                    int n4 = n3 = (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') && (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F') ? 1 : 0;
                    if (string2.length() == 0 && this.fontTypes == 1228944679 && string3.length() == 2 && n3 != 0) {
                        string2 = String.valueOf((char)Integer.parseInt(string3, 16));
                    }
                    if (string2.length() == 0) {
                        if (this.fontTypes == 1228944679) {
                            string2 = String.valueOf((char)n);
                        } else if (this.diffTable != null && this.diffTable[n] != null && this.fontEnc == 2 && (string2 = this.diffTable[n]).indexOf(95) != -1) {
                            string2 = string2.replaceAll("_", "");
                        }
                    }
                } else {
                    string2 = "";
                }
            }
        } else if (n2 > -1) {
            string2 = StandardFonts.getEncodedChar(n2, n);
        }
        return string2;
    }

    public final Font getJavaFont(int n) {
        String string;
        int n2 = 0;
        boolean bl = false;
        String string2 = null;
        Object var5_5 = null;
        String string3 = string = this.glyphs.fontName;
        if (string != null) {
            string3 = string.toLowerCase();
        }
        if (string3.equals("arialmt")) {
            string = string3 = "arial";
        } else if (string3.equals("arial-boldmt")) {
            string = string3 = "arial Bold";
        }
        if (var5_5 != null) {
            string = var5_5;
            string3 = string.toLowerCase();
        }
        if (PdfJavaGlyphs.fontList != null) {
            int n3 = PdfJavaGlyphs.fontList.length;
            for (int i = 0; i < n3; ++i) {
                System.out.println(PdfJavaGlyphs.fontList[i] + "<>" + string3);
                if (PdfJavaGlyphs.fontList[i].indexOf(string3) == -1) continue;
                bl = true;
                string = PdfJavaGlyphs.fontList[i];
                i = n3;
            }
        }
        if (!bl && string2 == null) {
            String string4 = string.toLowerCase();
            if (string4.indexOf("heavy") != -1) {
                n2 = 1;
            } else if (string4.indexOf("bold") != -1) {
                n2 = 1;
            } else if (string4.indexOf("roman") != -1) {
                n2 = 0;
            }
            if (string4.indexOf("italic") != -1) {
                n2 += 2;
            } else if (string4.indexOf("oblique") != -1) {
                n2 += 2;
            }
        }
        if (bl) {
            return new Font(string, n2, n);
        }
        if (LogWriter.isOutput()) {
            LogWriter.writeLog("No match with " + this.glyphs.getBaseFontName() + ' ' + ' ' + string3 + ' ' + string2 + ' ' + n2);
        }
        return null;
    }

    public final void setDefaultDisplayFont(String string) {
        this.glyphs.defaultFont = string;
    }

    public final Font getJavaFontX(int n) {
        Font font;
        if (PdfDecoder.Helper != null && (font = PdfDecoder.Helper.getJavaFontX(this, n)) != null) {
            return font;
        }
        return new Font(this.glyphs.font_family_name, this.glyphs.style, n);
    }

    public final String getFontName() {
        StandardFonts.loadStandardFontWidth(this.glyphs.fontName);
        return this.glyphs.fontName;
    }

    public final String getCopyright() {
        return this.copyright;
    }

    public final String getBaseFontName() {
        return this.glyphs.getBaseFontName();
    }

    public final void setBaseFontName(String string) {
        this.glyphs.setBaseFontName(string);
    }

    public final float getCurrentFontSpaceWidth() {
        int n = this.spaceChar;
        float f = n != -1 ? this.getWidth(n) : this.possibleSpaceWidth;
        if (f == -1.0f || f == 0.0f) {
            f = 0.2f;
        }
        return f;
    }

    protected final int getFontEncoding(boolean bl) {
        int n = this.fontEnc;
        if (n == -1 && bl) {
            n = 1;
        }
        return n;
    }

    public final float getWidth(int n) {
        if (n == -1) {
            return this.lastWidth;
        }
        float f = -1.0f;
        if (this.widthTable != null && n != -1) {
            f = this.widthTable[n];
        }
        if (f == -1.0f) {
            if (this.isCIDFont) {
                f = this.defaultWidth;
            } else {
                Float f2;
                String string = this.getMappedChar(n, false);
                if (string != null && string.equals(".notdef")) {
                    string = StandardFonts.getUnicodeChar(this.getFontEncoding(true), n);
                }
                if ((f2 = StandardFonts.getStandardWidth(this.glyphs.logicalfontName, string)) == null && this.rawFontName != null) {
                    StandardFonts.loadStandardFontWidth(this.rawFontName);
                    f2 = StandardFonts.getStandardWidth(this.rawFontName, string);
                }
                f = f2 != null ? f2.floatValue() : (this.missingWidth != -1.0f ? this.missingWidth * 0.001f : 0.0f);
            }
        }
        this.lastWidth = f;
        return f;
    }

    public void createCIDFont(PdfObject pdfObject, PdfObject pdfObject2) throws PdfFontException {
        PdfObject pdfObject3;
        Object object;
        PdfObject pdfObject4;
        int n;
        PdfObject pdfObject5;
        this.cachedValue = new String[65536];
        String string = null;
        PdfObject pdfObject6 = pdfObject.getDictionary(1232564598);
        if (pdfObject6 != null) {
            string = this.handleCIDEncoding(pdfObject6);
        }
        if ((pdfObject5 = pdfObject.getDictionary(1919185554)) != null) {
            this.readUnicode(this.currentPdfFile.readStream(pdfObject5, true, true, false, false, false, pdfObject5.getCacheName(this.currentPdfFile.getObjectReader())));
        }
        String string2 = pdfObject2.getName(39);
        String string3 = pdfObject2.getName(9986);
        if (string3 != null) {
            string2 = string3;
        }
        if (string2 != null) {
            this.setCIDFontWidths(string2);
        }
        if ((n = pdfObject2.getInt(5159)) >= 0) {
            this.defaultWidth = (float)n / 1000.0f;
        }
        if ((pdfObject4 = pdfObject2.getDictionary(946823533)) != null) {
            object = this.currentPdfFile.readStream(pdfObject4, true, true, false, false, false, null);
            if (object != null) {
                int n2 = 0;
                int n3 = ((Object)object).length;
                int[] nArray = new int[n3 / 2];
                for (int i = 0; i < n3; i += 2) {
                    nArray[n2] = ((object[i] & 0xFF) << 8) + (object[i + 1] & 0xFF);
                    ++n2;
                }
                this.glyphs.setGIDtoCID(nArray);
            } else if (pdfObject4.getParameterConstant(946823533) == -1) {
                string = this.handleCIDEncoding(new FontObject(2038913669));
            }
        }
        object = null;
        PdfObject pdfObject7 = pdfObject2.getDictionary(1972801240);
        if (pdfObject7 != null) {
            object = pdfObject7.getTextStreamValue(1635480172);
        }
        if (object != null) {
            if (pdfObject4 == null && object.indexOf("Identity") != -1) {
                if (string != null && !string.equals("Generic")) {
                    this.isDoubleByte = true;
                }
            } else if (object.indexOf("Japan") != -1) {
                this.substituteFontFile = "kochi-mincho.ttf";
                this.substituteFontName = "Kochi Mincho";
                this.TTstreamisCID = false;
            } else if (object.indexOf("Korean") != -1) {
                System.err.println("Unsupported font encoding " + (String)object);
            } else if (object.indexOf("Chinese") != -1) {
                System.err.println("Chinese " + (String)object);
            } else if (object.equals("Identity")) {
                this.glyphs.setIsIdentity(true);
            }
            if (this.substituteFontName != null && LogWriter.isOutput()) {
                LogWriter.writeLog("Using font " + this.substituteFontName + " for " + (String)object);
            }
        }
        if (pdfObject2 != null && (pdfObject3 = pdfObject2.getDictionary(-1044665361)) != null) {
            this.setBoundsAndMatrix(pdfObject3);
            this.setName(pdfObject3, this.fontID);
        }
    }

    protected final void selectDefaultFont() {
    }

    public void readWidths(PdfObject pdfObject, boolean bl) throws Exception {
        float f = 0.0f;
        int n = 0;
        float[] fArray = pdfObject.getFloatArray(876896124);
        if (fArray != null) {
            int n2;
            this.widthTable = new float[this.maxCharCount];
            for (n2 = 0; n2 < this.maxCharCount; ++n2) {
                this.widthTable[n2] = -1.0f;
            }
            n2 = pdfObject.getInt(1283093660);
            int n3 = pdfObject.getInt(795440262);
            float f2 = (float)(1.0 / this.FontMatrix[0]);
            if (f2 < 0.0f) {
                f2 = -f2;
            }
            int n4 = 0;
            int n5 = fArray.length;
            for (int i = n2; i < n3 + 1; ++i) {
                if (n4 < n5) {
                    float f3 = fArray[n4];
                    float f4 = this.fontTypes == 1228944679 ? f3 / f2 : f3 * 0.001f;
                    if (f4 > 0.0f) {
                        f += f4;
                        ++n;
                    }
                    this.widthTable[i] = f4;
                } else {
                    this.widthTable[i] = 0.0f;
                }
                ++n4;
            }
        }
        if (bl && n > 0) {
            this.possibleSpaceWidth = f / (float)(2 * n);
        }
    }

    public void createFont(PdfObject pdfObject, String string, boolean bl, ObjectStore objectStore, Map map) throws Exception {
        this.init(string, bl);
        PdfObject pdfObject2 = pdfObject.getDictionary(-1044665361);
        this.setName(pdfObject, string);
        this.setEncoding(pdfObject, pdfObject2);
    }

    protected void setName(PdfObject pdfObject, String string) {
        String string2 = pdfObject.getName(678461817);
        if (string2 == null) {
            string2 = pdfObject.getName(879786873);
        }
        if (string2 == null) {
            string2 = this.fontID;
        }
        if (string2.indexOf("#20") != -1) {
            string2 = PdfFont.cleanupFontName(string2);
        }
        this.glyphs.setBaseFontName(string2);
        String string3 = pdfObject.getStringValue(678461817, 2);
        if (string3 == null) {
            string3 = pdfObject.getStringValue(879786873, 2);
        }
        if (string3 == null) {
            string3 = this.fontID;
        }
        if (string3.indexOf("#20") != -1 || string3.indexOf("#2D") != -1) {
            string3 = PdfFont.cleanupFontName(string3);
        }
        this.glyphs.fontName = string3;
        if (string3.equals("Arial-BoldMT")) {
            this.glyphs.logicalfontName = "Arial,Bold";
            StandardFonts.loadStandardFontWidth(this.glyphs.logicalfontName);
        } else if (string3.equals("ArialMT")) {
            this.glyphs.logicalfontName = "Arial";
            StandardFonts.loadStandardFontWidth(this.glyphs.logicalfontName);
        } else {
            this.glyphs.logicalfontName = string3;
        }
    }

    protected void setEncoding(PdfObject pdfObject, PdfObject pdfObject2) {
        PdfObject pdfObject3;
        PdfObject pdfObject4 = pdfObject.getDictionary(1919185554);
        if (pdfObject4 != null) {
            this.readUnicode(this.currentPdfFile.readStream(pdfObject4, true, true, false, false, false, pdfObject4.getCacheName(this.currentPdfFile.getObjectReader())));
        }
        if ((pdfObject3 = pdfObject.getDictionary(1232564598)) != null) {
            this.handleFontEncoding(pdfObject, pdfObject3);
        } else {
            this.handleNoEncoding(0, pdfObject);
        }
        if (pdfObject2 != null) {
            int n = 0;
            if (pdfObject2 != null) {
                n = pdfObject2.getInt(1009858393);
            }
            this.glyphs.remapFont = false;
            int n2 = n;
            if ((n2 & 4) == 4) {
                this.glyphs.remapFont = true;
            }
            this.missingWidth = pdfObject2.getInt(-1884569950);
        }
    }

    protected void setBoundsAndMatrix(PdfObject pdfObject) {
        if (pdfObject != null) {
            float[] fArray;
            double[] dArray = pdfObject.getDoubleArray(-2105119560);
            if (dArray != null) {
                this.FontMatrix = dArray;
            }
            if ((fArray = pdfObject.getFloatArray(676429196)) != null) {
                this.FontBBox = fArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(String string, boolean bl) {
        if (bl && PdfJavaGlyphs.fontList == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (bl && PdfJavaGlyphs.fontList == null) {
                    String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = stringArray[i].toLowerCase();
                    }
                    PdfJavaGlyphs.fontList = stringArray;
                }
            }
        }
        this.fontID = string;
        this.renderPage = bl;
    }

    private int handleNoEncoding(int n, PdfObject pdfObject) {
        int n2 = pdfObject.getGeneralType(1232564598);
        if (n2 == 5) {
            this.putFontEncoding(5);
            this.glyphs.defaultFont = "Zapf Dingbats";
            StandardFonts.checkLoaded(5);
            n = 5;
        } else if (n2 == 4) {
            this.putFontEncoding(4);
            n = 4;
        } else {
            this.putFontEncoding(1);
        }
        this.hasEncoding = false;
        return n;
    }

    private void handleFontEncoding(PdfObject pdfObject, PdfObject pdfObject2) {
        int n;
        PdfArrayIterator pdfArrayIterator;
        int n2 = pdfObject.getParameterConstant(1147962727);
        int n3 = this.getFontEncoding(false);
        if (n3 == -1) {
            n3 = n2 == 1217103210 ? 0 : 1;
        }
        if ((pdfArrayIterator = pdfObject2.getMixedArray(1954328750)) != null && pdfArrayIterator.getTokenCount() > 0) {
            int n4;
            this.glyphs.setIsSubsetted(true);
            byte[][] byArray = null;
            if (pdfObject2 != null) {
                byArray = pdfObject2.getByteArray(1954328750);
            }
            if (byArray != null) {
                this.containsHexNumbers = true;
                this.allNumbers = true;
                for (n = 0; n < byArray.length; ++n) {
                    char c;
                    int n5;
                    if (byArray[n] == null || byArray[n][0] != 47) continue;
                    n4 = byArray[n].length;
                    byte[] byArray2 = byArray[n];
                    int n6 = 0;
                    if (n4 == 3 && this.containsHexNumbers) {
                        for (n5 = 1; n5 < 3; ++n5) {
                            c = (char)byArray2[n5];
                            if ((c < '0' || c > '9') && (c < 'A' || c > 'F')) continue;
                            n6 = (char)(n6 + 1);
                        }
                    }
                    if (n6 != 2) {
                        this.containsHexNumbers = false;
                    }
                    if (!this.allNumbers || n4 >= 4) continue;
                    for (n5 = 2; n5 < n4; ++n5) {
                        c = (char)byArray2[n5];
                        if (c >= '0' && c <= '9') continue;
                        this.allNumbers = false;
                        n5 = n4;
                    }
                }
            }
            n = 0;
            while (pdfArrayIterator.hasMoreTokens()) {
                n4 = pdfArrayIterator.getNextValueType();
                if (n4 == 1) {
                    n = pdfArrayIterator.getNextValueAsInteger();
                } else {
                    if (n4 == 2) {
                        if (this.diffCharTable == null) {
                            this.diffCharTable = new int[this.maxCharCount];
                        }
                        this.diffCharTable[n] = pdfArrayIterator.getNextValueAsInteger(false);
                    }
                    this.putMappedChar(n, pdfArrayIterator.getNextValueAsFontChar(n, this.containsHexNumbers, this.allNumbers));
                    ++n;
                }
                if (n != 256) continue;
            }
            this.isHex = pdfArrayIterator.hasHexChars();
            int n7 = pdfArrayIterator.getSpaceChar();
            if (n7 != -1) {
                this.spaceChar = n7;
            }
        }
        int n8 = -1;
        if (pdfObject2 != null) {
            this.hasEncoding = true;
            n = pdfObject2.getGeneralType(1232564598);
            if (n == -1) {
                n = this.getBaseFontName().equals("ZapfDingbats") ? 5 : pdfObject2.getParameterConstant(1537782955);
            }
            n8 = n != -1 ? n : this.handleNoEncoding(n3, pdfObject);
        }
        this.putFontEncoding(n8);
    }

    protected final void putMappedChar(int n, String string) {
        if (this.diffTable == null) {
            this.diffTable = new String[this.maxCharCount];
            this.diffLookup = new HashMap();
        }
        if (!(n > 255 && this.maxCharCount == 256 || this.diffTable[n] != null || string == null || string.startsWith("glyph"))) {
            this.diffTable[n] = string;
            this.diffLookup.put(string, new Integer(n));
        }
    }

    public String getDiffMapping(int n) {
        if (this.diffTable == null) {
            return null;
        }
        return this.diffTable[n];
    }

    public final String getMappedChar(int n, boolean bl) {
        String string = null;
        if (this.diffTable != null) {
            string = this.diffTable[n];
        }
        if (bl && string != null && string.equals(".notdef")) {
            string = " ";
        }
        if (string == null && n < 335) {
            string = StandardFonts.getUnicodeChar(this.getFontEncoding(true), n);
        }
        if (string == null && n > 40 && this.getFontEncoding(true) == 2) {
            string = n == 173 ? "hyphen" : "bullet";
        }
        if (this.isFontEmbedded && string == null) {
            if (this.diffs != null) {
                string = this.diffs[n];
            }
            if (string == null && n < 335) {
                string = StandardFonts.getUnicodeChar(this.embeddedEnc, n);
            }
        }
        return string;
    }

    public final String getEmbeddedChar(int n) {
        String string = null;
        if (this.isFontEmbedded) {
            if (this.diffs != null) {
                string = this.diffs[n];
            }
            if (string == null && n < 256) {
                string = StandardFonts.getUnicodeChar(this.embeddedEnc, n);
            }
        }
        return string;
    }

    private void readUnicode(byte[] byArray) {
        block40: {
            if (byArray == null) {
                return;
            }
            this.unicodeMappings = new String[65536];
            int n = 0;
            int n2 = byArray.length;
            int n3 = 0;
            try {
                while (true) {
                    if (n < n2 && byArray[n] == 9) {
                        ++n;
                        continue;
                    }
                    if (n < n2) {
                        if (n + 4 < n2 && byArray[n] == 101 && byArray[n + 1] == 110 && byArray[n + 2] == 100 && byArray[n + 3] == 98 && byArray[n + 4] == 102) {
                            n3 = 0;
                        } else if (n3 > 0) {
                            int n4;
                            int n5;
                            int n6;
                            int n7 = n3 + 1;
                            int[] nArray = new int[2000];
                            boolean bl = false;
                            for (n6 = 0; n6 < n7; ++n6) {
                                if (!bl) {
                                    while (byArray[n] != 60) {
                                        if (n6 == 2 && n7 == 3 && byArray[n] == 91) {
                                            n3 = 4;
                                            n5 = n;
                                            while (byArray[n5] != 93) {
                                                if (byArray[n5] == 60) {
                                                    ++n7;
                                                }
                                                ++n5;
                                            }
                                            --n7;
                                        }
                                        ++n;
                                    }
                                    ++n;
                                }
                                n5 = 0;
                                n4 = 0;
                                while (byArray[n] != 62) {
                                    if (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32) {
                                        ++n4;
                                    }
                                    ++n;
                                    ++n5;
                                    if (n4 != 5) continue;
                                    n5 = 4;
                                    --n;
                                    ++n7;
                                    bl = true;
                                    break;
                                }
                                int n8 = 0;
                                for (int i = 0; i < n5; ++i) {
                                    int n9;
                                    while ((n9 = byArray[n - 1 - i]) == 10 || n9 == 13 || n9 == 32) {
                                        ++i;
                                    }
                                    if (n9 >= 65 && n9 <= 70) {
                                        n9 -= 55;
                                    } else if (n9 >= 97 && n9 <= 102) {
                                        n9 -= 87;
                                    } else if (n9 >= 48 && n9 <= 57) {
                                        n9 -= 48;
                                    } else {
                                        throw new RuntimeException("Unexpected number " + (char)n9);
                                    }
                                    nArray[n6] = nArray[n6] + n9 * powers[n8];
                                    if (n8 == 3) {
                                        // empty if block
                                    }
                                    ++n8;
                                }
                            }
                            while (byArray[n] == 62 || byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 93) {
                                ++n;
                            }
                            --n;
                            if (n3 == 1) {
                                if (n7 == 2) {
                                    if (nArray[n3] > 0) {
                                        this.unicodeMappings[nArray[0]] = String.valueOf((char)nArray[n3]);
                                    }
                                } else {
                                    char[] cArray = new char[n7 - 1];
                                    for (n5 = 0; n5 < n7 - 1; ++n5) {
                                        cArray[n5] = (char)nArray[n3 + n5];
                                    }
                                    this.unicodeMappings[nArray[0]] = new String(cArray);
                                }
                            } else if (n3 == 4) {
                                ++n;
                                n5 = 2;
                                for (n4 = nArray[0]; n4 < nArray[1] + 1; ++n4) {
                                    n6 = nArray[n5];
                                    ++n5;
                                    if (n6 <= 0) continue;
                                    this.unicodeMappings[n4] = String.valueOf((char)n6);
                                }
                                n3 = 0;
                            } else {
                                for (n5 = nArray[0]; n5 < nArray[1] + 1; ++n5) {
                                    n6 = nArray[n3] + n5 - nArray[0];
                                    if (n6 <= 0) continue;
                                    this.unicodeMappings[n5] = String.valueOf((char)n6);
                                }
                            }
                        }
                        if (byArray[n] == 98 && byArray[n + 1] == 101 && byArray[n + 2] == 103 && byArray[n + 3] == 105 && byArray[n + 4] == 110 && byArray[n + 5] == 98 && byArray[n + 6] == 102 && byArray[n + 7] == 99 && byArray[n + 8] == 104 && byArray[n + 9] == 97 && byArray[n + 10] == 114) {
                            n3 = 1;
                            n += 10;
                        } else if (byArray[n] == 98 && byArray[n + 1] == 101 && byArray[n + 2] == 103 && byArray[n + 3] == 105 && byArray[n + 4] == 110 && byArray[n + 5] == 98 && byArray[n + 6] == 102 && byArray[n + 7] == 114 && byArray[n + 8] == 97 && byArray[n + 9] == 110 && byArray[n + 10] == 103 && byArray[n + 11] == 101) {
                            n3 = 2;
                            n += 11;
                        }
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block40;
                LogWriter.writeLog("Exception setting up text object " + exception);
            }
        }
    }

    public final int getFontType() {
        return this.fontTypes;
    }

    public String getSubstituteFont() {
        return this.substituteFontName;
    }

    public boolean isValidCodeRange(int n) {
        if (this.CMAP == null) {
            return false;
        }
        return this.CMAP[n] != null;
    }

    public float getGlyphWidth(String string, int n, String string2) {
        if (this.fontTypes == 1217103210) {
            return this.glyphs.getTTWidth(string, n, string2, false);
        }
        return 0.0f;
    }

    public void setSubtype(int n) {
        this.fontTypes = n;
    }

    public void setSubstituted(boolean bl) {
        this.isFontSubstituted = bl;
    }

    public PdfJavaGlyphs getGlyphData() {
        this.glyphs.setHasWidths(true);
        return this.glyphs;
    }

    public Font setFont(String string, int n) {
        return this.glyphs.setFont(string, n);
    }

    public boolean is1C() {
        return this.glyphs.is1C();
    }

    public boolean isFontSubsetted() {
        return this.glyphs.isSubsetted;
    }

    public void setValuesForGlyph(int n, String string, String string2, String string3) {
        this.glyphs.setValuesForGlyph(n, string, string2, string3);
    }

    private static String cleanupFontName(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '-') continue;
            if (c == '#' && string.charAt(i + 1) == '2' && (string.charAt(i + 2) == '0' || string.charAt(i + 2) == 'D')) {
                if (string.charAt(i + 2) == 'D') {
                    stringBuffer.append('-');
                }
                i += 2;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public int getItalicAngle() {
        return this.italicAngle;
    }

    public Rectangle getBoundingBox() {
        if (this.BBox == null) {
            float[] fArray = StandardFonts.getFontBounds(this.getFontName());
            this.BBox = fArray == null ? (!this.isFontEmbedded ? new Rectangle(0, 0, 1000, 1000) : new Rectangle((int)this.FontBBox[0], (int)this.FontBBox[1], (int)(this.FontBBox[2] - this.FontBBox[0]), (int)(this.FontBBox[3] - this.FontBBox[1]))) : new Rectangle((int)fArray[0], (int)fArray[1], (int)(fArray[2] - fArray[0]), (int)(fArray[3] - fArray[1]));
        }
        return this.BBox;
    }

    public void setRawFontName(String string) {
        this.rawFontName = string;
    }

    public static String getSpaces(float f, float f2, float f3) {
        String string = "";
        if (f2 > 0.0f) {
            if (f > f2 && (f3 < 1.0f || f > f2 * f3)) {
                while (f >= f2) {
                    string = ' ' + string;
                    f -= f2;
                }
            } else if (f > f2 * f3) {
                string = string + ' ';
            }
        }
        return string;
    }

    public int getDiffChar(int n) {
        if (this.diffCharTable == null) {
            return 0;
        }
        return this.diffCharTable[n];
    }

    public float[] getFontBounds() {
        return this.FontBBox;
    }

    public boolean isFontVertical() {
        return this.isFontVertical;
    }

    public void setCurrentWidth(float f) {
        this.currentWidth = f;
    }

    public float getCurrentWidth() {
        return this.currentWidth;
    }

    public Object getFontID() {
        return this.fontID;
    }

    static {
        PdfFont.setStandardFontMappings();
    }
}

