/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.PdfFilter;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class RunLength
extends BaseFilter
implements PdfFilter {
    public RunLength(PdfObject pdfObject) {
        super(pdfObject);
    }

    public byte[] decode(byte[] byArray) throws Exception {
        int n = byArray.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            byte by;
            int n3 = byArray[i];
            if (n3 < 0) {
                n3 = 256 + n3;
            }
            if (n3 == 128) {
                i = n;
                continue;
            }
            if (n3 > 128) {
                n3 = 257 - n3;
                by = byArray[++i];
                for (n2 = 0; n2 < n3; ++n2) {
                    byteArrayOutputStream.write(by);
                }
                continue;
            }
            ++i;
            ++n3;
            for (n2 = 0; n2 < n3; ++n2) {
                by = byArray[i + n2];
                byteArrayOutputStream.write(by);
            }
            i = i + n3 - 1;
        }
        byteArrayOutputStream.close();
        byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public void decode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, String string, Map map) {
        block11: {
            this.bis = bufferedInputStream;
            this.streamCache = bufferedOutputStream;
            this.cachedObjects = map;
            try {
                int n = bufferedInputStream.available();
                for (int i = 0; i < n; ++i) {
                    int n2;
                    int n3;
                    int n4;
                    int n5 = bufferedInputStream.read();
                    if (n5 >= 128) {
                        n5 -= 256;
                    }
                    if ((n4 = n5) < 0) {
                        n4 = 256 + n4;
                    }
                    if (n4 == 128) {
                        i = n;
                        continue;
                    }
                    if (n4 > 128) {
                        ++i;
                        n4 = 257 - n4;
                        n3 = bufferedInputStream.read();
                        if (n3 >= 128) {
                            n3 -= 256;
                        }
                        for (n2 = 0; n2 < n4; ++n2) {
                            bufferedOutputStream.write(n3);
                        }
                        continue;
                    }
                    ++i;
                    ++n4;
                    for (n2 = 0; n2 < n4; ++n2) {
                        n3 = bufferedInputStream.read();
                        if (n3 >= 128) {
                            n3 -= 256;
                        }
                        bufferedOutputStream.write(n3);
                    }
                    i = i + n4 - 1;
                }
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block11;
                LogWriter.writeLog("IO exception in RunLength " + iOException);
            }
        }
    }
}

