/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.notifications;

import com.google.api.client.googleapis.notifications.NotificationUtils;
import com.google.api.client.googleapis.notifications.UnparsedNotificationCallback;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Objects;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class StoredChannel
implements Serializable {
    public static final String DEFAULT_DATA_STORE_ID = StoredChannel.class.getSimpleName();
    private static final long serialVersionUID = 1L;
    private final Lock lock = new ReentrantLock();
    private final UnparsedNotificationCallback notificationCallback;
    private String clientToken;
    private Long expiration;
    private final String id;
    private String topicId;

    public StoredChannel(UnparsedNotificationCallback notificationCallback) {
        this(notificationCallback, NotificationUtils.randomUuidString());
    }

    public StoredChannel(UnparsedNotificationCallback notificationCallback, String id) {
        this.notificationCallback = (UnparsedNotificationCallback)Preconditions.checkNotNull((Object)notificationCallback);
        this.id = (String)Preconditions.checkNotNull((Object)id);
    }

    public StoredChannel store(DataStoreFactory dataStoreFactory) throws IOException {
        return this.store(StoredChannel.getDefaultDataStore(dataStoreFactory));
    }

    public StoredChannel store(DataStore<StoredChannel> dataStore) throws IOException {
        this.lock.lock();
        try {
            dataStore.set(this.getId(), (Serializable)this);
            StoredChannel storedChannel = this;
            return storedChannel;
        }
        finally {
            this.lock.unlock();
        }
    }

    public UnparsedNotificationCallback getNotificationCallback() {
        this.lock.lock();
        try {
            UnparsedNotificationCallback unparsedNotificationCallback = this.notificationCallback;
            return unparsedNotificationCallback;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getClientToken() {
        this.lock.lock();
        try {
            String string = this.clientToken;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public StoredChannel setClientToken(String clientToken) {
        this.lock.lock();
        try {
            this.clientToken = clientToken;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public Long getExpiration() {
        this.lock.lock();
        try {
            Long l = this.expiration;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public StoredChannel setExpiration(Long expiration) {
        this.lock.lock();
        try {
            this.expiration = expiration;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public String getId() {
        this.lock.lock();
        try {
            String string = this.id;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getTopicId() {
        this.lock.lock();
        try {
            String string = this.topicId;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public StoredChannel setTopicId(String topicId) {
        this.lock.lock();
        try {
            this.topicId = topicId;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public String toString() {
        return Objects.toStringHelper(StoredChannel.class).add("notificationCallback", (Object)this.getNotificationCallback()).add("clientToken", (Object)this.getClientToken()).add("expiration", (Object)this.getExpiration()).add("id", (Object)this.getId()).add("topicId", (Object)this.getTopicId()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StoredChannel)) {
            return false;
        }
        StoredChannel o = (StoredChannel)other;
        return this.getId().equals(o.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static DataStore<StoredChannel> getDefaultDataStore(DataStoreFactory dataStoreFactory) throws IOException {
        return dataStoreFactory.getDataStore(DEFAULT_DATA_STORE_ID);
    }
}

