/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.analysis;

import java.util.ArrayList;
import java.util.List;
import org.yccheok.jstock.analysis.ConnectorEvent;
import org.yccheok.jstock.analysis.ConnectorValueChangeListener;
import org.yccheok.jstock.analysis.Operator;

public class Connector {
    private final Operator operator;
    private Object value;
    private final int index;
    private List<ConnectorValueChangeListener> listeners;

    public Connector() {
        this.operator = null;
        this.value = null;
        this.listeners = new ArrayList<ConnectorValueChangeListener>();
        this.index = -1;
    }

    public Connector(Operator operator, int index) {
        this.operator = operator;
        this.value = null;
        this.listeners = new ArrayList<ConnectorValueChangeListener>();
        this.index = index;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        Object oldValue = this.value;
        this.value = value;
        if (oldValue == null) {
            if (value != null) {
                ConnectorEvent event = new ConnectorEvent(this);
                for (ConnectorValueChangeListener listerner : this.listeners) {
                    listerner.connectorValueChange(event);
                }
            }
            return;
        }
        if (!oldValue.equals(value)) {
            ConnectorEvent event = new ConnectorEvent(this);
            for (ConnectorValueChangeListener listerner : this.listeners) {
                listerner.connectorValueChange(event);
            }
        }
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void addConnectorValueChangeListener(ConnectorValueChangeListener connectorValueChangeLister) {
        if (this.listeners.contains(connectorValueChangeLister)) {
            return;
        }
        this.listeners.add(connectorValueChangeLister);
    }

    public void removeConnectorValueChangeListener(ConnectorValueChangeListener connectorValueChangeLister) {
        this.listeners.remove(connectorValueChangeLister);
    }

    public int getIndex() {
        return this.index;
    }
}

