/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.concurrent.ConcurrentHashMap;

public class Board
implements Comparable<Board> {
    private final String board;
    private static final ConcurrentHashMap<String, Board> map = new ConcurrentHashMap();
    public static final Board Unknown = Board.valueOf("Unknown");
    public static final Board UserDefined = Board.valueOf("UserDefined");

    private Board(String board) {
        assert (board != null);
        this.board = board;
    }

    public static Board valueOf(String board) {
        Board instance;
        if (board == null) {
            throw new IllegalArgumentException("board cannot be null");
        }
        if ((board = board.trim()).isEmpty()) {
            throw new IllegalArgumentException("board cannot be empty");
        }
        Board result = map.get(board);
        if (result == null && (result = map.putIfAbsent(board, instance = new Board(board))) == null) {
            result = instance;
        }
        assert (result != null);
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.board.hashCode();
        return result;
    }

    @Override
    public int compareTo(Board o) {
        return this.board.compareTo(o.board);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Board)) {
            return false;
        }
        return this.board.equals(((Board)o).board);
    }

    public String toString() {
        return this.board;
    }

    public String name() {
        return this.board;
    }
}

