/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.iex.symbols.SymbolsResponse;
import org.yccheok.jstock.gui.Utils;

public enum IEXStockInfoSQLiteOpenHelper {
    INSTANCE;

    private Connection conn = null;
    private static final String COLUMN_SYMBOL = "symbol";
    private static final String COLUMN_NAME = "name";
    private static final String COLUMN_DATE = "date";
    private static final String COLUMN_IS_ENABLED = "is_enabled";
    private static final String COLUMN_TYPE = "type";
    private static final String COLUMN_IEX_ID = "iex_id";
    private static final String UNIQUE_CONSTRAINT = "unique (symbol) on conflict ignore";
    private static final String TAG = "IEXStockInfoTable";
    private static final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IEXStockInfoSQLiteOpenHelper() {
        try {
            String url = "jdbc:sqlite:" + Utils.getUserDataDirectory() + "stock_info.db";
            this.conn = DriverManager.getConnection(url);
        }
        catch (SQLException sQLException) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    private String getTableName() {
        return "iex_stock_info";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableEmpty() {
        if (this.conn == null) {
            return true;
        }
        String sql = "select exists(select 1 from " + this.getTableName() + " limit 1)";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = this.conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                boolean bl = rs.getInt(1) == 0;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            log.error(null, (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableExists() {
        if (this.conn == null) {
            return false;
        }
        String sql = "select tbl_name from sqlite_master where tbl_name = ? limit 1";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = this.conn.prepareStatement("select tbl_name from sqlite_master where tbl_name = ? limit 1");
            pstmt.setString(1, this.getTableName());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            log.error(null, (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(List<SymbolsResponse> symbolsResponses) {
        if (this.conn == null) {
            return false;
        }
        String tableName = this.getTableName();
        Statement pstmt = null;
        try {
            this.conn.setAutoCommit(false);
            Statement stmt = this.conn.createStatement();
            stmt.execute("DROP TABLE IF EXISTS " + tableName);
            stmt.execute("create table if not exists " + tableName + "(" + COLUMN_SYMBOL + " text not null collate nocase, " + COLUMN_NAME + " text not null collate nocase, " + COLUMN_DATE + " text, " + COLUMN_IS_ENABLED + " integer not null, " + COLUMN_TYPE + " text, " + COLUMN_IEX_ID + " text, " + UNIQUE_CONSTRAINT + ");");
            stmt.execute("create index " + tableName + "_" + COLUMN_SYMBOL + "_idx on " + tableName + "(" + COLUMN_SYMBOL + " collate nocase);");
            stmt.execute("create index " + tableName + "_" + COLUMN_NAME + "_idx on " + tableName + "(" + COLUMN_NAME + " collate nocase);");
            HashSet<String> upperCaseSymbols = new HashSet<String>();
            for (SymbolsResponse symbolsResponse : symbolsResponses) {
                String symbol = symbolsResponse.getSymbol();
                String SYMBOL = symbol.toUpperCase();
                if (upperCaseSymbols.contains(SYMBOL)) continue;
                upperCaseSymbols.add(SYMBOL);
                pstmt = this.conn.prepareStatement("INSERT INTO " + tableName + "(" + COLUMN_SYMBOL + ", " + COLUMN_NAME + ", " + COLUMN_DATE + ", " + COLUMN_IS_ENABLED + ", " + COLUMN_TYPE + ", " + COLUMN_IEX_ID + ") VALUES(?, ?, ?, ?, ?, ?);");
                pstmt.setString(1, symbol);
                pstmt.setString(2, symbolsResponse.getName());
                pstmt.setString(3, symbolsResponse.getDate());
                pstmt.setByte(4, symbolsResponse.isIsEnabled() ? (byte)1 : 0);
                pstmt.setString(5, symbolsResponse.getType());
                pstmt.setString(6, symbolsResponse.getIexId());
                long result = pstmt.executeUpdate();
                if (result != -1L) continue;
                boolean bl = false;
                return bl;
            }
            this.conn.commit();
        }
        catch (SQLException e) {
            log.error(null, (Throwable)e);
            try {
                if (this.conn != null) {
                    this.conn.rollback();
                }
            }
            catch (SQLException e2) {
                log.error(null, (Throwable)e2);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean find(String code, boolean is_enabled) {
        if (this.conn == null) {
            return null;
        }
        String sql = "select exists (select * from " + this.getTableName() + " where symbol = ? and is_enabled = ? limit 1)";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = this.conn.prepareStatement(sql);
            pstmt.setString(1, code);
            pstmt.setByte(2, is_enabled ? (byte)1 : 0);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                Boolean bl = rs.getInt(1) == 1;
                return bl;
            }
        }
        catch (SQLException e) {
            log.error(null, (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean find(String code) {
        if (this.conn == null) {
            return null;
        }
        String sql = "select exists (select * from " + this.getTableName() + " where symbol = ? limit 1)";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = this.conn.prepareStatement(sql);
            pstmt.setString(1, code);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                Boolean bl = rs.getInt(1) == 1;
                return bl;
            }
        }
        catch (SQLException e) {
            log.error(null, (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StockInfo> findViaSymbol(String symbolWithPercentageSign, int limit) {
        if (this.conn == null) {
            return Collections.emptyList();
        }
        String sql = "select symbol, name from " + this.getTableName() + " where symbol like ? order by symbol limit " + limit;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = this.conn.prepareStatement(sql);
            pstmt.setString(1, symbolWithPercentageSign);
            rs = pstmt.executeQuery();
            ArrayList<StockInfo> stockInfos = new ArrayList<StockInfo>();
            while (rs.next()) {
                String codeStr = rs.getString(1);
                String symbolStr = rs.getString(2);
                Code code = Code.newInstance(codeStr);
                Symbol symbol = Symbol.newInstance(symbolStr);
                StockInfo stockInfo = StockInfo.newInstance(code, symbol);
                stockInfos.add(stockInfo);
            }
            ArrayList<StockInfo> arrayList = stockInfos;
            return arrayList;
        }
        catch (SQLException e) {
            log.error(null, (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StockInfo> findViaName(String nameWithPercentageSign, int limit) {
        if (this.conn == null) {
            return Collections.emptyList();
        }
        String sql = "select symbol, name from " + this.getTableName() + " where name like ? order by name limit " + limit;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = this.conn.prepareStatement(sql);
            pstmt.setString(1, nameWithPercentageSign);
            rs = pstmt.executeQuery();
            ArrayList<StockInfo> stockInfos = new ArrayList<StockInfo>();
            while (rs.next()) {
                String codeStr = rs.getString(1);
                String symbolStr = rs.getString(2);
                Code code = Code.newInstance(codeStr);
                Symbol symbol = Symbol.newInstance(symbolStr);
                StockInfo stockInfo = StockInfo.newInstance(code, symbol);
                stockInfos.add(stockInfo);
            }
            ArrayList<StockInfo> arrayList = stockInfos;
            return arrayList;
        }
        catch (SQLException e) {
            log.error(null, (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                log.error(null, (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    static {
        log = LogFactory.getLog(IEXStockInfoSQLiteOpenHelper.class);
    }
}

