/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Board;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Industry;
import org.yccheok.jstock.engine.Intraday;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.file.Statement;
import org.yccheok.jstock.file.Statements;

public class StatementsStockHistoryServer
implements StockHistoryServer {
    private final Map<Long, Stock> historyDatabase = new HashMap<Long, Stock>();
    private final List<Long> timestamps = new ArrayList<Long>();
    private final TimeZone timeZone;
    private final Intraday intraday;
    private static final String TAG = StatementsStockHistoryServer.class.getSimpleName();
    private static final Log log = LogFactory.getLog(StatementsStockHistoryServer.class);

    private StatementsStockHistoryServer(Statements statements) throws ParseException {
        String close;
        assert (statements.getType() == Statement.Type.StockHistory);
        Map<String, String> metadatas = statements.getMetadatas();
        double previousClosePrice = Double.MAX_VALUE;
        int ei = statements.size();
        for (int i = 0; i < ei; ++i) {
            Statement statement = statements.get(i);
            assert (statement.getType() == Statement.Type.StockHistory);
            long timestamp = Long.parseLong(statement.getAtom(0).getValue().toString());
            double openPrice = Double.parseDouble(statement.getAtom(1).getValue().toString());
            double highPrice = Double.parseDouble(statement.getAtom(2).getValue().toString());
            double lowPrice = Double.parseDouble(statement.getAtom(3).getValue().toString());
            double closePrice = Double.parseDouble(statement.getAtom(4).getValue().toString());
            double prevPrice = previousClosePrice == Double.MAX_VALUE ? 0.0 : previousClosePrice;
            long volume = Long.parseLong(statement.getAtom(5).getValue().toString());
            double changePrice = previousClosePrice == Double.MAX_VALUE ? 0.0 : closePrice - previousClosePrice;
            double changePricePercentage = previousClosePrice == Double.MAX_VALUE || previousClosePrice == 0.0 ? 0.0 : changePrice / previousClosePrice * 100.0;
            Code code = Code.newInstance(metadatas.get("code"));
            Symbol symbol = Symbol.newInstance(metadatas.get("symbol"));
            String name = metadatas.get("name");
            Board board = Board.valueOf(metadatas.get("board"));
            Industry industry = Industry.valueOf(metadatas.get("industry"));
            Stock stock = new Stock(code, symbol, name, null, board, industry, prevPrice, openPrice, closePrice, highPrice, lowPrice, volume, changePrice, changePricePercentage, 0, 0.0, 0, 0.0, 0, timestamp);
            this.historyDatabase.put(timestamp, stock);
            this.timestamps.add(timestamp);
            previousClosePrice = closePrice;
        }
        String timeZoneId = metadatas.get("timeZone");
        this.timeZone = timeZoneId != null && !timeZoneId.isEmpty() ? TimeZone.getTimeZone(timeZoneId) : null;
        long openTs = 0L;
        long closeTs = 0L;
        String open = metadatas.get("intradayOpen");
        if (open != null && !open.isEmpty()) {
            openTs = Long.parseLong(open);
        }
        if ((close = metadatas.get("intradayClose")) != null && !close.isEmpty()) {
            closeTs = Long.parseLong(close);
        }
        this.intraday = openTs > 0L && closeTs > 0L ? new Intraday(openTs, closeTs) : null;
    }

    public static StatementsStockHistoryServer newInstance(Statements statements) {
        assert (statements != null);
        if (statements.getType() != Statement.Type.StockHistory) {
            return null;
        }
        try {
            return new StatementsStockHistoryServer(statements);
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
    }

    @Override
    public Stock getStock(long timestamp) {
        return this.historyDatabase.get(timestamp);
    }

    @Override
    public long getTimestamp(int index) {
        return this.timestamps.get(index);
    }

    @Override
    public int size() {
        return this.timestamps.size();
    }

    @Override
    public long getSharesIssued() {
        return 0L;
    }

    @Override
    public long getMarketCapital() {
        return 0L;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Intraday getIntraday() {
        return this.intraday;
    }
}

