/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import org.yccheok.jstock.engine.Board;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Industry;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.currency.Currency;

public class Stock {
    public final Code code;
    public final Symbol symbol;
    private final String name;
    private final Currency currency;
    private final Board board;
    private final Industry industry;
    private final double prevPrice;
    private final double openPrice;
    private final double lastPrice;
    private final double highPrice;
    private final double lowPrice;
    private final long volume;
    private final double changePrice;
    private final double changePricePercentage;
    private final int lastVolume;
    private final double buyPrice;
    private final int buyQuantity;
    private final double sellPrice;
    private final int sellQuantity;
    private final long timestamp;

    public static Builder builder(Code code, Symbol symbol) {
        return new Builder(code, symbol);
    }

    public static Builder builder(Stock stock) {
        return new Builder(stock);
    }

    private Stock(Builder builder) {
        this(builder.code, builder.symbol, builder.name, builder.currency, builder.board, builder.industry, builder.prevPrice, builder.openPrice, builder.lastPrice, builder.highPrice, builder.lowPrice, builder.volume, builder.changePrice, builder.changePricePercentage, builder.lastVolume, builder.buyPrice, builder.buyQuantity, builder.sellPrice, builder.sellQuantity, builder.timestamp);
    }

    public Stock(Code code, Symbol symbol, String name, Currency currency, Board board, Industry industry, double prevPrice, double openPrice, double lastPrice, double highPrice, double lowPrice, long volume, double changePrice, double changePricePercentage, int lastVolume, double buyPrice, int buyQuantity, double sellPrice, int sellQuantity, long timestamp) {
        this.code = code;
        this.symbol = symbol;
        this.name = name;
        this.currency = currency;
        this.board = board;
        this.industry = industry;
        this.prevPrice = prevPrice;
        this.openPrice = openPrice;
        this.lastPrice = lastPrice;
        this.highPrice = highPrice;
        this.lowPrice = lowPrice;
        this.volume = volume;
        this.changePrice = changePrice;
        this.changePricePercentage = changePricePercentage;
        this.lastVolume = lastVolume;
        this.buyPrice = buyPrice;
        this.buyQuantity = buyQuantity;
        this.sellPrice = sellPrice;
        this.sellQuantity = sellQuantity;
        this.timestamp = timestamp;
    }

    public Stock(Stock stock) {
        this.code = stock.code;
        this.symbol = stock.symbol;
        this.name = stock.name;
        this.currency = stock.currency;
        this.board = stock.board;
        this.industry = stock.industry;
        this.prevPrice = stock.prevPrice;
        this.openPrice = stock.openPrice;
        this.lastPrice = stock.lastPrice;
        this.highPrice = stock.highPrice;
        this.lowPrice = stock.lowPrice;
        this.volume = stock.volume;
        this.changePrice = stock.changePrice;
        this.changePricePercentage = stock.changePricePercentage;
        this.lastVolume = stock.lastVolume;
        this.buyPrice = stock.buyPrice;
        this.buyQuantity = stock.buyQuantity;
        this.sellPrice = stock.sellPrice;
        this.sellQuantity = stock.sellQuantity;
        this.timestamp = stock.timestamp;
    }

    public String getName() {
        return this.name;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Board getBoard() {
        return this.board;
    }

    public Industry getIndustry() {
        return this.industry;
    }

    public double getPrevPrice() {
        return this.prevPrice;
    }

    public double getOpenPrice() {
        return this.openPrice;
    }

    public double getLastPrice() {
        return this.lastPrice;
    }

    public double getHighPrice() {
        return this.highPrice;
    }

    public double getLowPrice() {
        return this.lowPrice;
    }

    public long getVolume() {
        return this.volume;
    }

    public double getChangePrice() {
        return this.changePrice;
    }

    public double getChangePricePercentage() {
        return this.changePricePercentage;
    }

    public int getLastVolume() {
        return this.lastVolume;
    }

    public double getBuyPrice() {
        return this.buyPrice;
    }

    public int getBuyQuantity() {
        return this.buyQuantity;
    }

    public double getSellPrice() {
        return this.sellPrice;
    }

    public int getSellQuantity() {
        return this.sellQuantity;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Stock deriveStock(String name) {
        return new Stock(this.code, this.symbol, name, this.currency, this.board, this.industry, this.prevPrice, this.openPrice, this.lastPrice, this.highPrice, this.lowPrice, this.volume, this.changePrice, this.changePricePercentage, this.lastVolume, this.buyPrice, this.buyQuantity, this.sellPrice, this.sellQuantity, this.timestamp);
    }

    public Stock deriveStock(Code code) {
        return new Stock(code, this.symbol, this.name, this.currency, this.board, this.industry, this.prevPrice, this.openPrice, this.lastPrice, this.highPrice, this.lowPrice, this.volume, this.changePrice, this.changePricePercentage, this.lastVolume, this.buyPrice, this.buyQuantity, this.sellPrice, this.sellQuantity, this.timestamp);
    }

    public Stock deriveStock(Symbol symbol) {
        return new Stock(this.code, symbol, this.name, this.currency, this.board, this.industry, this.prevPrice, this.openPrice, this.lastPrice, this.highPrice, this.lowPrice, this.volume, this.changePrice, this.changePricePercentage, this.lastVolume, this.buyPrice, this.buyQuantity, this.sellPrice, this.sellQuantity, this.timestamp);
    }

    public String toString() {
        return this.symbol.toString();
    }

    public static class Builder {
        private final Code code;
        private final Symbol symbol;
        private String name = "";
        private Currency currency = null;
        private Board board = Board.Unknown;
        private Industry industry = Industry.Unknown;
        private double prevPrice = 0.0;
        private double openPrice = 0.0;
        private double lastPrice = 0.0;
        private double highPrice = 0.0;
        private double lowPrice = 0.0;
        private long volume = 0L;
        private double changePrice = 0.0;
        private double changePricePercentage = 0.0;
        private int lastVolume = 0;
        private double buyPrice = 0.0;
        private int buyQuantity = 0;
        private double sellPrice = 0.0;
        private int sellQuantity = 0;
        private long timestamp = 0L;

        private Builder(Code code, Symbol symbol) {
            this.code = code;
            this.symbol = symbol;
        }

        private Builder(Stock stock) {
            this.code = stock.code;
            this.symbol = stock.symbol;
            this.name = stock.name;
            this.currency = stock.currency;
            this.board = stock.board;
            this.industry = stock.industry;
            this.prevPrice = stock.prevPrice;
            this.openPrice = stock.openPrice;
            this.lastPrice = stock.lastPrice;
            this.highPrice = stock.highPrice;
            this.lowPrice = stock.lowPrice;
            this.volume = stock.volume;
            this.changePrice = stock.changePrice;
            this.changePricePercentage = stock.changePricePercentage;
            this.lastVolume = stock.lastVolume;
            this.buyPrice = stock.buyPrice;
            this.buyQuantity = stock.buyQuantity;
            this.sellPrice = stock.sellPrice;
            this.sellQuantity = stock.sellQuantity;
            this.timestamp = stock.timestamp;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public Builder board(Board board) {
            this.board = board;
            return this;
        }

        public Builder industry(Industry industry) {
            this.industry = industry;
            return this;
        }

        public Builder prevPrice(double prevPrice) {
            this.prevPrice = prevPrice;
            return this;
        }

        public Builder openPrice(double openPrice) {
            this.openPrice = openPrice;
            return this;
        }

        public Builder lastPrice(double lastPrice) {
            this.lastPrice = lastPrice;
            return this;
        }

        public Builder highPrice(double highPrice) {
            this.highPrice = highPrice;
            return this;
        }

        public Builder lowPrice(double lowPrice) {
            this.lowPrice = lowPrice;
            return this;
        }

        public Builder volume(long volume) {
            this.volume = volume;
            return this;
        }

        public Builder changePrice(double changePrice) {
            this.changePrice = changePrice;
            return this;
        }

        public Builder changePricePercentage(double changePricePercentage) {
            this.changePricePercentage = changePricePercentage;
            return this;
        }

        public Builder lastVolume(int lastVolume) {
            this.lastVolume = lastVolume;
            return this;
        }

        public Builder buyPrice(double buyPrice) {
            this.buyPrice = buyPrice;
            return this;
        }

        public Builder buyQuantity(int buyQuantity) {
            this.buyQuantity = buyQuantity;
            return this;
        }

        public Builder sellPrice(double sellPrice) {
            this.sellPrice = sellPrice;
            return this;
        }

        public Builder sellQuantity(int sellQuantity) {
            this.sellQuantity = sellQuantity;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Stock build() {
            return new Stock(this);
        }
    }
}

