/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine.currency;

import java.util.concurrent.ConcurrentHashMap;

public class Currency
implements Comparable<Currency> {
    public static final String GBX = "GBX";
    public static final String ZAC = "ZAC";
    public static final String ILA = "ILA";
    public static final String GBP = "GBP";
    public static final String ZAR = "ZAR";
    public static final String ILS = "ILS";
    private final String currency;
    private static final ConcurrentHashMap<String, Currency> map = new ConcurrentHashMap();

    private Currency(String currency) {
        assert (currency != null);
        this.currency = currency;
    }

    public static Currency valueOfWithVerification(String currency) {
        if (currency.equals(GBX) || currency.equals(ZAC) || currency.equals(ILA)) {
            return Currency.valueOf(currency);
        }
        java.util.Currency c = java.util.Currency.getInstance(currency);
        assert (c != null);
        return Currency.valueOf(currency);
    }

    public static Currency valueOf(String currency) {
        Currency instance;
        if (currency == null) {
            throw new IllegalArgumentException("currency cannot be null");
        }
        if ((currency = currency.trim()).isEmpty()) {
            throw new IllegalArgumentException("currency cannot be empty");
        }
        Currency result = map.get(currency);
        if (result == null && (result = map.putIfAbsent(currency, instance = new Currency(currency))) == null) {
            result = instance;
        }
        assert (result != null);
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.currency.hashCode();
        return result;
    }

    @Override
    public int compareTo(Currency o) {
        return this.currency.compareTo(o.currency);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Currency)) {
            return false;
        }
        return this.currency.equals(((Currency)o).currency);
    }

    public String toString() {
        return this.currency;
    }

    public String name() {
        return this.currency;
    }

    public boolean isGBX() {
        return this.currency.equals(GBX);
    }

    public boolean isZAC() {
        return this.currency.equals(ZAC);
    }

    public boolean isILA() {
        return this.currency.equals(ILA);
    }
}

