/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.AjaxGoogleSearchEngineMonitor;
import org.yccheok.jstock.engine.AjaxStockInfoSearchEngine;
import org.yccheok.jstock.engine.AjaxYahooSearchEngineMonitor;
import org.yccheok.jstock.engine.DispType;
import org.yccheok.jstock.engine.MatchSetType;
import org.yccheok.jstock.engine.MatchType;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.ResultSetType;
import org.yccheok.jstock.engine.ResultType;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.Subject;
import org.yccheok.jstock.gui.DispTypeCellRenderer;
import org.yccheok.jstock.gui.JComboBoxPopupAdjustable;
import org.yccheok.jstock.gui.SortedComboBoxModel;
import org.yccheok.jstock.gui.Utils;

public class AjaxAutoCompleteJComboBox
extends JComboBox
implements JComboBoxPopupAdjustable {
    private final SubjectEx<AjaxAutoCompleteJComboBox, DispType> dispSubject = new SubjectEx();
    private final SubjectEx<AjaxAutoCompleteJComboBox, Boolean> busySubject = new SubjectEx();
    private final AjaxYahooSearchEngineMonitor ajaxYahooSearchEngineMonitor = new AjaxYahooSearchEngineMonitor();
    private final AjaxGoogleSearchEngineMonitor ajaxGoogleSearchEngineMonitor = new AjaxGoogleSearchEngineMonitor();
    private final AjaxStockInfoSearchEngine ajaxStockInfoSearchEngine = new AjaxStockInfoSearchEngine();
    private final MyJComboBoxEditor jComboBoxEditor;
    private final KeyAdapter keyAdapter;
    private static final Log log = LogFactory.getLog(AjaxAutoCompleteJComboBox.class);
    private int popupWidth = 0;
    private boolean layingOut = false;
    private volatile boolean canRemoveAllItems = false;
    private final Set<String> codes = new HashSet<String>();

    public void attachDispObserver(Observer<AjaxAutoCompleteJComboBox, DispType> observer) {
        this.dispSubject.attach(observer);
    }

    public void attachBusyObserver(Observer<AjaxAutoCompleteJComboBox, Boolean> observer) {
        this.busySubject.attach(observer);
    }

    public void dettachAll() {
        this.dispSubject.dettachAll();
        this.busySubject.dettachAll();
    }

    public AjaxAutoCompleteJComboBox() {
        this.setModel(new SortedComboBoxModel());
        this.setEditable(true);
        this.keyAdapter = this.getEditorComponentKeyAdapter();
        this.jComboBoxEditor = new MyJComboBoxEditor();
        this.setEditor(this.jComboBoxEditor);
        this.getEditor().getEditorComponent().addKeyListener(this.keyAdapter);
        Component component = this.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().addDocumentListener(this.getDocumentListener());
        } else {
            log.error((Object)"Unable to attach DocumentListener to AjaxAutoCompleteJComboBox.");
        }
        this.setRenderer(new DispTypeCellRenderer());
        this.ajaxYahooSearchEngineMonitor.attach(this.getYahooMonitorObserver());
        this.ajaxGoogleSearchEngineMonitor.attach(this.getGoogleMonitorObserver());
        this.addActionListener(this.getActionListener());
        this.addPopupMenuListener(this.getPopupMenuListener());
        this.adjustScrollBar();
    }

    private ActionListener getActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((e.getModifiers() & 0x10) == 16) {
                    Object object = AjaxAutoCompleteJComboBox.this.getEditor().getItem();
                    if (object instanceof DispType) {
                        DispType lastEnteredResult = (DispType)object;
                        AjaxAutoCompleteJComboBox.this.dispSubject.notify(AjaxAutoCompleteJComboBox.this, lastEnteredResult);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AjaxAutoCompleteJComboBox.this.getEditor().setItem(null);
                            AjaxAutoCompleteJComboBox.this.hidePopup();
                            AjaxAutoCompleteJComboBox.this.removeAllItems();
                        }
                    });
                    return;
                }
            }
        };
    }

    private PopupMenuListener getPopupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Utils.adjustPopupWidth(AjaxAutoCompleteJComboBox.this);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                AjaxAutoCompleteJComboBox.this.setPopupWidth(-1);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                AjaxAutoCompleteJComboBox.this.setPopupWidth(-1);
            }
        };
    }

    private DocumentListener getDocumentListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    String string = e.getDocument().getText(0, e.getDocument().getLength()).trim();
                    this._handle(string);
                }
                catch (BadLocationException ex) {
                    log.error(null, (Throwable)ex);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    String string = e.getDocument().getText(0, e.getDocument().getLength()).trim();
                    this._handle(string);
                }
                catch (BadLocationException ex) {
                    log.error(null, (Throwable)ex);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    String string = e.getDocument().getText(0, e.getDocument().getLength()).trim();
                    this._handle(string);
                }
                catch (BadLocationException ex) {
                    log.error(null, (Throwable)ex);
                }
            }

            private void _handle(String string) {
                AjaxAutoCompleteJComboBox.this.busySubject.notify(AjaxAutoCompleteJComboBox.this, false);
                if (AjaxAutoCompleteJComboBox.this.getSelectedItem() != null && AjaxAutoCompleteJComboBox.this.getSelectedItem().toString().equals(string)) {
                    return;
                }
                if (string.isEmpty()) {
                    return;
                }
                AjaxAutoCompleteJComboBox.this.busySubject.notify(AjaxAutoCompleteJComboBox.this, true);
                AjaxAutoCompleteJComboBox.this.canRemoveAllItems = true;
                AjaxAutoCompleteJComboBox.this.ajaxYahooSearchEngineMonitor.clearAndPut(string);
                AjaxAutoCompleteJComboBox.this.ajaxGoogleSearchEngineMonitor.clearAndPut(string);
            }
        };
    }

    private KeyAdapter getEditorComponentKeyAdapter() {
        return new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    AjaxAutoCompleteJComboBox.this.busySubject.notify(AjaxAutoCompleteJComboBox.this, false);
                    DispType lastEnteredDispType = null;
                    if (AjaxAutoCompleteJComboBox.this.getItemCount() > 0) {
                        int index = AjaxAutoCompleteJComboBox.this.getSelectedIndex();
                        if (index == -1) {
                            Object object = AjaxAutoCompleteJComboBox.this.getItemAt(0);
                            if (object instanceof DispType) {
                                lastEnteredDispType = (DispType)object;
                            }
                        } else {
                            Object object = AjaxAutoCompleteJComboBox.this.getItemAt(index);
                            if (object instanceof DispType) {
                                lastEnteredDispType = (DispType)object;
                            }
                        }
                    } else {
                        String string;
                        Object object = AjaxAutoCompleteJComboBox.this.getEditor().getItem();
                        if (object instanceof String && (string = ((String)object).trim().toUpperCase()).length() > 0) {
                            lastEnteredDispType = new ResultType(string, string);
                        }
                    }
                    AjaxAutoCompleteJComboBox.this.removeAllItems();
                    if (lastEnteredDispType != null) {
                        AjaxAutoCompleteJComboBox.this.dispSubject.notify(AjaxAutoCompleteJComboBox.this, lastEnteredDispType);
                    }
                    return;
                }
                Object object = AjaxAutoCompleteJComboBox.this.getEditor().getItem();
                if (object == null || object.toString().length() <= 0) {
                    AjaxAutoCompleteJComboBox.this.hidePopup();
                    AjaxAutoCompleteJComboBox.this.removeAllItems();
                }
            }
        };
    }

    private Observer<AjaxGoogleSearchEngineMonitor, MatchSetType> getGoogleMonitorObserver() {
        return new Observer<AjaxGoogleSearchEngineMonitor, MatchSetType>(){

            @Override
            public void update(final AjaxGoogleSearchEngineMonitor subject, MatchSetType arg) {
                StockInfo stockInfo;
                if (arg.Match.isEmpty() && (stockInfo = AjaxAutoCompleteJComboBox.this.ajaxStockInfoSearchEngine.search(arg.Query)) != null) {
                    MatchSetType matchSetType;
                    MatchType matchType = new MatchType(stockInfo.code.toString().toUpperCase(), stockInfo.symbol.toString(), null, null);
                    ArrayList<MatchType> matchTypes = new ArrayList<MatchType>();
                    matchTypes.add(matchType);
                    arg = matchSetType = MatchSetType.newInstance(arg.Query, matchTypes);
                }
                final MatchSetType _arg = arg;
                if (SwingUtilities.isEventDispatchThread()) {
                    this._update(subject, _arg);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this._update(subject, _arg);
                        }
                    });
                }
            }

            public void _update(AjaxGoogleSearchEngineMonitor subject, MatchSetType arg) {
                String string = AjaxAutoCompleteJComboBox.this.getEditor().getItem().toString().trim();
                if (string.isEmpty() || !string.equalsIgnoreCase(arg.Query)) {
                    return;
                }
                AjaxAutoCompleteJComboBox.this.busySubject.notify(AjaxAutoCompleteJComboBox.this, false);
                AjaxAutoCompleteJComboBox.this.jComboBoxEditor.setReadOnly(true);
                boolean isPopupHide = false;
                if (AjaxAutoCompleteJComboBox.this.canRemoveAllItems) {
                    AjaxAutoCompleteJComboBox.this.canRemoveAllItems = false;
                    isPopupHide = true;
                    AjaxAutoCompleteJComboBox.this.hidePopup();
                    AjaxAutoCompleteJComboBox.this.removeAllItems();
                    AjaxAutoCompleteJComboBox.this.codes.clear();
                }
                for (MatchType match : arg.Match) {
                    if (AjaxAutoCompleteJComboBox.this.codes.contains(match.getCode().toString())) continue;
                    if (!isPopupHide) {
                        isPopupHide = true;
                        AjaxAutoCompleteJComboBox.this.hidePopup();
                    }
                    AjaxAutoCompleteJComboBox.this.codes.add(match.getCode().toString());
                    AjaxAutoCompleteJComboBox.this.addItem(match);
                }
                if (isPopupHide && AjaxAutoCompleteJComboBox.this.getItemCount() > 0) {
                    AjaxAutoCompleteJComboBox.this.showPopup();
                }
                AjaxAutoCompleteJComboBox.this.jComboBoxEditor.setReadOnly(false);
            }
        };
    }

    private Observer<AjaxYahooSearchEngineMonitor, ResultSetType> getYahooMonitorObserver() {
        return new Observer<AjaxYahooSearchEngineMonitor, ResultSetType>(){

            @Override
            public void update(final AjaxYahooSearchEngineMonitor subject, ResultSetType arg) {
                StockInfo stockInfo;
                if (arg.Result.isEmpty() && (stockInfo = AjaxAutoCompleteJComboBox.this.ajaxStockInfoSearchEngine.search(arg.Query)) != null) {
                    ResultType resultType = new ResultType(stockInfo.code.toString().toUpperCase(), stockInfo.symbol.toString());
                    ArrayList<ResultType> resultTypes = new ArrayList<ResultType>();
                    resultTypes.add(resultType);
                    arg = ResultSetType.newInstance(arg.Query, resultTypes);
                }
                final ResultSetType _arg = arg;
                if (SwingUtilities.isEventDispatchThread()) {
                    this._update(subject, _arg);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this._update(subject, _arg);
                        }
                    });
                }
            }

            public void _update(AjaxYahooSearchEngineMonitor subject, ResultSetType arg) {
                String string = AjaxAutoCompleteJComboBox.this.getEditor().getItem().toString().trim();
                if (string.isEmpty() || !string.equalsIgnoreCase(arg.Query)) {
                    return;
                }
                AjaxAutoCompleteJComboBox.this.busySubject.notify(AjaxAutoCompleteJComboBox.this, false);
                AjaxAutoCompleteJComboBox.this.jComboBoxEditor.setReadOnly(true);
                boolean isPopupHide = false;
                if (AjaxAutoCompleteJComboBox.this.canRemoveAllItems) {
                    AjaxAutoCompleteJComboBox.this.canRemoveAllItems = false;
                    isPopupHide = true;
                    AjaxAutoCompleteJComboBox.this.hidePopup();
                    AjaxAutoCompleteJComboBox.this.removeAllItems();
                    AjaxAutoCompleteJComboBox.this.codes.clear();
                }
                boolean shouldShowPopup = false;
                for (ResultType result : arg.Result) {
                    if (AjaxAutoCompleteJComboBox.this.codes.contains(result.symbol)) continue;
                    if (!isPopupHide) {
                        isPopupHide = true;
                        AjaxAutoCompleteJComboBox.this.hidePopup();
                    }
                    AjaxAutoCompleteJComboBox.this.codes.add(result.symbol);
                    AjaxAutoCompleteJComboBox.this.addItem(result);
                }
                if (isPopupHide && AjaxAutoCompleteJComboBox.this.getItemCount() > 0) {
                    AjaxAutoCompleteJComboBox.this.showPopup();
                }
                AjaxAutoCompleteJComboBox.this.jComboBoxEditor.setReadOnly(false);
            }
        };
    }

    private void adjustScrollBar() {
        int max_search = 8;
        Container popup = null;
        int count = this.getUI().getAccessibleChildrenCount(this);
        for (int i = 0; i < count && i < 8; ++i) {
            Accessible o = this.getUI().getAccessibleChild(this, i);
            if (!(o instanceof JPopupMenu)) continue;
            popup = (JPopupMenu)o;
            break;
        }
        if (popup == null) {
            return;
        }
        JScrollPane scrollPane = null;
        int count2 = popup.getComponentCount();
        for (int i = 0; i < count2 && i < 8; ++i) {
            Component c = popup.getComponent(i);
            if (!(c instanceof JScrollPane)) continue;
            scrollPane = (JScrollPane)c;
            break;
        }
        if (scrollPane == null) {
            return;
        }
        scrollPane.setHorizontalScrollBar(new JScrollBar(0));
        scrollPane.setHorizontalScrollBarPolicy(30);
    }

    public void stop() {
        this.ajaxYahooSearchEngineMonitor.stop();
        this.ajaxGoogleSearchEngineMonitor.stop();
    }

    @Override
    public void setPopupWidth(int popupWidth) {
        this.popupWidth = popupWidth;
    }

    @Override
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut && this.popupWidth != 0 && dim.width < this.popupWidth) {
            dim.width = this.popupWidth;
        }
        return dim;
    }

    private class MyJComboBoxEditor
    extends BasicComboBoxEditor {
        private boolean readonly = false;

        private MyJComboBoxEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            MyTextField _editor = new MyTextField("");
            if (UIManager.getLookAndFeel().getClass().getName().equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
                Component component = new MetalComboBoxEditor().getEditorComponent();
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    _editor.setBorder(jComponent.getBorder());
                }
            } else {
                _editor.setBorder(null);
            }
            return _editor;
        }

        public void setReadOnly(boolean readonly) {
            this.readonly = readonly;
        }

        private class MyTextField
        extends JTextField {
            public MyTextField(String s) {
                super(s);
            }

            @Override
            public void setText(String s) {
                if (MyJComboBoxEditor.this.readonly || this.getText().equals(s)) {
                    return;
                }
                super.setText(s);
            }
        }
    }

    private static class SubjectEx<S, A>
    extends Subject<S, A> {
        private SubjectEx() {
        }

        @Override
        public void notify(S subject, A arg) {
            super.notify(subject, arg);
        }
    }
}

