/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponse;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.api.services.drive.model.ParentReference;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.thoughtworks.xstream.XStream;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.accessibility.Accessible;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.basic.BasicComboPopup;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.EmailValidator;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.swingx.util.OS;
import org.yccheok.jstock.analysis.Connection;
import org.yccheok.jstock.analysis.DoubleConstantOperator;
import org.yccheok.jstock.analysis.EqualityOperator;
import org.yccheok.jstock.analysis.Indicator;
import org.yccheok.jstock.analysis.OperatorIndicator;
import org.yccheok.jstock.analysis.SinkOperator;
import org.yccheok.jstock.analysis.StockOperator;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.Factories;
import org.yccheok.jstock.engine.PriceSource;
import org.yccheok.jstock.file.Statement;
import org.yccheok.jstock.gui.AppLock;
import org.yccheok.jstock.gui.AutoCompleteJComboBox;
import org.yccheok.jstock.gui.JComboBoxLayerUI;
import org.yccheok.jstock.gui.JComboBoxPopupAdjustable;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.file.PortfolioSelectionJPanel;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.network.Utils;
import org.yccheok.jstock.portfolio.PortfolioInfo;
import org.yccheok.jstock.watchlist.WatchlistInfo;

public class Utils {
    @Deprecated
    private static final ThreadLocal<DateFormat> legacyCommonDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.ENGLISH);
            return dateFormat;
        }
    };
    private static final ThreadLocal<DateFormat> commonDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("MMM d, yyyy", Locale.ENGLISH);
        }
    };
    private static final ThreadLocal<DateFormat> todayLastUpdateTimeFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("h:mm a");
        }
    };
    private static final ThreadLocal<DateFormat> otherDayLastUpdateTimeFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return DateFormat.getDateInstance(3);
        }
    };
    public static Font ROBOTO_LIGHT_FONT = null;
    private static final HanyuPinyinOutputFormat DEFAULT_HANYU_PINYIN_OUTPUT_FORMAT = new HanyuPinyinOutputFormat();
    private static volatile List<String> NTPServers;
    private static final String APPLICATION_VERSION_STRING = "1.0.7";
    private static final int CLOUD_FILE_VERSION_ID = 1107;
    private static final String ABOUT_BOX_VERSION_STRING = "1.0.7.56";
    private static final int APPLICATION_VERSION_ID = 1186;
    private static final Executor zombiePool;
    private static final int NUM_OF_THREADS_ZOMBIE_POOL = 4;
    private static final HttpClient httpClient;
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private static final Pattern googleDocTitlePattern;
    private static final List<Country> supportedStockMarketCountries;
    private static final Log log;

    private Utils() {
    }

    private static String toJson(Object object) {
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        return gson.toJson(object);
    }

    private static <T> T fromJson(Reader reader, Class<T> classOfT) {
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        return (T)gson.fromJson(reader, classOfT);
    }

    public static boolean saveJson(java.io.File file, Object object) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
            writer.write(Utils.toJson(object));
        }
        catch (IOException e) {
            log.error(null, (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromJson(java.io.File file, Class<T> classOfT) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            T t = Utils.fromJson(reader, classOfT);
            return t;
        }
        catch (IOException e) {
            log.error(null, (Throwable)e);
            return null;
        }
        catch (JsonSyntaxException e) {
            log.error(null, (Throwable)e);
        }
        return null;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static void updateFactoriesPriceSource() {
        for (Country country : Country.values()) {
            PriceSource priceSource = JStock.instance().getJStockOptions().getPriceSource(country);
            Factories.INSTANCE.updatePriceSource(country, priceSource);
        }
    }

    public static boolean hasSpecifiedLanguageFile(Locale locale) {
        if (Utils.isTraditionalChinese(locale)) {
            return true;
        }
        if (Utils.isSimplifiedChinese(locale)) {
            return true;
        }
        if (locale.getLanguage().equals(Locale.GERMAN.getLanguage())) {
            return true;
        }
        if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            return true;
        }
        if (locale.getLanguage().equals(Locale.ITALIAN.getLanguage())) {
            return true;
        }
        return locale.getLanguage().equals(Locale.FRENCH.getLanguage());
    }

    public static void adjustPopupWidth(JComboBox comboBox) {
        if (comboBox.getItemCount() == 0) {
            return;
        }
        Accessible comp = comboBox.getAccessibleContext().getAccessibleChild(0);
        if (!(comp instanceof BasicComboPopup)) {
            return;
        }
        BasicComboPopup popup = (BasicComboPopup)comp;
        JList<Object> list = popup.getList();
        JScrollPane scrollPane = Utils.getScrollPane(popup);
        if (list == null || scrollPane == null) {
            return;
        }
        int popupWidth = list.getPreferredSize().width + 5 + Utils.getScrollBarWidth(comboBox, scrollPane);
        Dimension scrollPaneSize = scrollPane.getPreferredSize();
        scrollPaneSize.width = popupWidth = Math.max(popupWidth, comboBox.getSize().width);
        scrollPane.setPreferredSize(scrollPaneSize);
        scrollPane.setMaximumSize(scrollPaneSize);
        if (comboBox instanceof JComboBoxPopupAdjustable) {
            ((JComboBoxPopupAdjustable)((Object)comboBox)).setPopupWidth(popupWidth);
        }
    }

    private static int getScrollBarWidth(JComboBox comboBox, JScrollPane scrollPane) {
        int scrollBarWidth = 0;
        if (comboBox.getItemCount() > comboBox.getMaximumRowCount()) {
            JScrollBar vertical = scrollPane.getVerticalScrollBar();
            scrollBarWidth = vertical.getPreferredSize().width;
        }
        return scrollBarWidth;
    }

    private static JScrollPane getScrollPane(BasicComboPopup popup) {
        JList<Object> list = popup.getList();
        Container c = SwingUtilities.getAncestorOfClass(JScrollPane.class, list);
        return (JScrollPane)c;
    }

    public static boolean restartApplication(JStock mainFrame) {
        java.io.File jarFile;
        String javaBin = System.getProperty("java.home") + "/bin/javaw";
        try {
            jarFile = new java.io.File(mainFrame.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
            return false;
        }
        if (!jarFile.getName().endsWith(".jar") && !jarFile.getName().endsWith(".exe")) {
            return false;
        }
        String[] toExec = null;
        toExec = jarFile.getName().endsWith(".exe") ? new String[]{jarFile.getPath()} : new String[]{javaBin, "-jar", jarFile.getPath()};
        mainFrame.save();
        AppLock.unlock();
        try {
            Process process = Runtime.getRuntime().exec(toExec);
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
            return false;
        }
        mainFrame.setVisible(false);
        mainFrame.dispose();
        System.exit(0);
        return true;
    }

    public static long getGoogleServerTimestamp() {
        String _time = Utils.getUUIDValue(org.yccheok.jstock.network.Utils.getURL(Utils.Type.GET_TIME), "time");
        if (_time == null) {
            return 0L;
        }
        try {
            long time = Long.parseLong(_time);
            return time;
        }
        catch (NumberFormatException exp) {
            log.error(null, (Throwable)exp);
            return 0L;
        }
    }

    public static String toEndWithFileSeperator(String string) {
        if (string.endsWith(java.io.File.separator)) {
            return string;
        }
        return string + java.io.File.separator;
    }

    public static boolean extractZipFile(String zipFilePath, boolean overwrite) {
        return Utils.extractZipFile(new java.io.File(zipFilePath), overwrite);
    }

    public static boolean extractZipFile(java.io.File zipFilePath, boolean overwrite) {
        return Utils.extractZipFile(zipFilePath, Utils.getUserDataDirectory(), overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractZipFile(java.io.File zipFilePath, String destDirectory, boolean overwrite) {
        FileInputStream inputStream = null;
        ZipInputStream zipInputStream = null;
        boolean status = true;
        try {
            inputStream = new FileInputStream(zipFilePath);
            zipInputStream = new ZipInputStream(inputStream);
            byte[] data = new byte[1024];
            while (true) {
                ZipEntry zipEntry = null;
                FileOutputStream outputStream = null;
                try {
                    zipEntry = zipInputStream.getNextEntry();
                    if (zipEntry == null) break;
                    String destination = destDirectory.endsWith(java.io.File.separator) ? destDirectory + zipEntry.getName() : destDirectory + java.io.File.separator + zipEntry.getName();
                    if (!overwrite && Utils.isFileOrDirectoryExist(destination)) continue;
                    if (zipEntry.isDirectory()) {
                        Utils.createCompleteDirectoryHierarchyIfDoesNotExist(destination);
                        continue;
                    }
                    java.io.File file = new java.io.File(destination);
                    Utils.createCompleteDirectoryHierarchyIfDoesNotExist(file.getParentFile());
                    int size = zipInputStream.read(data);
                    if (size <= 0) continue;
                    outputStream = new FileOutputStream(destination);
                    do {
                        outputStream.write(data, 0, size);
                    } while ((size = zipInputStream.read(data)) >= 0);
                    continue;
                }
                catch (IOException exp) {
                    log.error(null, (Throwable)exp);
                    status = false;
                }
                finally {
                    org.yccheok.jstock.file.Utils.close(outputStream);
                    org.yccheok.jstock.file.Utils.closeEntry(zipInputStream);
                    continue;
                }
                break;
            }
        }
        catch (IOException exp) {
            try {
                log.error(null, (Throwable)exp);
                status = false;
            }
            catch (Throwable throwable) {
                org.yccheok.jstock.file.Utils.close(zipInputStream);
                org.yccheok.jstock.file.Utils.close(inputStream);
                throw throwable;
            }
            org.yccheok.jstock.file.Utils.close(zipInputStream);
            org.yccheok.jstock.file.Utils.close(inputStream);
        }
        org.yccheok.jstock.file.Utils.close(zipInputStream);
        org.yccheok.jstock.file.Utils.close(inputStream);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUUIDValue(String url, String key) {
        InputStreamAndMethod inputStreamAndMethod = Utils.getResponseBodyAsStreamBasedOnProxyAuthOption(url);
        if (inputStreamAndMethod.inputStream == null) {
            inputStreamAndMethod.method.releaseConnection();
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStreamAndMethod.inputStream);
        }
        catch (IOException exp) {
            log.error(null, (Throwable)exp);
            String string = null;
            return string;
        }
        catch (IllegalArgumentException exp) {
            log.error(null, (Throwable)exp);
            String string = null;
            return string;
        }
        finally {
            org.yccheok.jstock.file.Utils.close(inputStreamAndMethod.inputStream);
            inputStreamAndMethod.method.releaseConnection();
        }
        String _id = properties.getProperty("id");
        if (_id == null) {
            log.info((Object)"UUID not found");
            return null;
        }
        String id = Utils.decrypt(_id);
        if (!id.equals(Utils.getJStockUUID())) {
            log.info((Object)"UUID doesn't match");
            return null;
        }
        String value = properties.getProperty(key);
        if (value == null) {
            log.info((Object)"Value not found");
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getUUIDValue(String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        InputStreamAndMethod inputStreamAndMethod = Utils.getResponseBodyAsStreamBasedOnProxyAuthOption(url);
        if (inputStreamAndMethod.inputStream == null) {
            inputStreamAndMethod.method.releaseConnection();
            return Collections.emptyMap();
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStreamAndMethod.inputStream);
        }
        catch (IOException exp) {
            log.error(null, (Throwable)exp);
            Map<String, String> map2 = Collections.emptyMap();
            return map2;
        }
        catch (IllegalArgumentException exp) {
            log.error(null, (Throwable)exp);
            Map<String, String> map3 = Collections.emptyMap();
            return map3;
        }
        finally {
            org.yccheok.jstock.file.Utils.close(inputStreamAndMethod.inputStream);
            inputStreamAndMethod.method.releaseConnection();
        }
        String _id = properties.getProperty("id");
        if (_id == null) {
            log.info((Object)"UUID not found");
            return Collections.emptyMap();
        }
        String id = Utils.decrypt(_id);
        if (!id.equals(Utils.getJStockUUID())) {
            log.info((Object)"UUID doesn't match");
            return Collections.emptyMap();
        }
        for (Object key : properties.keySet()) {
            if (key == null || key.equals("id")) continue;
            map.put(key.toString(), properties.getProperty(key.toString()));
        }
        return map;
    }

    public static ZipEntry getZipEntry(String zipEntryName) {
        return new ZipEntry(zipEntryName.replace(java.io.File.separator, "/"));
    }

    private static List<String> getNTPServers() {
        String[] s;
        List<String> defaultServer = Collections.unmodifiableList(Arrays.asList("time-a.nist.gov", "time-b.nist.gov", "time-nw.nist.gov"));
        List<String> servers = NTPServers;
        if (servers != null) {
            return servers;
        }
        String server = Utils.getUUIDValue(org.yccheok.jstock.network.Utils.getURL(Utils.Type.NTP_SERVER_TXT), "server");
        if (server != null && (s = server.split(",")).length > 0) {
            List<String> me = Collections.unmodifiableList(Arrays.asList(s));
            NTPServers = me;
            return me;
        }
        NTPServers = defaultServer;
        return defaultServer;
    }

    public static void launchWebBrowser(String address) {
        try {
            URL url = new URL(address);
            Utils.launchWebBrowser(url);
        }
        catch (MalformedURLException ex) {
            return;
        }
    }

    public static void launchWebBrowser(URL url) {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(url.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void launchWebBrowser(HyperlinkEvent evt) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(evt.getEventType())) {
            Desktop desktop;
            URL url = evt.getURL();
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                if (url == null) {
                    String string = "http://" + evt.getDescription();
                    try {
                        url = new URL(string);
                    }
                    catch (MalformedURLException ex) {
                        return;
                    }
                }
                try {
                    desktop.browse(url.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static Image getScaledImage(Image image, int maxWidth, int maxHeight) {
        image = new ImageIcon(image).getImage();
        int imgWidth = image.getWidth(null);
        int imgHeight = image.getHeight(null);
        int preferredWidth = Math.min(imgWidth, maxWidth);
        int preferredHeight = Math.min(imgHeight, maxHeight);
        double scaleX = (double)preferredWidth / (double)imgWidth;
        double scaleY = (double)preferredHeight / (double)imgHeight;
        double bestScale = Math.min(scaleX, scaleY);
        return image.getScaledInstance((int)((double)imgWidth * bestScale), (int)((double)imgHeight * bestScale), 4);
    }

    private static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = Utils.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static java.io.File createTempDir() {
        java.io.File baseDir = new java.io.File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            java.io.File tempDir = new java.io.File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    public static boolean deleteDir(java.io.File dir, boolean deleteRoot) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Utils.deleteDir(new java.io.File(dir, children[i]), true);
                if (success) continue;
                return false;
            }
        }
        if (deleteRoot) {
            return dir.delete();
        }
        return true;
    }

    public static boolean deleteDir(String dir, boolean deleteRoot) {
        return Utils.deleteDir(new java.io.File(dir), deleteRoot);
    }

    public static boolean createCompleteDirectoryHierarchyIfDoesNotExist(String directory) {
        return Utils.createCompleteDirectoryHierarchyIfDoesNotExist(new java.io.File(directory));
    }

    private static boolean createCompleteDirectoryHierarchyIfDoesNotExist(java.io.File f) {
        if (f == null) {
            return true;
        }
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(f.getParentFile())) {
            return false;
        }
        String path = f.getAbsolutePath();
        return Utils.createDirectoryIfDoesNotExist(path);
    }

    private static boolean createDirectoryIfDoesNotExist(String directory) {
        java.io.File f = new java.io.File(directory);
        if (!f.exists()) {
            return f.mkdir();
        }
        return true;
    }

    public static boolean isFileOrDirectoryExist(String fileOrDirectory) {
        java.io.File f = new java.io.File(fileOrDirectory);
        return f.exists();
    }

    public static String getUserDataDirectory() {
        return System.getProperty("user.home") + java.io.File.separator + ".jstock" + java.io.File.separator + Utils.getApplicationVersionString() + java.io.File.separator;
    }

    public static String getHistoryDirectory() {
        return Utils.getHistoryDirectory(JStock.instance().getJStockOptions().getCountry());
    }

    public static String getHistoryDirectory(Country country) {
        return Utils.getUserDataDirectory() + (Object)((Object)country) + java.io.File.separator + "history" + java.io.File.separator;
    }

    public static AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    public static Color getColor(double price, double referencePrice) {
        boolean reverse = org.yccheok.jstock.engine.Utils.isFallBelowAndRiseAboveColorReverse();
        if (price < referencePrice) {
            if (reverse) {
                return JStockOptions.DEFAULT_HIGHER_NUMERICAL_VALUE_FOREGROUND_COLOR;
            }
            return JStockOptions.DEFAULT_LOWER_NUMERICAL_VALUE_FOREGROUND_COLOR;
        }
        if (price > referencePrice) {
            if (reverse) {
                return JStockOptions.DEFAULT_LOWER_NUMERICAL_VALUE_FOREGROUND_COLOR;
            }
            return JStockOptions.DEFAULT_HIGHER_NUMERICAL_VALUE_FOREGROUND_COLOR;
        }
        return JStockOptions.DEFAULT_NORMAL_TEXT_FOREGROUND_COLOR;
    }

    public static boolean deleteDir(java.io.File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Utils.deleteDir(new java.io.File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void deleteAllOldFiles(java.io.File dir, int days) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                Utils.deleteAllOldFiles(new java.io.File(dir, children[i]), days);
            }
            String[] list = dir.list();
            if (list == null) {
                return;
            }
            if (list.length == 0) {
                dir.delete();
            }
        } else {
            long today = System.currentTimeMillis();
            long timeStamp = dir.lastModified();
            long difMil = today - timeStamp;
            long milPerDay = 86400000L;
            long d = difMil / 86400000L;
            if (d >= (long)days) {
                dir.delete();
            }
        }
    }

    public static String getAboutBoxVersionString() {
        return ABOUT_BOX_VERSION_STRING;
    }

    public static String getApplicationVersionString() {
        return APPLICATION_VERSION_STRING;
    }

    public static String encrypt(String source) {
        if (source.length() <= 0) {
            return "";
        }
        StandardPBEStringEncryptor pbeStringEncryptor = new StandardPBEStringEncryptor();
        pbeStringEncryptor.setPassword(Utils.getJStockUUID());
        return pbeStringEncryptor.encrypt(source);
    }

    public static String decrypt(String source) {
        if (source.length() <= 0) {
            return "";
        }
        StandardPBEStringEncryptor pbeStringEncryptor = new StandardPBEStringEncryptor();
        pbeStringEncryptor.setPassword(Utils.getJStockUUID());
        try {
            return pbeStringEncryptor.decrypt(source);
        }
        catch (EncryptionOperationNotPossibleException exp) {
            log.error(null, (Throwable)exp);
            return "";
        }
    }

    public static String getJStockUUID() {
        return "fe78440e-e0fe-4efb-881d-264a01be483c";
    }

    private static String getCloudApplicationName() {
        return "JStock-1107";
    }

    private static String getGoogleDriveTitle(long checksum, long date, int version) {
        return "jstock-" + Utils.getJStockUUID() + "-checksum=" + checksum + "-date=" + date + "-version=" + version + ".zip";
    }

    public static boolean isSimplifiedChinese(Locale locale) {
        return locale.getLanguage().equals(Locale.SIMPLIFIED_CHINESE.getLanguage()) && !locale.getCountry().equals(Locale.TRADITIONAL_CHINESE.getCountry());
    }

    public static boolean isTraditionalChinese(Locale locale) {
        return locale.getLanguage().equals(Locale.TRADITIONAL_CHINESE.getLanguage()) && locale.getCountry().equals(Locale.TRADITIONAL_CHINESE.getCountry());
    }

    public static boolean isMacOSX() {
        return OS.isMacOSX();
    }

    public static boolean isWindows7() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        return "Windows 7".equals(osName) && "6.1".equals(osVersion);
    }

    public static boolean isWindows8() {
        String osVersion = System.getProperty("os.version");
        return "6.2".equals(osVersion);
    }

    public static boolean isWindows() {
        String windowsString = "Windows";
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return false;
        }
        return osName.regionMatches(true, 0, windowsString, 0, windowsString.length());
    }

    public static Executor getZoombiePool() {
        return zombiePool;
    }

    public static Indicator getLastPriceRiseAboveIndicator(double lastPrice) {
        StockOperator stockOperator = new StockOperator();
        stockOperator.setType(StockOperator.Type.LastPrice);
        DoubleConstantOperator doubleConstantOperator = new DoubleConstantOperator();
        doubleConstantOperator.setConstant(lastPrice);
        EqualityOperator equalityOperator = new EqualityOperator();
        equalityOperator.setEquality(EqualityOperator.Equality.GreaterOrEqual);
        SinkOperator sinkOperator = new SinkOperator();
        Connection stockToEqualityConnection = new Connection();
        Connection doubleConstantToEqualityConnection = new Connection();
        Connection equalityToSinkConnection = new Connection();
        stockOperator.addOutputConnection(stockToEqualityConnection, 0);
        equalityOperator.addInputConnection(stockToEqualityConnection, 0);
        doubleConstantOperator.addOutputConnection(doubleConstantToEqualityConnection, 0);
        equalityOperator.addInputConnection(doubleConstantToEqualityConnection, 1);
        equalityOperator.addOutputConnection(equalityToSinkConnection, 0);
        sinkOperator.addInputConnection(equalityToSinkConnection, 0);
        OperatorIndicator operatorIndicator = new OperatorIndicator();
        operatorIndicator.setName("RiseAbove");
        operatorIndicator.add(stockOperator);
        operatorIndicator.add(doubleConstantOperator);
        operatorIndicator.add(equalityOperator);
        operatorIndicator.add(sinkOperator);
        assert (operatorIndicator.getType() == OperatorIndicator.Type.AlertIndicator);
        operatorIndicator.preCalculate();
        return operatorIndicator;
    }

    public static Indicator getLastPriceFallBelowIndicator(double lastPrice) {
        StockOperator stockOperator = new StockOperator();
        stockOperator.setType(StockOperator.Type.LastPrice);
        DoubleConstantOperator doubleConstantOperator = new DoubleConstantOperator();
        doubleConstantOperator.setConstant(lastPrice);
        EqualityOperator equalityOperator = new EqualityOperator();
        equalityOperator.setEquality(EqualityOperator.Equality.LesserOrEqual);
        SinkOperator sinkOperator = new SinkOperator();
        Connection stockToEqualityConnection = new Connection();
        Connection doubleConstantToEqualityConnection = new Connection();
        Connection equalityToSinkConnection = new Connection();
        stockOperator.addOutputConnection(stockToEqualityConnection, 0);
        equalityOperator.addInputConnection(stockToEqualityConnection, 0);
        doubleConstantOperator.addOutputConnection(doubleConstantToEqualityConnection, 0);
        equalityOperator.addInputConnection(doubleConstantToEqualityConnection, 1);
        equalityOperator.addOutputConnection(equalityToSinkConnection, 0);
        sinkOperator.addInputConnection(equalityToSinkConnection, 0);
        OperatorIndicator operatorIndicator = new OperatorIndicator();
        operatorIndicator.setName("FallBelow");
        operatorIndicator.add(stockOperator);
        operatorIndicator.add(doubleConstantOperator);
        operatorIndicator.add(equalityOperator);
        operatorIndicator.add(sinkOperator);
        assert (operatorIndicator.getType() == OperatorIndicator.Type.AlertIndicator);
        operatorIndicator.preCalculate();
        return operatorIndicator;
    }

    public static String setDefaultLookAndFeel() {
        try {
            String className = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(className);
            return className;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    private static GoogleCloudFile searchFromGoogleDrive(Drive drive, String qString) {
        try {
            Drive.Files.List request = drive.files().list().setQ(qString);
            do {
                FileList fileList = (FileList)request.execute();
                long checksum = 0L;
                long date = 0L;
                int version = 0;
                File file = null;
                for (File f : fileList.getItems()) {
                    String title = f.getTitle();
                    if (title == null || f.getDownloadUrl() == null || f.getDownloadUrl().length() <= 0) continue;
                    Matcher matcher = googleDocTitlePattern.matcher(title);
                    String _checksum = null;
                    String _date = null;
                    String _version = null;
                    if (matcher.find() && matcher.groupCount() == 3) {
                        _checksum = matcher.group(1);
                        _date = matcher.group(2);
                        _version = matcher.group(3);
                    }
                    if (_checksum == null || _date == null || _version == null) continue;
                    try {
                        checksum = Long.parseLong(_checksum);
                        date = Long.parseLong(_date);
                        version = Integer.parseInt(_version);
                    }
                    catch (NumberFormatException ex) {
                        log.error(null, (Throwable)ex);
                        continue;
                    }
                    file = f;
                    break;
                }
                if (file != null) {
                    return GoogleCloudFile.newInstance(file, checksum, date, version);
                }
                request.setPageToken(fileList.getNextPageToken());
            } while (request.getPageToken() != null && request.getPageToken().length() > 0);
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CloudFile _loadFromGoogleDrive(Credential credential, String qString) {
        java.io.File outputFile;
        int version;
        long date;
        long checksum;
        block16: {
            Drive drive = org.yccheok.jstock.google.Utils.getDrive(credential);
            GoogleCloudFile googleCloudFile = Utils.searchFromGoogleDrive(drive, qString);
            if (googleCloudFile == null) {
                return null;
            }
            File file = googleCloudFile.file;
            checksum = googleCloudFile.checksum;
            date = googleCloudFile.date;
            version = googleCloudFile.version;
            HttpResponse resp = null;
            InputStream inputStream = null;
            outputFile = null;
            FileOutputStream outputStream = null;
            try {
                resp = drive.getRequestFactory().buildGetRequest(new GenericUrl(file.getDownloadUrl())).execute();
                inputStream = resp.getContent();
                outputFile = java.io.File.createTempFile(Utils.getJStockUUID(), ".zip");
                outputFile.deleteOnExit();
                outputStream = new FileOutputStream(outputFile);
                int read = 0;
                byte[] bytes = new byte[1024];
                while ((read = inputStream.read(bytes)) != -1) {
                    ((OutputStream)outputStream).write(bytes, 0, read);
                }
                org.yccheok.jstock.file.Utils.close(outputStream);
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
                break block16;
            }
            finally {
                org.yccheok.jstock.file.Utils.close(outputStream);
                org.yccheok.jstock.file.Utils.close(inputStream);
                if (resp != null) {
                    try {
                        resp.disconnect();
                    }
                    catch (IOException ex) {
                        log.error(null, (Throwable)ex);
                    }
                }
            }
            org.yccheok.jstock.file.Utils.close(inputStream);
            if (resp != null) {
                try {
                    resp.disconnect();
                }
                catch (IOException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
        }
        if (outputFile == null) {
            return null;
        }
        return CloudFile.newInstance(outputFile, checksum, date, version);
    }

    public static CloudFile loadFromGoogleDrive(Credential credential) {
        String titleName = ("jstock-" + Utils.getJStockUUID() + "-checksum=").substring(0, 25);
        String qString = "title contains '" + titleName + "' and trashed = false and 'appdata' in parents and 'me' in owners";
        return Utils._loadFromGoogleDrive(credential, qString);
    }

    public static boolean saveToGoogleDrive(Credential credential, java.io.File file) {
        String titleName = ("jstock-" + Utils.getJStockUUID() + "-checksum=").substring(0, 25);
        String qString = "title contains '" + titleName + "' and trashed = false and 'appdata' in parents and 'me' in owners";
        return Utils._saveToGoogleDrive(credential, file, qString, "appdata");
    }

    private static boolean _saveToGoogleDrive(Credential credential, java.io.File file, String qString, String folder) {
        Drive drive = org.yccheok.jstock.google.Utils.getDrive(credential);
        GoogleCloudFile googleCloudFile = Utils.searchFromGoogleDrive(drive, qString);
        long checksum = org.yccheok.jstock.analysis.Utils.getChecksum(file);
        long date = new Date().getTime();
        int version = Utils.getCloudFileVersionID();
        String title = Utils.getGoogleDriveTitle(checksum, date, version);
        if (googleCloudFile == null) {
            String id = null;
            if (folder != null) {
                try {
                    File appData = (File)drive.files().get(folder).execute();
                    id = appData.getId();
                }
                catch (IOException ex) {
                    log.error(null, (Throwable)ex);
                    return false;
                }
            }
            return null != Utils.insertFile(drive, title, id, file);
        }
        File oldFile = googleCloudFile.file;
        return null != Utils.updateFile(drive, oldFile.getId(), title, file);
    }

    private static File insertFile(Drive service, String title, String parentId, java.io.File fileContent) {
        File body = new File();
        body.setTitle(title);
        if (parentId != null && parentId.length() > 0) {
            body.setParents(Arrays.asList(new ParentReference().setId(parentId)));
        }
        FileContent mediaContent = new FileContent("", fileContent);
        try {
            File file = (File)service.files().insert(body, (AbstractInputStreamContent)mediaContent).execute();
            return file;
        }
        catch (IOException e) {
            log.error(null, (Throwable)e);
            return null;
        }
    }

    private static File updateFile(Drive service, String fileId, String newTitle, java.io.File fileContent) {
        try {
            File file = (File)service.files().get(fileId).execute();
            file.setTitle(newTitle);
            FileContent mediaContent = new FileContent("", fileContent);
            File updatedFile = (File)service.files().update(fileId, file, (AbstractInputStreamContent)mediaContent).setNewRevision(Boolean.valueOf(false)).execute();
            return updatedFile;
        }
        catch (IOException e) {
            log.error(null, (Throwable)e);
            return null;
        }
    }

    public static boolean isCloudFileCompatible(int cloudFileVersionId) {
        if (cloudFileVersionId == 1107) {
            return true;
        }
        return cloudFileVersionId >= 1051 && cloudFileVersionId <= 1106;
    }

    /*
     * Exception decompiling
     */
    public static String getPOSTResponseBodyAsStringBasedOnProxyAuthOption(String uri, String formData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getResponseBodyAsStringBasedOnProxyAuthOption(String request) {
        return Utils._getResponseBodyAsStringBasedOnProxyAuthOption(httpClient, request);
    }

    /*
     * Exception decompiling
     */
    private static String _getResponseBodyAsStringBasedOnProxyAuthOption(HttpClient client, String request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static InputStreamAndMethod getResponseBodyAsStreamBasedOnProxyAuthOption(String request) {
        org.yccheok.jstock.engine.Utils.setHttpClientProxyFromSystemProperties(httpClient);
        Utils.setHttpClientProxyCredentialsFromJStockOptions(httpClient);
        GetMethod method = new GetMethod(request);
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        InputStreamAndMethod inputStreamAndMethod = null;
        InputStream respond = null;
        GetMethod methodToClosed = method;
        try {
            if (jStockOptions.isProxyAuthEnabled()) {
                method.setFollowRedirects(false);
                httpClient.executeMethod((HttpMethod)method);
                int statuscode = method.getStatusCode();
                if (statuscode == 302 || statuscode == 301 || statuscode == 303 || statuscode == 307) {
                    GetMethod RedirectMethod;
                    Header header = method.getResponseHeader("location");
                    methodToClosed = RedirectMethod = new GetMethod(header.getValue());
                    method.releaseConnection();
                    try {
                        httpClient.executeMethod((HttpMethod)RedirectMethod);
                        respond = RedirectMethod.getResponseBodyAsStream();
                    }
                    catch (HttpException exp) {
                        log.error(null, (Throwable)exp);
                    }
                    catch (IOException exp) {
                        log.error(null, (Throwable)exp);
                    }
                } else {
                    methodToClosed = method;
                    respond = method.getResponseBodyAsStream();
                }
            } else {
                methodToClosed = method;
                httpClient.executeMethod((HttpMethod)method);
                respond = method.getResponseBodyAsStream();
            }
            inputStreamAndMethod = new InputStreamAndMethod(respond, (HttpMethod)methodToClosed);
        }
        catch (HttpException exp) {
            log.error(null, (Throwable)exp);
            inputStreamAndMethod = new InputStreamAndMethod(respond, (HttpMethod)methodToClosed);
        }
        catch (IOException exp2) {
            log.error(null, (Throwable)exp2);
            inputStreamAndMethod = new InputStreamAndMethod(respond, (HttpMethod)methodToClosed);
            {
                catch (Throwable throwable) {
                    inputStreamAndMethod = new InputStreamAndMethod(respond, (HttpMethod)methodToClosed);
                    throw throwable;
                }
            }
        }
        return inputStreamAndMethod;
    }

    private static void setHttpClientProxyCredentialsFromJStockOptions(HttpClient httpClient) {
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        if (!jStockOptions.isProxyAuthEnabled()) {
            httpClient.getState().clearCredentials();
        } else {
            httpClient.getState().setProxyCredentials(AuthScope.ANY, jStockOptions.getCredentials());
        }
    }

    public static String getFileExtension(String s) {
        String ext = "";
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getFileExtension(java.io.File f) {
        return Utils.getFileExtension(f.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationInfo getLatestApplicationInfo() {
        int version;
        String request = org.yccheok.jstock.network.Utils.getURL(Utils.Type.VERSION_INFORMATION_TXT);
        InputStreamAndMethod inputStreamAndMethod = Utils.getResponseBodyAsStreamBasedOnProxyAuthOption(request);
        if (inputStreamAndMethod.inputStream == null) {
            inputStreamAndMethod.method.releaseConnection();
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStreamAndMethod.inputStream);
        }
        catch (IOException exp) {
            log.error(null, (Throwable)exp);
            ApplicationInfo applicationInfo = null;
            return applicationInfo;
        }
        catch (IllegalArgumentException exp) {
            log.error(null, (Throwable)exp);
            ApplicationInfo applicationInfo = null;
            return applicationInfo;
        }
        finally {
            org.yccheok.jstock.file.Utils.close(inputStreamAndMethod.inputStream);
            inputStreamAndMethod.method.releaseConnection();
        }
        String applicationVersionID = properties.getProperty("applicationVersionID");
        String windowsDownloadLink = properties.getProperty("windowsDownloadLink");
        String linuxDownloadLink = properties.getProperty("linuxDownloadLink");
        String macDownloadLink = properties.getProperty("macDownloadLink");
        String solarisDownloadLink = properties.getProperty("solarisDownloadLink");
        if (applicationVersionID == null || windowsDownloadLink == null || linuxDownloadLink == null || macDownloadLink == null || solarisDownloadLink == null) {
            return null;
        }
        try {
            version = Integer.parseInt(applicationVersionID);
        }
        catch (NumberFormatException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
        return new ApplicationInfo(version, windowsDownloadLink, linuxDownloadLink, macDownloadLink, solarisDownloadLink);
    }

    public static int getApplicationVersionID() {
        return 1186;
    }

    public static int getCloudFileVersionID() {
        return 1107;
    }

    public static String toHTML(String plainText) {
        plainText = plainText.replace(System.getProperty("line.separator"), "<br>");
        return "<html><head></head><body>" + plainText + "</body></html>";
    }

    private static XStream getXStream() {
        XStream xStream = new XStream();
        XStream.setupDefaultSecurity((XStream)xStream);
        xStream.allowTypesByWildcard(new String[]{"org.yccheok.jstock.**", "java.awt.Dimension"});
        return xStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A> A fromXML(Class c, Reader reader) {
        block4: {
            Object object;
            XStream xStream = Utils.getXStream();
            try {
                Object object2 = xStream.fromXML(reader);
                if (!c.isInstance(object2)) break block4;
                object = object2;
            }
            catch (Exception exp) {
                log.error(null, (Throwable)exp);
            }
            return (A)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <A> A fromXML(Class<A> c, java.io.File file) {
        XStream xStream = Utils.getXStream();
        FileInputStream inputStream = null;
        InputStreamReader reader = null;
        try {
            inputStream = new FileInputStream(file);
            reader = new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8"));
            Object object = xStream.fromXML((Reader)reader);
            if (c.isInstance(object)) {
                Object object2 = object;
                org.yccheok.jstock.file.Utils.close(reader);
                org.yccheok.jstock.file.Utils.close(inputStream);
                return (A)object2;
            }
            org.yccheok.jstock.file.Utils.close(reader);
        }
        catch (Exception exp) {
            log.error(null, (Throwable)exp);
            return null;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Error err) {
                log.error(null, (Throwable)err);
                return null;
            }
        }
        finally {
            org.yccheok.jstock.file.Utils.close(reader);
            org.yccheok.jstock.file.Utils.close(inputStream);
        }
        org.yccheok.jstock.file.Utils.close(inputStream);
        return null;
    }

    public static <A> A fromXML(Class<A> c, String filePath) {
        return Utils.fromXML(c, new java.io.File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean toXML(Object object, java.io.File file) {
        XStream xStream = Utils.getXStream();
        FileOutputStream outputStream = null;
        OutputStreamWriter writer = null;
        try {
            outputStream = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)outputStream, Charset.forName("UTF-8"));
            xStream.toXML(object, (Writer)writer);
            org.yccheok.jstock.file.Utils.close(writer);
        }
        catch (Exception exp) {
            log.error(null, (Throwable)exp);
            boolean bl = false;
            return bl;
        }
        finally {
            org.yccheok.jstock.file.Utils.close(writer);
            org.yccheok.jstock.file.Utils.close(outputStream);
        }
        org.yccheok.jstock.file.Utils.close(outputStream);
        return true;
    }

    public static boolean toXML(Object object, String filePath) {
        return Utils.toXML(object, new java.io.File(filePath));
    }

    public static java.io.File getStockInfoDatabaseMetaFile() {
        return new java.io.File(Utils.getUserDataDirectory() + "stock-info-database-meta.json");
    }

    public static String getExtraDataDirectory() {
        return Utils.getUserDataDirectory() + "extra" + java.io.File.separator;
    }

    public static String toHTMLFileSrcFormat(String filename) {
        try {
            return new java.io.File(filename).toURI().toURL().toString();
        }
        catch (MalformedURLException ex) {
            log.error(null, (Throwable)ex);
            return "file:" + filename;
        }
    }

    public static FileEx promptSavePortfolioCSVAndExcelJFileChooser(final String suggestedFileName) {
        String parent;
        java.io.File file;
        String output;
        int result;
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        final JFileChooser chooser = new JFileChooser(jStockOptions.getLastFileIODirectory());
        final FileNameExtensionFilter csvFilter = new FileNameExtensionFilter("CSV Documents (*.csv)", "csv");
        FileNameExtensionFilter xlsFilter = new FileNameExtensionFilter("Microsoft Excel (*.xls)", "xls");
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(csvFilter);
        chooser.addChoosableFileFilter(xlsFilter);
        final PortfolioSelectionJPanel portfolioSelectionJPanel = new PortfolioSelectionJPanel();
        chooser.setAccessory(portfolioSelectionJPanel);
        chooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean flag = ((FileNameExtensionFilter)evt.getNewValue()).equals(csvFilter);
                portfolioSelectionJPanel.setEnabled(flag);
                chooser.setSelectedFile(chooser.getFileFilter().getDescription().equals(csvFilter.getDescription()) ? new java.io.File(portfolioSelectionJPanel.getSuggestedFileName()) : new java.io.File(suggestedFileName));
            }
        });
        portfolioSelectionJPanel.addJRadioButtonsActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                chooser.setSelectedFile(new java.io.File(portfolioSelectionJPanel.getSuggestedFileName()));
            }
        });
        HashMap<String, FileNameExtensionFilter> map = new HashMap<String, FileNameExtensionFilter>();
        map.put(csvFilter.getDescription(), csvFilter);
        map.put(xlsFilter.getDescription(), xlsFilter);
        FileNameExtensionFilter filter = (FileNameExtensionFilter)map.get(jStockOptions.getLastSavedFileNameExtensionDescription());
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        portfolioSelectionJPanel.setEnabled(chooser.getFileFilter().getDescription().equals(csvFilter.getDescription()));
        chooser.setSelectedFile(chooser.getFileFilter().getDescription().equals(csvFilter.getDescription()) ? new java.io.File(portfolioSelectionJPanel.getSuggestedFileName()) : new java.io.File(suggestedFileName));
        do {
            int returnVal;
            if ((returnVal = chooser.showSaveDialog(JStock.instance())) != 0) {
                return null;
            }
            file = chooser.getSelectedFile();
            if (file == null) {
                return null;
            }
            String extension = Utils.getFileExtension(file);
            if (!extension.equals("csv") && !extension.equals("xls")) {
                if (chooser.getFileFilter().getDescription().equals(csvFilter.getDescription())) {
                    file = new java.io.File(file.getAbsolutePath() + ".csv");
                } else if (chooser.getFileFilter().getDescription().equals(xlsFilter.getDescription())) {
                    file = new java.io.File(file.getAbsolutePath() + ".xls");
                } else {
                    return null;
                }
            }
            if (!file.exists()) break;
            output = MessageFormat.format(MessagesBundle.getString("question_message_replace_old_template"), file.getName());
        } while ((result = JOptionPane.showConfirmDialog(JStock.instance(), output, MessagesBundle.getString("question_title_replace_old"), 0, 3)) != 0);
        if ((parent = chooser.getSelectedFile().getParent()) != null) {
            jStockOptions.setLastFileIODirectory(parent);
        }
        if (Utils.getFileExtension(file).equals("csv")) {
            jStockOptions.setLastFileNameExtensionDescription(csvFilter.getDescription());
        } else if (Utils.getFileExtension(file).equals("xls")) {
            jStockOptions.setLastFileNameExtensionDescription(xlsFilter.getDescription());
        } else {
            return null;
        }
        return new FileEx(file, portfolioSelectionJPanel.getType());
    }

    public static JRadioButton getSelection(ButtonGroup group) {
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            JRadioButton b = (JRadioButton)e.nextElement();
            if (b.getModel() != group.getSelection()) continue;
            return b;
        }
        return null;
    }

    private static java.io.File promptOpenJFileChooser(FileNameExtensionFilter ... fileNameExtensionFilters) {
        int returnVal;
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        JFileChooser chooser = new JFileChooser(jStockOptions.getLastFileIODirectory());
        chooser.setAcceptAllFileFilterUsed(false);
        for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
            chooser.addChoosableFileFilter(fileNameExtensionFilter);
        }
        HashMap<String, FileNameExtensionFilter> map = new HashMap<String, FileNameExtensionFilter>();
        for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
            map.put(fileNameExtensionFilter.getDescription(), fileNameExtensionFilter);
        }
        FileNameExtensionFilter filter = (FileNameExtensionFilter)map.get(jStockOptions.getLastSavedFileNameExtensionDescription());
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        if ((returnVal = chooser.showOpenDialog(JStock.instance())) != 0) {
            return null;
        }
        java.io.File file = chooser.getSelectedFile();
        if (file == null || !file.exists()) {
            return null;
        }
        String parent = chooser.getSelectedFile().getParent();
        if (parent != null) {
            jStockOptions.setLastFileIODirectory(parent);
        }
        String extension = Utils.getFileExtension(file);
        for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
            String[] extensions = fileNameExtensionFilter.getExtensions();
            if (extensions.length <= 0 || !extension.equals(extensions[0])) continue;
            jStockOptions.setLastFileNameExtensionDescription(fileNameExtensionFilter.getDescription());
            return file;
        }
        return null;
    }

    public static void playAlertSound() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Clip clip = AudioSystem.getClip();
                    clip.addLineListener(new LineListener(){

                        @Override
                        public void update(LineEvent event) {
                            if (event.getType() == LineEvent.Type.STOP) {
                                event.getLine().close();
                            }
                        }
                    });
                    InputStream audioSrc = Utils.class.getResourceAsStream("/assets/sounds/doorbell.wav");
                    BufferedInputStream bufferedIn = new BufferedInputStream(audioSrc);
                    AudioInputStream inputStream = AudioSystem.getAudioInputStream(bufferedIn);
                    clip.open(inputStream);
                    clip.start();
                }
                catch (Exception e) {
                    log.error(null, (Throwable)e);
                }
            }
        }).start();
    }

    public static java.io.File promptOpenCSVAndExcelJFileChooser() {
        FileNameExtensionFilter csvFilter = new FileNameExtensionFilter("CSV Documents (*.csv)", "csv");
        FileNameExtensionFilter xlsFilter = new FileNameExtensionFilter("Microsoft Excel (*.xls)", "xls");
        return Utils.promptOpenJFileChooser(csvFilter, xlsFilter);
    }

    public static java.io.File promptOpenZippedJFileChooser() {
        FileNameExtensionFilter zippedFilter = new FileNameExtensionFilter("Zipped Files (*.zip)", "zip");
        return Utils.promptOpenJFileChooser(zippedFilter);
    }

    public static String stockPriceDecimalFormat(Object value) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00#");
        return decimalFormat.format(value);
    }

    public static String stockPriceDecimalFormat(double value) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00#");
        return decimalFormat.format(value);
    }

    private static java.io.File promptSaveJFileChooser(String suggestedFileName, FileNameExtensionFilter ... fileNameExtensionFilters) {
        String parent;
        java.io.File file;
        String output;
        int result;
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        JFileChooser chooser = new JFileChooser(jStockOptions.getLastFileIODirectory());
        chooser.setAcceptAllFileFilterUsed(false);
        for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
            chooser.addChoosableFileFilter(fileNameExtensionFilter);
        }
        chooser.setSelectedFile(new java.io.File(suggestedFileName));
        HashMap<String, FileNameExtensionFilter> map = new HashMap<String, FileNameExtensionFilter>();
        for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
            map.put(fileNameExtensionFilter.getDescription(), fileNameExtensionFilter);
        }
        FileNameExtensionFilter filter = (FileNameExtensionFilter)map.get(jStockOptions.getLastSavedFileNameExtensionDescription());
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        do {
            String[] extensions;
            int returnVal;
            if ((returnVal = chooser.showSaveDialog(JStock.instance())) != 0) {
                return null;
            }
            file = chooser.getSelectedFile();
            if (file == null) {
                return null;
            }
            String extension = Utils.getFileExtension(file);
            boolean found = false;
            block3: for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
                for (String e : extensions = fileNameExtensionFilter.getExtensions()) {
                    if (!e.equals(extension)) continue;
                    found = true;
                    break block3;
                }
            }
            if (!found) {
                for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
                    extensions = fileNameExtensionFilter.getExtensions();
                    if (extensions.length <= 0) continue;
                    String e = extensions[0];
                    if (!chooser.getFileFilter().getDescription().equals(fileNameExtensionFilter.getDescription())) continue;
                    if (e.startsWith(".")) {
                        file = new java.io.File(file.getAbsolutePath() + e);
                        break;
                    }
                    file = new java.io.File(file.getAbsolutePath() + "." + e);
                    break;
                }
            }
            if (!file.exists()) break;
            output = MessageFormat.format(MessagesBundle.getString("question_message_replace_old_template"), file.getName());
        } while ((result = JOptionPane.showConfirmDialog(JStock.instance(), output, MessagesBundle.getString("question_title_replace_old"), 0, 3)) != 0);
        if ((parent = chooser.getSelectedFile().getParent()) != null) {
            jStockOptions.setLastFileIODirectory(parent);
        }
        String e = Utils.getFileExtension(file);
        for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
            String[] extensions = fileNameExtensionFilter.getExtensions();
            if (extensions.length <= 0 || !e.equals(extensions[0])) continue;
            jStockOptions.setLastFileNameExtensionDescription(fileNameExtensionFilter.getDescription());
            break;
        }
        return file;
    }

    public static java.io.File promptSaveZippedJFileChooser(String suggestedFileName) {
        FileNameExtensionFilter zippedFilter = new FileNameExtensionFilter("Zipped Files (*.zip)", "zip");
        return Utils.promptSaveJFileChooser(suggestedFileName, zippedFilter);
    }

    public static Font getBoldFont(Font font) {
        return font.deriveFont(font.getStyle() | 1);
    }

    public static java.io.File promptSaveCSVAndExcelJFileChooser(String suggestedFileName) {
        FileNameExtensionFilter csvFilter = new FileNameExtensionFilter("CSV Documents (*.csv)", "csv");
        FileNameExtensionFilter xlsFilter = new FileNameExtensionFilter("Microsoft Excel (*.xls)", "xls");
        return Utils.promptSaveJFileChooser(suggestedFileName, csvFilter, xlsFilter);
    }

    public static JXLayer<JComboBox> getBusyJXLayer(AutoCompleteJComboBox autoCompleteJComboBox) {
        JXLayer layer = new JXLayer((Component)autoCompleteJComboBox);
        JComboBoxLayerUI<AutoCompleteJComboBox> jComboBoxLayerUI = new JComboBoxLayerUI<AutoCompleteJComboBox>();
        layer.setUI(jComboBoxLayerUI);
        autoCompleteJComboBox.attachBusyObserver(jComboBoxLayerUI);
        return layer;
    }

    public static String toEmailIfPossible(String username) {
        if (!EmailValidator.getInstance().isValid(username)) {
            username = username + "@gmail.com";
            if (!EmailValidator.getInstance().isValid(username)) {
                return null;
            }
        }
        return username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int numOfLines(java.io.File file, boolean skipMetadata) {
        int line = 0;
        int metaLineNumber = 0;
        LineNumberReader lnr = null;
        try {
            lnr = new LineNumberReader(new FileReader(file));
            if (skipMetadata) {
                String key;
                String[] tokens;
                String nextLine = lnr.readLine();
                while (nextLine != null && (tokens = nextLine.split("=", 2)).length == 2 && (key = tokens[0].trim()).length() > 0) {
                    ++metaLineNumber;
                    nextLine = lnr.readLine();
                }
            }
            lnr.skip(Long.MAX_VALUE);
            line = lnr.getLineNumber();
        }
        catch (IOException ex) {
            try {
                log.error(null, (Throwable)ex);
            }
            catch (Throwable throwable) {
                org.yccheok.jstock.file.Utils.close(lnr);
                throw throwable;
            }
            org.yccheok.jstock.file.Utils.close(lnr);
        }
        org.yccheok.jstock.file.Utils.close(lnr);
        return line - metaLineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadAsString(String location) {
        InputStreamAndMethod inputStreamAndMethod = Utils.getResponseBodyAsStreamBasedOnProxyAuthOption(location);
        if (inputStreamAndMethod.inputStream == null) {
            inputStreamAndMethod.method.releaseConnection();
            return null;
        }
        try {
            Scanner s = new Scanner(inputStreamAndMethod.inputStream, "UTF-8").useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : null;
            return string;
        }
        finally {
            org.yccheok.jstock.file.Utils.close(inputStreamAndMethod.inputStream);
            inputStreamAndMethod.method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.io.File downloadAsTempFile(String location) {
        block7: {
            java.io.File file;
            InputStreamAndMethod inputStreamAndMethod = Utils.getResponseBodyAsStreamBasedOnProxyAuthOption(location);
            if (inputStreamAndMethod.inputStream == null) {
                inputStreamAndMethod.method.releaseConnection();
                return null;
            }
            FileOutputStream out = null;
            java.io.File temp = null;
            try {
                int len;
                temp = java.io.File.createTempFile(Utils.getJStockUUID(), null);
                temp.deleteOnExit();
                out = new FileOutputStream(temp);
                byte[] buf = new byte[1024];
                while ((len = inputStreamAndMethod.inputStream.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                file = temp;
                org.yccheok.jstock.file.Utils.close(out);
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
                break block7;
            }
            finally {
                org.yccheok.jstock.file.Utils.close(out);
                org.yccheok.jstock.file.Utils.close(inputStreamAndMethod.inputStream);
                inputStreamAndMethod.method.releaseConnection();
            }
            org.yccheok.jstock.file.Utils.close(inputStreamAndMethod.inputStream);
            inputStreamAndMethod.method.releaseConnection();
            return file;
        }
        return null;
    }

    public static List<String> toHanyuPinyin(String chinese) {
        if (chinese.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<StringBuilder> stringBuilders = null;
        int length = chinese.length();
        for (int i = 0; i < length; ++i) {
            char c = chinese.charAt(i);
            String[] pinyins = null;
            HashSet<Character> set = new HashSet<Character>();
            if (CharUtils.isAscii((char)c)) {
                if (CharUtils.isAsciiAlphanumeric((char)c)) {
                    set.add(Character.valueOf(c));
                }
            } else {
                try {
                    pinyins = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)DEFAULT_HANYU_PINYIN_OUTPUT_FORMAT);
                    if (pinyins != null) {
                        for (String pinyin : pinyins) {
                            set.add(Character.valueOf(pinyin.charAt(0)));
                        }
                    }
                }
                catch (BadHanyuPinyinOutputFormatCombination ex) {
                    log.error(null, (Throwable)ex);
                }
            }
            ArrayList<StringBuilder> tmps = stringBuilders;
            stringBuilders = new ArrayList<StringBuilder>();
            if (tmps == null) {
                for (Character character : set) {
                    StringBuilder me = new StringBuilder();
                    me.append(character);
                    stringBuilders.add(me);
                }
                continue;
            }
            for (Character character : set) {
                for (StringBuilder tmp : tmps) {
                    StringBuilder me = new StringBuilder();
                    me.append((CharSequence)tmp);
                    me.append(character);
                    stringBuilders.add(me);
                }
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        if (stringBuilders != null) {
            for (StringBuilder stringBuilder : stringBuilders) {
                result.add(stringBuilder.toString());
            }
        }
        return result;
    }

    public static String getDefaultCurrencySymbol() {
        return "$";
    }

    public static String commonDateFormat(long time) {
        return commonDateFormat.get().format(time);
    }

    public static String commonDateFormat(Date date) {
        return commonDateFormat.get().format(date);
    }

    public static Date commonDateParse(String string) {
        try {
            return commonDateFormat.get().parse(string);
        }
        catch (ParseException e) {
            log.error(null, (Throwable)e);
            try {
                return legacyCommonDateFormat.get().parse(string);
            }
            catch (ParseException e1) {
                log.error(null, (Throwable)e1);
                return null;
            }
        }
    }

    public static boolean isToday(long timestamp) {
        Calendar calendar = Calendar.getInstance();
        int date = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1);
        calendar.setTimeInMillis(timestamp);
        int _date = calendar.get(5);
        int _month = calendar.get(2);
        int _year = calendar.get(1);
        return date == _date && month == _month && year == _year;
    }

    private static Gson getGsonForStockInfoDatabaseMeta() {
        Gson gson = new GsonBuilder().registerTypeAdapter(new TypeToken<EnumMap<Country, Long>>(){}.getType(), new EnumMapInstanceCreator(Country.class)).create();
        return gson;
    }

    public static List<Country> getSupportedStockMarketCountries(boolean useCache) {
        if (!useCache) {
            supportedStockMarketCountries.clear();
        }
        return Utils.getSupportedStockMarketCountries();
    }

    public static List<Country> getSupportedStockMarketCountries() {
        if (!supportedStockMarketCountries.isEmpty()) {
            return Collections.unmodifiableList(supportedStockMarketCountries);
        }
        ArrayList<Country> countries = new ArrayList<Country>(Arrays.asList(Country.values()));
        countries.remove((Object)Country.Czech);
        countries.remove((Object)Country.Hungary);
        countries.remove((Object)Country.Mexico);
        List<WatchlistInfo> watchlistInfos = org.yccheok.jstock.watchlist.Utils.getWatchlistInfos();
        boolean removeMalaysia = true;
        for (WatchlistInfo watchlistInfo : watchlistInfos) {
            if (watchlistInfo.country != Country.Malaysia) continue;
            removeMalaysia = false;
            break;
        }
        if (removeMalaysia) {
            List<PortfolioInfo> portfolioInfos = org.yccheok.jstock.portfolio.Utils.getPortfolioInfos();
            for (PortfolioInfo portfolioInfo : portfolioInfos) {
                if (portfolioInfo.country != Country.Malaysia) continue;
                removeMalaysia = false;
                break;
            }
        }
        if (removeMalaysia) {
            countries.remove((Object)Country.Malaysia);
        }
        supportedStockMarketCountries.clear();
        supportedStockMarketCountries.addAll(countries);
        return supportedStockMarketCountries;
    }

    public static Map<Country, Long> loadStockInfoDatabaseMeta(String json) {
        Gson gson = Utils.getGsonForStockInfoDatabaseMeta();
        Map stockInfoDatabaseMeta = null;
        try {
            stockInfoDatabaseMeta = (Map)gson.fromJson(json, new TypeToken<EnumMap<Country, Long>>(){}.getType());
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
        }
        if (stockInfoDatabaseMeta == null) {
            return Collections.emptyMap();
        }
        return stockInfoDatabaseMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Country, Long> loadStockInfoDatabaseMeta(java.io.File stockInfoDatabaseMetaFile) {
        Gson gson = Utils.getGsonForStockInfoDatabaseMeta();
        Map stockInfoDatabaseMeta = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(stockInfoDatabaseMetaFile), "UTF-8"));){
            stockInfoDatabaseMeta = (Map)gson.fromJson((Reader)reader, new TypeToken<EnumMap<Country, Long>>(){}.getType());
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (JsonSyntaxException ex) {
            log.error(null, (Throwable)ex);
        }
        if (stockInfoDatabaseMeta == null) {
            return Collections.emptyMap();
        }
        return stockInfoDatabaseMeta;
    }

    public static Font getRobotoLightFont() {
        if (ROBOTO_LIGHT_FONT == null) {
            ROBOTO_LIGHT_FONT = Utils._getRobotoLightFont();
        }
        return ROBOTO_LIGHT_FONT;
    }

    private static Font _getRobotoLightFont() {
        InputStream inputStream = Utils.class.getResourceAsStream("/assets/fonts/Roboto-Light.ttf");
        try {
            Font font = Font.createFont(0, inputStream);
            if (font != null) {
                Font font2 = font;
                return font2;
            }
        }
        catch (FontFormatException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
        }
        finally {
            org.yccheok.jstock.file.Utils.close(inputStream);
        }
        Font oldLabelFont = UIManager.getFont("Label.font");
        return oldLabelFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveStockInfoDatabaseMeta(java.io.File stockInfoDatabaseMetaFile, Map<Country, Long> stockInfoDatabaseMeta) {
        Gson gson = Utils.getGsonForStockInfoDatabaseMeta();
        String string = gson.toJson(stockInfoDatabaseMeta);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(stockInfoDatabaseMetaFile), "UTF-8"));){
            writer.write(string);
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            return false;
        }
        return true;
    }

    public static DateFormat getTodayLastUpdateTimeFormat() {
        return todayLastUpdateTimeFormat.get();
    }

    public static DateFormat getOtherDayLastUpdateTimeFormat() {
        return otherDayLastUpdateTimeFormat.get();
    }

    public static String decrypt_android(String source) {
        try {
            return Utils.decrypt_android(Utils.getJStockUUIDAsKey(), source);
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
            return null;
        }
    }

    public static String decrypt_android(byte[] key, String encrypted) throws GeneralSecurityException {
        if (key == null || key.length != 16) {
            throw new IllegalArgumentException("Invalid key size.");
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, secretKeySpec);
        byte[] binary = Base64.getDecoder().decode(encrypted);
        byte[] original = cipher.doFinal(binary);
        return new String(original, Charset.forName("UTF-8"));
    }

    public static byte[] getKey(String string) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        byte[] key = sha.digest(string.getBytes("UTF-8"));
        key = Arrays.copyOf(key, 16);
        return key;
    }

    private static byte[] getJStockUUIDAsKey() throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return Utils.getKey(Utils.getJStockUUID());
    }

    static {
        DEFAULT_HANYU_PINYIN_OUTPUT_FORMAT.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        DEFAULT_HANYU_PINYIN_OUTPUT_FORMAT.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        DEFAULT_HANYU_PINYIN_OUTPUT_FORMAT.setVCharType(HanyuPinyinVCharType.WITH_V);
        NTPServers = null;
        zombiePool = Executors.newFixedThreadPool(4);
        MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
        multiThreadedHttpConnectionManager.getParams().setMaxTotalConnections(128);
        multiThreadedHttpConnectionManager.getParams().setDefaultMaxConnectionsPerHost(128);
        httpClient = new HttpClient((HttpConnectionManager)multiThreadedHttpConnectionManager);
        httpClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
        httpClient.getParams().setCookiePolicy("compatibility");
        multiThreadedHttpConnectionManager.getParams().setMaxConnectionsPerHost(httpClient.getHostConfiguration(), 128);
        googleDocTitlePattern = Pattern.compile("jstock-" + Utils.getJStockUUID() + "-checksum=([0-9]+)-date=([0-9]+)-version=([0-9]+)\\.zip", 2);
        supportedStockMarketCountries = new ArrayList<Country>();
        log = LogFactory.getLog(Utils.class);
    }

    public static class ApplicationInfo {
        public final int applicationVersionID;
        public final String windowsDownloadLink;
        public final String linuxDownloadLink;
        public final String macDownloadLink;
        public final String solarisDownloadLink;

        public ApplicationInfo(int applicationVersionID, String windowsDownloadLink, String linuxDownloadLink, String macDownloadLink, String solarisDownloadLink) {
            this.applicationVersionID = applicationVersionID;
            this.windowsDownloadLink = windowsDownloadLink;
            this.linuxDownloadLink = linuxDownloadLink;
            this.macDownloadLink = macDownloadLink;
            this.solarisDownloadLink = solarisDownloadLink;
        }
    }

    private static class EnumMapInstanceCreator<K extends Enum<K>, V>
    implements InstanceCreator<EnumMap<K, V>> {
        private final Class<K> enumClazz;

        public EnumMapInstanceCreator(Class<K> enumClazz) {
            this.enumClazz = enumClazz;
        }

        public EnumMap<K, V> createInstance(Type type) {
            return new EnumMap(this.enumClazz);
        }
    }

    public static class FileEx {
        public final java.io.File file;
        public final Statement.Type type;

        public FileEx(java.io.File file, Statement.Type type) {
            this.file = file;
            this.type = type;
        }
    }

    public static class InputStreamAndMethod {
        public final InputStream inputStream;
        public final HttpMethod method;

        public InputStreamAndMethod(InputStream inputStream, HttpMethod method) {
            this.inputStream = inputStream;
            this.method = method;
        }
    }

    private static class GoogleCloudFile {
        public final File file;
        public final long checksum;
        public final long date;
        public final int version;

        private GoogleCloudFile(File file, long checksum, long date, int version) {
            this.file = file;
            this.checksum = checksum;
            this.date = date;
            this.version = version;
        }

        public static GoogleCloudFile newInstance(File file, long checksum, long date, int version) {
            return new GoogleCloudFile(file, checksum, date, version);
        }
    }

    public static class CloudFile {
        public final java.io.File file;
        public final long checksum;
        public final long date;
        public final int version;

        private CloudFile(java.io.File file, long checksum, long date, int version) {
            this.file = file;
            this.checksum = checksum;
            this.date = date;
            this.version = version;
        }

        public static CloudFile newInstance(java.io.File file, long checksum, long date, int version) {
            return new CloudFile(file, checksum, date, version);
        }
    }
}

