/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.charting;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.JXLayer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.RealTimeStockMonitor;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.currency.Currency;
import org.yccheok.jstock.file.UserDataDirectory;
import org.yccheok.jstock.file.UserDataFile;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.PortfolioManagementJPanel;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.charting.InvestmentFlowLayerUI;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.portfolio.Activities;
import org.yccheok.jstock.portfolio.Activity;
import org.yccheok.jstock.portfolio.ActivitySummary;
import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.Dividend;
import org.yccheok.jstock.portfolio.DividendSummary;
import org.yccheok.jstock.portfolio.PortfolioRealTimeInfo;
import org.yccheok.jstock.portfolio.Transaction;
import org.yccheok.jstock.portfolio.TransactionSummary;

public class InvestmentFlowChartJDialog
extends JDialog
implements Observer<RealTimeStockMonitor, RealTimeStockMonitor.Result> {
    private final List<StockInfo> stockInfos = new ArrayList<StockInfo>();
    private ActivitySummary investSummary = new ActivitySummary();
    private ActivitySummary ROISummary = new ActivitySummary();
    private volatile TimeSeries ROITimeSeries = null;
    private double totalROIValue = 0.0;
    private double totalInvestValue = 0.0;
    private ChartPanel chartPanel;
    private final PortfolioManagementJPanel portfolioManagementJPanel;
    private RealTimeStockMonitor realTimeStockMonitor;
    private final Map<Code, Double> codeToPrice = new ConcurrentHashMap<Code, Double>();
    private volatile boolean finishLookUpPrice = false;
    private final Set<Code> lookUpCodes = new HashSet<Code>();
    private InvestmentFlowLayerUI<ChartPanel> investmentFlowLayerUI;
    private JXLayer<ChartPanel> layer;
    private static final Log log = LogFactory.getLog(InvestmentFlowChartJDialog.class);
    private final JComboBox jComboBox1 = new JComboBox();
    private JPanel jPanel1;
    private JPanel jPanel2;

    public InvestmentFlowChartJDialog(Frame parent, boolean modal, PortfolioManagementJPanel portfolioManagementJPanel) {
        super(parent, modal);
        this.initComponents();
        this.portfolioManagementJPanel = portfolioManagementJPanel;
        this.initJComboBox();
        this.initRealTimeStockMonitor();
        JFreeChart freeChart = this.createChart();
        org.yccheok.jstock.charting.Utils.applyChartTheme(freeChart);
        this.chartPanel = new ChartPanel(freeChart, true, true, true, true, true);
        this.chartPanel.setFocusable(true);
        this.chartPanel.requestFocus();
        this.layer = new JXLayer((Component)this.chartPanel);
        this.investmentFlowLayerUI = new InvestmentFlowLayerUI(this);
        this.layer.setUI(this.investmentFlowLayerUI);
        this.getContentPane().add((Component)this.layer, "Center");
        this.loadDimension();
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                InvestmentFlowChartJDialog.this.finishLookUpPrice = true;
                InvestmentFlowChartJDialog.this.investmentFlowLayerUI.setDirty(true);
            }
        }, 15000L);
        this.addChangeListener(this.chartPanel);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                InvestmentFlowChartJDialog.this.investmentFlowLayerUI.updateInvestPoint();
                InvestmentFlowChartJDialog.this.investmentFlowLayerUI.updateROIPoint();
            }
        });
    }

    private void addChangeListener(ChartPanel chartPanel) {
        chartPanel.getChart().addChangeListener(new ChartChangeListener(){

            public void chartChanged(ChartChangeEvent event) {
                if (event.getType() == ChartChangeEventType.GENERAL) {
                    InvestmentFlowChartJDialog.this.investmentFlowLayerUI.updateInvestPoint();
                    InvestmentFlowChartJDialog.this.investmentFlowLayerUI.updateROIPoint();
                }
            }
        });
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("InvestmentFlowChartJDialog_Title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                InvestmentFlowChartJDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(0, 5));
        this.jPanel2.setLayout(new BorderLayout());
        this.jComboBox1.setModel(this.getComboBoxModel());
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InvestmentFlowChartJDialog.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.jComboBox1, "East");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.getContentPane().add((Component)this.jPanel1, "East");
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.saveDimension();
        this.initRealTimeStockMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jComboBox1ActionPerformed(ActionEvent evt) {
        JComboBox jComboBox = this.jComboBox1;
        synchronized (jComboBox) {
            JFreeChart freeChart = this.createChart();
            org.yccheok.jstock.charting.Utils.applyChartTheme(freeChart);
            this.getContentPane().remove((Component)this.layer);
            this.chartPanel = new ChartPanel(freeChart, true, true, true, true, true);
            this.layer = new JXLayer((Component)this.chartPanel);
            this.investmentFlowLayerUI = new InvestmentFlowLayerUI(this);
            this.layer.setUI(this.investmentFlowLayerUI);
            this.getContentPane().add((Component)this.layer, "Center");
            this.getContentPane().invalidate();
            this.getContentPane().validate();
            this.chartPanel.setFocusable(true);
            this.chartPanel.requestFocus();
            this.addChangeListener(this.chartPanel);
            Dimension d = this.chartPanel.getSize();
            this.chartPanel.setPreferredSize(d);
            this.pack();
        }
    }

    public void selectNextJComboBoxSelection() {
        int index = this.jComboBox1.getSelectedIndex();
        if (++index >= this.jComboBox1.getItemCount()) {
            return;
        }
        this.jComboBox1.setSelectedIndex(index);
    }

    public void selectPreviousJComboBoxSelection() {
        int index = this.jComboBox1.getSelectedIndex();
        if (--index < 0) {
            return;
        }
        this.jComboBox1.setSelectedIndex(index);
    }

    private void saveDimension() {
        Utils.toXML((Object)this.getSize(), UserDataDirectory.Config.get() + UserDataFile.CashFlowChartJDialogXml.get());
    }

    private void loadDimension() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension = Utils.fromXML(Dimension.class, UserDataDirectory.Config.get() + UserDataFile.CashFlowChartJDialogXml.get());
        if (dimension != null) {
            this.setBounds((screenSize.width - (int)dimension.getWidth()) / 2, (screenSize.height - (int)dimension.getHeight()) / 2, (int)dimension.getWidth(), (int)dimension.getHeight());
        } else {
            this.setBounds((screenSize.width - 750) / 2, (screenSize.height - 500) / 2, 750, 500);
        }
    }

    private void updateROITimeSeries() {
        Currency localCurrency = org.yccheok.jstock.portfolio.Utils.getLocalCurrency();
        boolean noCodeAddedToMonitor = this.realTimeStockMonitor.isEmpty();
        ArrayList<Code> codesNeedToAddToRealTimeStockMonitor = new ArrayList<Code>();
        ActivitySummary _ROISummary = this.ROISummary;
        TimeSeries _ROITimeSeries = this.ROITimeSeries;
        double _totalROIValue = 0.0;
        int count = _ROISummary.size();
        for (int i = 0; i < count; ++i) {
            Activities activities = _ROISummary.get(i);
            double amount = 0.0;
            int count2 = activities.size();
            for (int j = 0; j < count2; ++j) {
                Activity activity = activities.get(j);
                Activity.Type type = activity.getType();
                StockInfo stockInfo = (StockInfo)activity.get(Activity.Param.StockInfo);
                double exchangeRate = org.yccheok.jstock.portfolio.Utils.getExchangeRate(this.portfolioManagementJPanel.getPortfolioRealTimeInfo(), localCurrency, stockInfo.code);
                if (type == Activity.Type.Buy) {
                    Double price;
                    double quantity = (Double)activity.get(Activity.Param.Quantity);
                    if (noCodeAddedToMonitor) {
                        codesNeedToAddToRealTimeStockMonitor.add(stockInfo.code);
                        double lastPrice = this.portfolioManagementJPanel.getStockPrice(stockInfo.code);
                        if (lastPrice != 0.0) {
                            this.codeToPrice.put(stockInfo.code, lastPrice);
                        } else {
                            this.lookUpCodes.add(stockInfo.code);
                        }
                    }
                    if ((price = this.codeToPrice.get(stockInfo.code)) == null) continue;
                    amount += price * quantity * exchangeRate;
                    continue;
                }
                if (type == Activity.Type.Sell) {
                    amount += activity.getAmount() * exchangeRate;
                    continue;
                }
                if (type == Activity.Type.Dividend) {
                    double dividend = activity.getAmount() * exchangeRate;
                    Currency stockCurrency = org.yccheok.jstock.portfolio.Utils.getStockCurrency(this.portfolioManagementJPanel.getPortfolioRealTimeInfo(), stockInfo.code);
                    if (stockCurrency.isGBX() || stockCurrency.isZAC()) {
                        dividend *= 100.0;
                    }
                    amount += dividend;
                    continue;
                }
                assert (false);
            }
            SimpleDate date = activities.getDate();
            Date d = date.getTime();
            _ROITimeSeries.addOrUpdate((RegularTimePeriod)new Day(d), _totalROIValue += amount);
        }
        this.totalROIValue = _totalROIValue;
        if (noCodeAddedToMonitor) {
            for (Code code : codesNeedToAddToRealTimeStockMonitor) {
                this.realTimeStockMonitor.addStockCode(code);
            }
            this.realTimeStockMonitor.startNewThreadsIfNecessary();
            this.realTimeStockMonitor.refresh();
            if (this.lookUpCodes.isEmpty()) {
                this.finishLookUpPrice = true;
            }
        }
    }

    public PortfolioRealTimeInfo getPortfolioRealTimeInfo() {
        return this.portfolioManagementJPanel.getPortfolioRealTimeInfo();
    }

    private XYDataset createInvestDataset() {
        Currency localCurrency = org.yccheok.jstock.portfolio.Utils.getLocalCurrency();
        TimeSeries series = new TimeSeries((Comparable)((Object)GUIBundle.getString("InvestmentFlowChartJDialog_Invest")));
        this.totalInvestValue = 0.0;
        int count = this.investSummary.size();
        for (int i = 0; i < count; ++i) {
            Activities activities = this.investSummary.get(i);
            double amount = 0.0;
            int count2 = activities.size();
            for (int j = 0; j < count2; ++j) {
                Activity activity = activities.get(j);
                Activity.Type type = activity.getType();
                StockInfo stockInfo = (StockInfo)activity.get(Activity.Param.StockInfo);
                double exchangeRate = org.yccheok.jstock.portfolio.Utils.getExchangeRate(this.portfolioManagementJPanel.getPortfolioRealTimeInfo(), localCurrency, stockInfo.code);
                if (type == Activity.Type.Buy) {
                    amount += activity.getAmount() * exchangeRate;
                    continue;
                }
                if (type == Activity.Type.Sell) {
                    amount -= activity.getAmount() * exchangeRate;
                    continue;
                }
                assert (false);
            }
            this.totalInvestValue += amount;
            SimpleDate date = activities.getDate();
            Date d = date.getTime();
            series.add((RegularTimePeriod)new Day(d), this.totalInvestValue);
        }
        return new TimeSeriesCollection(series);
    }

    private synchronized JFreeChart createChart() {
        this.initSummaries(this.portfolioManagementJPanel);
        XYDataset priceData = this.createInvestDataset();
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)" ", (String)GUIBundle.getString("InvestmentFlowChartJDialog_Date"), (String)GUIBundle.getString("InvestmentFlowChartJDialog_Value"), (XYDataset)priceData, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        NumberAxis rangeAxis1 = (NumberAxis)plot.getRangeAxis();
        JStockOptions jStockOptions = JStock.instance().getJStockOptions();
        String currencySymbol = jStockOptions.getCurrencySymbol(jStockOptions.getCountry());
        DecimalFormat currencyFormat = new DecimalFormat("'" + currencySymbol.replace("'", "''") + "'#,##0");
        rangeAxis1.setNumberFormatOverride((NumberFormat)currencyFormat);
        plot.setRenderer(1, (XYItemRenderer)new StandardXYItemRenderer());
        this.ROITimeSeries = new TimeSeries((Comparable)((Object)GUIBundle.getString("InvestmentFlowChartJDialog_ReturnOfInvestment")));
        plot.setDataset(1, (XYDataset)new TimeSeriesCollection(this.ROITimeSeries));
        this.updateROITimeSeries();
        return chart;
    }

    private void initJComboBox() {
        List<TransactionSummary> transactionSummaries = this.portfolioManagementJPanel.getTransactionSummariesFromPortfolios();
        DividendSummary dividendSummary = this.portfolioManagementJPanel.getDividendSummary();
        for (TransactionSummary transactionSummary : transactionSummaries) {
            int count = transactionSummary.getChildCount();
            for (int i = 0; i < count; ++i) {
                Transaction transaction = (Transaction)transactionSummary.getChildAt(i);
                StockInfo stockInfo = transaction.getStockInfo();
                if (this.stockInfos.contains(stockInfo)) continue;
                this.stockInfos.add(stockInfo);
            }
        }
        int size = dividendSummary.size();
        for (int i = 0; i < size; ++i) {
            Dividend dividend = (Dividend)dividendSummary.get(i);
            StockInfo stockInfo = dividend.stockInfo;
            if (this.stockInfos.contains(stockInfo)) continue;
            this.stockInfos.add(stockInfo);
        }
        Collections.sort(this.stockInfos, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((StockInfo)o1).symbol.toString().compareTo(((StockInfo)o2).symbol.toString());
            }
        });
        for (StockInfo stockInfo : this.stockInfos) {
            this.jComboBox1.addItem(stockInfo.symbol.toString());
        }
    }

    private void initSummaries(PortfolioManagementJPanel portfolioManagementJPanel) {
        List<TransactionSummary> transactionSummaries = portfolioManagementJPanel.getTransactionSummariesFromPortfolios();
        DividendSummary dividendSummary = portfolioManagementJPanel.getDividendSummary();
        int selectedIndex = this.jComboBox1.getSelectedIndex();
        this.investSummary = new ActivitySummary();
        this.ROISummary = new ActivitySummary();
        boolean isFeeCalculationEnabled = JStock.instance().getJStockOptions().isFeeCalculationEnabled();
        for (TransactionSummary transactionSummary : transactionSummaries) {
            int count = transactionSummary.getChildCount();
            for (int i = 0; i < count; ++i) {
                Code code;
                Transaction transaction = (Transaction)transactionSummary.getChildAt(i);
                if (selectedIndex != 0 && !transaction.getStockInfo().code.equals(code = this.stockInfos.get((int)(selectedIndex - 1)).code)) continue;
                Contract.Type type = transaction.getType();
                StockInfo stockInfo = transaction.getStockInfo();
                if (type == Contract.Type.Buy) {
                    Activity activity = new Activity.Builder(Activity.Type.Buy, isFeeCalculationEnabled ? transaction.getNetTotal() : transaction.getTotal()).put(Activity.Param.StockInfo, stockInfo).put(Activity.Param.Quantity, transaction.getQuantity()).build();
                    this.ROISummary.add(transaction.getDate(), activity);
                    this.investSummary.add(transaction.getDate(), activity);
                    continue;
                }
                if (type == Contract.Type.Sell) {
                    Activity activity0 = new Activity.Builder(Activity.Type.Buy, isFeeCalculationEnabled ? transaction.getNetReferenceTotal() : transaction.getReferenceTotal()).put(Activity.Param.StockInfo, stockInfo).put(Activity.Param.Quantity, transaction.getQuantity()).build();
                    this.investSummary.add(transaction.getReferenceDate(), activity0);
                    Activity activity1 = new Activity.Builder(Activity.Type.Sell, isFeeCalculationEnabled ? transaction.getNetTotal() : transaction.getTotal()).put(Activity.Param.StockInfo, stockInfo).put(Activity.Param.Quantity, transaction.getQuantity()).build();
                    this.ROISummary.add(transaction.getDate(), activity1);
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported contract type " + (Object)((Object)type));
            }
        }
        int count = dividendSummary.size();
        for (int i = 0; i < count; ++i) {
            Code code;
            Dividend dividend = (Dividend)dividendSummary.get(i);
            if (selectedIndex != 0 && !dividend.stockInfo.code.equals(code = this.stockInfos.get((int)(selectedIndex - 1)).code)) continue;
            Activity activity = new Activity.Builder(Activity.Type.Dividend, dividend.amount).put(Activity.Param.StockInfo, dividend.stockInfo).build();
            this.ROISummary.add(dividend.date, activity);
        }
        this.investSummary.ensureSorted();
        this.ROISummary.ensureSorted();
    }

    private void initRealTimeStockMonitor() {
        final RealTimeStockMonitor oldRealTimeStockMonitor = this.realTimeStockMonitor;
        if (oldRealTimeStockMonitor != null) {
            Utils.getZoombiePool().execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Prepare to shut down " + oldRealTimeStockMonitor + "..."));
                    oldRealTimeStockMonitor.clearStockCodes();
                    oldRealTimeStockMonitor.dettachAll();
                    oldRealTimeStockMonitor.stop();
                    log.info((Object)("Shut down " + oldRealTimeStockMonitor + " peacefully."));
                }
            });
        }
        this.realTimeStockMonitor = new RealTimeStockMonitor(4, 20, JStock.instance().getJStockOptions().getScanningSpeed());
        this.realTimeStockMonitor.attach(this);
    }

    @Override
    public void update(RealTimeStockMonitor subject, RealTimeStockMonitor.Result result) {
        SwingUtilities.invokeLater(() -> this._update(subject, result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _update(RealTimeStockMonitor subject, RealTimeStockMonitor.Result result) {
        for (Stock stock : result.stocks) {
            this.codeToPrice.put(stock.code, stock.getLastPrice());
            this.lookUpCodes.remove(stock.code);
        }
        JComboBox jComboBox = this.jComboBox1;
        synchronized (jComboBox) {
            double beforeUpdateTotalROIValue = this.totalROIValue;
            this.updateROITimeSeries();
            if (this.totalROIValue != beforeUpdateTotalROIValue) {
                this.investmentFlowLayerUI.updateInvestPoint();
                this.investmentFlowLayerUI.updateROIPoint();
            }
        }
        if (this.lookUpCodes.isEmpty()) {
            this.finishLookUpPrice = true;
            this.investmentFlowLayerUI.setDirty(true);
        }
    }

    public String getCurrentSelectedString() {
        if (this.jComboBox1.getSelectedIndex() == 0) {
            return "";
        }
        return this.jComboBox1.getSelectedItem().toString();
    }

    public double getTotalInvestValue() {
        return this.totalInvestValue;
    }

    public double getTotalROIValue() {
        return this.totalROIValue;
    }

    public boolean isFinishLookUpPrice() {
        return this.finishLookUpPrice;
    }

    public double getStockPrice(Code code) {
        Double value = this.codeToPrice.get(code);
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public Activities getInvestActivities(int index) {
        return this.investSummary.get(index);
    }

    public Activities getROIActivities(int index) {
        return this.ROISummary.get(index);
    }

    private ComboBoxModel getComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{GUIBundle.getString("InvestmentFlowChartJDialog_AllStock(s)")});
    }
}

