/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.table;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.gui.BoundsPopupMenuListener;

public class StockInfoEditor
extends DefaultCellEditor {
    private final JComboBox comboBox = (JComboBox)this.getComponent();
    private final List<StockInfo> stockInfos;

    public StockInfoEditor(List<StockInfo> stockInfos) {
        super(new JComboBox());
        this.stockInfos = new ArrayList<StockInfo>(stockInfos);
        Collections.sort(this.stockInfos, new Comparator<StockInfo>(){

            @Override
            public int compare(StockInfo o1, StockInfo o2) {
                return o1.symbol.toString().compareTo(o2.symbol.toString());
            }
        });
        for (StockInfo stockInfo : this.stockInfos) {
            this.comboBox.addItem(stockInfo.symbol);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComboBox _comboBox = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        StockInfo stockInfo = (StockInfo)value;
        _comboBox.setSelectedItem(stockInfo.symbol);
        BoundsPopupMenuListener listener = new BoundsPopupMenuListener(true, false);
        _comboBox.addPopupMenuListener(listener);
        return _comboBox;
    }

    @Override
    public Object getCellEditorValue() {
        int index = this.comboBox.getSelectedIndex();
        if (index >= this.stockInfos.size() || index < 0) {
            return null;
        }
        return this.stockInfos.get(index);
    }
}

