/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.PauseTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.trading.CreateOrderDlg;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.gui.trading.Portfolio;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.OpenPosition;
import org.yccheok.jstock.trading.Utils;
import org.yccheok.jstock.trading.api.Instrument;
import org.yccheok.jstock.trading.api.OrderManager;

public class PositionsTable {
    private static final Log log = LogFactory.getLog(PositionsTable.class);
    private static final PositionsTable INSTANCE = new PositionsTable();
    private TableView<OpenPosition> posTable;
    private ObservableList<OpenPosition> posList;
    private TableColumn<OpenPosition, OpenPosition.SymbolUrl> symbolCol;
    private final ObjectProperty<List<? extends OpenPosition>> recentlyAdded = new SimpleObjectProperty();
    private boolean isChangeListenerSet = false;

    private PositionsTable() {
    }

    public static PositionsTable getInstance() {
        return INSTANCE;
    }

    public ObservableList<OpenPosition> getPosList() {
        return this.posList;
    }

    private void setChangeListener() {
        Duration timeToGetOld = Duration.seconds((double)5.0);
        this.posTable.getItems().addListener(change -> {
            while (change.next()) {
                if (!change.wasAdded()) continue;
                List addedList = change.getAddedSubList();
                ArrayList newList = new ArrayList();
                newList.addAll(addedList);
                this.recentlyAdded.set(newList);
                PauseTransition agingTime = new PauseTransition(timeToGetOld);
                agingTime.setOnFinished(event -> {
                    if (this.recentlyAdded.get() == newList) {
                        this.recentlyAdded.set(null);
                    }
                });
                agingTime.play();
            }
        });
    }

    private void setRowContextMenu() {
        this.posTable.setRowFactory((Callback)new Callback<TableView<OpenPosition>, TableRow<OpenPosition>>(){

            public TableRow<OpenPosition> call(TableView<OpenPosition> tableView) {
                TableRow<OpenPosition> row = new TableRow<OpenPosition>(){
                    private final BooleanBinding itemIsNew;
                    {
                        this.itemIsNew = Bindings.createBooleanBinding(() -> {
                            if (this.itemProperty() != null && this.itemProperty().get() != null && PositionsTable.this.recentlyAdded.get() != null && ((List)PositionsTable.this.recentlyAdded.get()).contains(this.itemProperty().get())) {
                                return true;
                            }
                            return false;
                        }, (Observable[])new Observable[]{this.itemProperty(), PositionsTable.this.recentlyAdded});
                        this.itemIsNew.addListener((obs, oldVal, newVal) -> this.pseudoClassStateChanged(GUIUtils.newRow, (boolean)newVal));
                    }
                };
                ContextMenu rowMenu = new ContextMenu();
                Label buyLbl = new Label(DriveWealthBundle.getString("Buy"));
                buyLbl.setPrefWidth(40.0);
                MenuItem buyItem = new MenuItem(null, (Node)buyLbl);
                buyItem.setOnAction((EventHandler)new EventHandler<ActionEvent>((TableRow)row){
                    final /* synthetic */ TableRow val$row;
                    {
                        this.val$row = tableRow;
                    }

                    public void handle(ActionEvent event) {
                        OpenPosition pos = (OpenPosition)this.val$row.getItem();
                        CreateOrderDlg dlg = new CreateOrderDlg(pos, OrderManager.OrderSide.BUY);
                        dlg.initDlgAndWait();
                    }
                });
                Label sellLbl = new Label(DriveWealthBundle.getString("Sell"));
                sellLbl.setPrefWidth(40.0);
                MenuItem sellItem = new MenuItem(null, (Node)sellLbl);
                sellItem.setOnAction((EventHandler)new EventHandler<ActionEvent>((TableRow)row){
                    final /* synthetic */ TableRow val$row;
                    {
                        this.val$row = tableRow;
                    }

                    public void handle(ActionEvent event) {
                        OpenPosition pos = (OpenPosition)this.val$row.getItem();
                        CreateOrderDlg dlg = new CreateOrderDlg(pos, OrderManager.OrderSide.SELL);
                        dlg.initDlgAndWait();
                    }
                });
                rowMenu.getItems().addAll((Object[])new MenuItem[]{buyItem, new SeparatorMenuItem(), sellItem});
                row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)row.itemProperty())).then((Object)rowMenu).otherwise((Object)null));
                return row;
            }
        });
    }

    private void symbolColComparator() {
        class SymbolComparator
        implements Comparator<OpenPosition.SymbolUrl> {
            SymbolComparator() {
            }

            @Override
            public int compare(OpenPosition.SymbolUrl o1, OpenPosition.SymbolUrl o2) {
                return o1.getSymbol().compareTo(o2.getSymbol());
            }
        }
        this.symbolCol.setComparator((Comparator)new SymbolComparator());
    }

    public TableView show() {
        this.posTable = new TableView();
        this.symbolCol = new TableColumn(DriveWealthBundle.getString("Symbol"));
        this.symbolCol.setCellValueFactory((Callback)new PropertyValueFactory("symbolObj"));
        this.symbolCol.setCellFactory(col -> new SymbolCell());
        this.symbolCol.getStyleClass().add((Object)"left");
        this.symbolColComparator();
        TableColumn nameCol = new TableColumn(DriveWealthBundle.getString("Company"));
        nameCol.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        nameCol.getStyleClass().add((Object)"left");
        TableColumn unitsCol = new TableColumn(DriveWealthBundle.getString("Qty"));
        unitsCol.setCellValueFactory((Callback)new PropertyValueFactory("openQty"));
        unitsCol.setCellFactory(col -> new OpenQtyCell());
        unitsCol.getStyleClass().add((Object)"right");
        TableColumn avgPriceCol = new TableColumn(DriveWealthBundle.getString("Avg_purchase_price"));
        avgPriceCol.setCellValueFactory((Callback)new PropertyValueFactory("averagePrice"));
        avgPriceCol.setCellFactory(col -> new AvgPriceCell());
        avgPriceCol.getStyleClass().add((Object)"right");
        TableColumn mktPriceCol = new TableColumn(DriveWealthBundle.getString("Current_price"));
        mktPriceCol.setCellValueFactory((Callback)new PropertyValueFactory("marketPrice"));
        mktPriceCol.setCellFactory(col -> new MarketPriceCell());
        mktPriceCol.getStyleClass().add((Object)"right");
        TableColumn costCol = new TableColumn(DriveWealthBundle.getString("Purchase_value"));
        costCol.setCellValueFactory((Callback)new PropertyValueFactory("costBasis"));
        costCol.setCellFactory(col -> new CostBasisCell());
        costCol.getStyleClass().add((Object)"right");
        TableColumn mktValueCol = new TableColumn(DriveWealthBundle.getString("Current_value"));
        mktValueCol.setCellValueFactory((Callback)new PropertyValueFactory("marketValue"));
        mktValueCol.setCellFactory(col -> new MarketValueCell());
        mktValueCol.getStyleClass().add((Object)"right");
        TableColumn plCol = new TableColumn(DriveWealthBundle.getString("Gain_loss"));
        plCol.setCellValueFactory((Callback)new PropertyValueFactory("pl"));
        plCol.setCellFactory(col -> new PlCell());
        plCol.getStyleClass().add((Object)"right");
        TableColumn plPctCol = new TableColumn(DriveWealthBundle.getString("Gain_loss_percent"));
        plPctCol.setCellValueFactory((Callback)new PropertyValueFactory("plPct"));
        plPctCol.setCellFactory(col -> new PlPctCell());
        plPctCol.getStyleClass().add((Object)"right");
        TableColumn dayPlCol = new TableColumn(DriveWealthBundle.getString("Day_gain_loss"));
        dayPlCol.setCellValueFactory((Callback)new PropertyValueFactory("dayPl"));
        dayPlCol.setCellFactory(col -> new DayPlCell());
        dayPlCol.getStyleClass().add((Object)"right");
        TableColumn dayPlPctCol = new TableColumn(DriveWealthBundle.getString("Day_gain_loss_percent"));
        dayPlPctCol.setCellValueFactory((Callback)new PropertyValueFactory("dayPlPct"));
        dayPlPctCol.setCellFactory(col -> new DayPlPctCell());
        dayPlPctCol.getStyleClass().add((Object)"right");
        this.posTable.getColumns().setAll((Object[])new TableColumn[]{this.symbolCol, nameCol, unitsCol, avgPriceCol, costCol, mktPriceCol, mktValueCol, plCol, plPctCol, dayPlCol, dayPlPctCol});
        this.posTable.setEditable(false);
        this.posTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.posTable.setPlaceholder((Node)new Label());
        this.posTable.setTableMenuButtonVisible(true);
        this.setTableModel();
        return this.posTable;
    }

    public void setTableModel() {
        this.posList = FXCollections.observableArrayList();
        this.posTable.setItems(this.posList);
        this.posTable.setFixedCellSize(30.0);
        this.posTable.prefHeightProperty().unbind();
        this.posTable.prefHeightProperty().bind((ObservableValue)Bindings.size((ObservableList)this.posTable.getItems()).multiply(this.posTable.getFixedCellSize()).add(30.0));
        this.setRowContextMenu();
        this.isChangeListenerSet = false;
    }

    private void sortTable() {
        if (this.posTable.getSortOrder().isEmpty()) {
            this.symbolCol.setSortType(TableColumn.SortType.ASCENDING);
            this.posTable.getSortOrder().add(this.symbolCol);
        }
        this.posTable.sort();
    }

    public void initData(List<OpenPosition> positions, Map<String, Instrument> instruments) {
        OpenPosition oldSelect = (OpenPosition)this.posTable.getSelectionModel().getSelectedItem();
        String oldID = oldSelect != null ? oldSelect.getInstrumentID() : null;
        HashMap<String, OpenPosition> newPosMap = new HashMap<String, OpenPosition>();
        for (OpenPosition openPosition : positions) {
            newPosMap.put(openPosition.getInstrumentID(), openPosition);
        }
        HashMap<String, OpenPosition> posMap = new HashMap<String, OpenPosition>();
        for (Object pos : this.posList) {
            posMap.put(((OpenPosition)pos).getInstrumentID(), (OpenPosition)pos);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object pos : this.posList) {
            String id = ((OpenPosition)pos).getInstrumentID();
            if (newPosMap.containsKey(id)) {
                OpenPosition newPos = (OpenPosition)newPosMap.get(id);
                ((OpenPosition)pos).compareAndUpdate(newPos);
                continue;
            }
            arrayList.add(pos);
            posMap.remove(id);
        }
        if (!arrayList.isEmpty()) {
            this.posList.removeAll(arrayList);
        }
        ArrayList<OpenPosition> addedList = new ArrayList<OpenPosition>();
        for (OpenPosition pos : positions) {
            String id = pos.getInstrumentID();
            if (posMap.containsKey(id)) continue;
            addedList.add(pos);
            posMap.put(id, pos);
        }
        if (!addedList.isEmpty()) {
            this.posList.addAll(addedList);
        }
        if (!instruments.isEmpty()) {
            this.updateNameUrl(instruments);
        }
        this.sortTable();
        OpenPosition newSelect = null;
        for (OpenPosition pos : this.posList) {
            if (!pos.getInstrumentID().equals(oldID)) continue;
            newSelect = pos;
            break;
        }
        if (newSelect != null) {
            this.posTable.getSelectionModel().select(newSelect);
        }
        if (!this.isChangeListenerSet) {
            this.setChangeListener();
            this.isChangeListenerSet = true;
        }
    }

    public void updateNameUrl(Map<String, Instrument> instruments) {
        for (OpenPosition pos : this.posList) {
            String symbol = pos.getSymbol();
            if (!instruments.containsKey(symbol)) continue;
            Instrument ins = instruments.get(symbol);
            pos.setName(ins.name);
            pos.setUrlImage(ins.urlImage);
        }
    }

    public void updatePrices(Map<String, Double> marketPrices) {
        if (marketPrices == null || marketPrices.isEmpty()) {
            return;
        }
        for (OpenPosition pos : this.posList) {
            String symbol = pos.getSymbol();
            if (!marketPrices.containsKey(symbol)) continue;
            pos.updatePrice(marketPrices.get(symbol));
        }
    }

    private static class DayPlPctCell
    extends DoubleCell {
        @Override
        protected int comparePrevious() {
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return 0;
            }
            return ((OpenPosition)this.getTableRow().getItem()).diff.dayPlPctPty.get();
        }

        @Override
        protected void colorText(Double item) {
            this._colorText(item);
        }
    }

    private static class DayPlCell
    extends DoubleCell {
        @Override
        protected int comparePrevious() {
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return 0;
            }
            return ((OpenPosition)this.getTableRow().getItem()).diff.dayPlPty.get();
        }

        @Override
        protected void colorText(Double item) {
            this._colorText(item);
        }
    }

    private static class PlPctCell
    extends DoubleCell {
        @Override
        protected int comparePrevious() {
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return 0;
            }
            return ((OpenPosition)this.getTableRow().getItem()).diff.plPctPty.get();
        }

        @Override
        protected void colorText(Double item) {
            this._colorText(item);
        }
    }

    private static class PlCell
    extends DoubleCell {
        @Override
        protected int comparePrevious() {
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return 0;
            }
            return ((OpenPosition)this.getTableRow().getItem()).diff.plPty.get();
        }

        @Override
        protected void colorText(Double item) {
            this._colorText(item);
        }
    }

    private static class MarketValueCell
    extends DoubleCell {
        @Override
        protected int comparePrevious() {
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return 0;
            }
            return ((OpenPosition)this.getTableRow().getItem()).diff.marketValuePty.get();
        }
    }

    private static class MarketPriceCell
    extends DoubleCell {
        @Override
        protected int comparePrevious() {
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return 0;
            }
            return ((OpenPosition)this.getTableRow().getItem()).diff.marketPricePty.get();
        }
    }

    private static class CostBasisCell
    extends DoubleCell {
        @Override
        protected int comparePrevious() {
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return 0;
            }
            return ((OpenPosition)this.getTableRow().getItem()).diff.costBasisPty.get();
        }
    }

    private static class AvgPriceCell
    extends DoubleCell {
        @Override
        protected int comparePrevious() {
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return 0;
            }
            return ((OpenPosition)this.getTableRow().getItem()).diff.averagePricePty.get();
        }
    }

    private static class OpenQtyCell
    extends DoubleCell {
        @Override
        protected int comparePrevious() {
            if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                return 0;
            }
            return ((OpenPosition)this.getTableRow().getItem()).diff.openQtyPty.get();
        }

        @Override
        protected String formatDouble(Double item) {
            return Utils.formatNumber(item, 4);
        }
    }

    private static abstract class DoubleCell
    extends TableCell<OpenPosition, Double> {
        protected abstract int comparePrevious();

        protected void colorText(Double item) {
        }

        protected void _colorText(Double item) {
            this.getStyleClass().remove((Object)"profit-txt-color");
            this.getStyleClass().remove((Object)"loss-txt-color");
            int diff = Double.compare(item, 0.0);
            if (diff < 0) {
                this.getStyleClass().add((Object)"loss-txt-color");
            } else if (diff > 0) {
                this.getStyleClass().add((Object)"profit-txt-color");
            }
        }

        protected String formatDouble(Double item) {
            return Utils.monetaryFormat(item);
        }

        protected void updateItem(Double item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setText(null);
                this.setGraphic(null);
                return;
            }
            this.setText(this.formatDouble(item));
            this.colorText(item);
            this.pseudoClassStateChanged(GUIUtils.upCell, false);
            this.pseudoClassStateChanged(GUIUtils.downCell, false);
            int diff = this.comparePrevious();
            if (diff == 0) {
                return;
            }
            PseudoClass pClass = diff > 0 ? GUIUtils.upCell : GUIUtils.downCell;
            this.pseudoClassStateChanged(pClass, true);
            PauseTransition agingTime = new PauseTransition(Duration.seconds((double)2.0));
            agingTime.setOnFinished(event -> {
                this.pseudoClassStateChanged(GUIUtils.upCell, false);
                this.pseudoClassStateChanged(GUIUtils.downCell, false);
            });
            agingTime.play();
        }
    }

    private static class SymbolCell
    extends TableCell<OpenPosition, OpenPosition.SymbolUrl> {
        private final HBox hbox = new HBox();
        private final Label symLabel = new Label();
        private final ImageView imageView = new ImageView();

        public SymbolCell() {
            this.symLabel.setPrefWidth(70.0);
            this.imageView.setFitHeight(25.0);
            this.imageView.setFitWidth(25.0);
            this.hbox.setSpacing(10.0);
            this.hbox.setAlignment(Pos.CENTER_LEFT);
            this.hbox.getChildren().addAll((Object[])new Node[]{this.symLabel, this.imageView});
            this.setGraphic((Node)this.hbox);
        }

        protected void updateItem(OpenPosition.SymbolUrl item, boolean empty) {
            if (item != null) {
                String symbol = item.getSymbol();
                String url = item.getUrl();
                this.symLabel.setText(symbol);
                if (url != null && !url.isEmpty()) {
                    this.imageView.setImage(Portfolio.getInstance().getIcon(url));
                } else {
                    this.imageView.setImage(null);
                }
            }
        }
    }
}

