/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import javafx.util.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.controlsfx.control.Notifications;
import org.yccheok.jstock.gui.trading.CancelOrderDlg;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.Transaction;
import org.yccheok.jstock.trading.api.OrderManager;

public class TxnNotification {
    private static final Log log = LogFactory.getLog(TxnNotification.class);
    private static final TxnNotification INSTANCE = new TxnNotification();

    private TxnNotification() {
    }

    public static TxnNotification getInstance() {
        return INSTANCE;
    }

    public void show(List<Transaction> txnList) {
        if (txnList.isEmpty()) {
            return;
        }
        TableView tableView = new TableView();
        ObservableList list = FXCollections.observableArrayList();
        for (Transaction txn : txnList) {
            NotificationModel model = NotificationModel.builder(txn);
            list.add((Object)model);
        }
        tableView.setItems(list);
        TableColumn symbolCol = new TableColumn(DriveWealthBundle.getString("Symbol"));
        symbolCol.setCellValueFactory((Callback)new PropertyValueFactory("symbol"));
        symbolCol.setPrefWidth(80.0);
        symbolCol.setMinWidth(80.0);
        TableColumn descCol = new TableColumn(DriveWealthBundle.getString("Description"));
        descCol.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        descCol.setPrefWidth(250.0);
        descCol.setMinWidth(250.0);
        TableColumn statusCol = new TableColumn(DriveWealthBundle.getString("Status"));
        statusCol.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        statusCol.setPrefWidth(80.0);
        statusCol.setMinWidth(80.0);
        tableView.getColumns().setAll((Object[])new TableColumn[]{symbolCol, descCol, statusCol});
        tableView.setEditable(false);
        tableView.setFixedCellSize(24.0);
        tableView.prefHeightProperty().bind((ObservableValue)Bindings.size((ObservableList)tableView.getItems()).multiply(tableView.getFixedCellSize()).add(30));
        AnchorPane anchorPane = new AnchorPane(new Node[]{tableView});
        anchorPane.prefHeightProperty().bind((ObservableValue)tableView.prefHeightProperty());
        Notifications notification = Notifications.create().title(DriveWealthBundle.getString("Txn_notification")).text(null).graphic((Node)anchorPane).position(Pos.BOTTOM_RIGHT).hideAfter(Duration.minutes((double)1.0));
        notification.show();
    }

    public static class NotificationModel {
        private final SimpleStringProperty symbol;
        private final SimpleStringProperty description;
        private final SimpleStringProperty status;

        public NotificationModel(String sym, String desc, String stat) {
            this.symbol = new SimpleStringProperty(sym);
            this.description = new SimpleStringProperty(desc);
            this.status = new SimpleStringProperty(stat);
        }

        public static NotificationModel builder(Transaction txn) {
            String sym = txn.symbol;
            Double limitPrice = txn.limitPrice;
            Double stopPrice = txn.stopPrice;
            Double price = null;
            if (txn.orderType == OrderManager.OrderType.LIMIT) {
                price = limitPrice;
            } else if (txn.orderType == OrderManager.OrderType.STOP) {
                price = stopPrice;
            }
            String desc = CancelOrderDlg.orderDescription(txn.side.toString(), txn.orderType.toString(), txn.orderQty, price, txn.orderCashAmt);
            String stat = txn.orderStatus.toString();
            return new NotificationModel(sym, desc, stat);
        }

        public final String getSymbol() {
            return this.symbol.get();
        }

        public final void setSymbol(String v) {
            this.symbol.set(v);
        }

        public SimpleStringProperty symbolProperty() {
            return this.symbol;
        }

        public final String getDescription() {
            return this.description.get();
        }

        public final void setDescription(String v) {
            this.description.set(v);
        }

        public SimpleStringProperty descriptionProperty() {
            return this.description;
        }

        public final String getStatus() {
            return this.status.get();
        }

        public final void setStatus(String v) {
            this.status.set(v);
        }

        public SimpleStringProperty statusProperty() {
            return this.status;
        }
    }
}

