/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.portfolio.Activity;

public class Activities {
    private final List<Activity> activities = new ArrayList<Activity>();
    private final SimpleDate simpleDate;

    public Activities(SimpleDate simpleDate) {
        this.simpleDate = simpleDate;
    }

    public void ensureSorted() {
        Collections.sort(this.activities, new Comparator<Activity>(){

            @Override
            public int compare(Activity o1, Activity o2) {
                return o1.getType().compareTo(o2.getType());
            }
        });
    }

    public SimpleDate getDate() {
        return this.simpleDate;
    }

    public boolean add(Activity activity) {
        boolean status = this.activities.add(activity);
        return status;
    }

    public int size() {
        return this.activities.size();
    }

    public Activity get(int index) {
        return this.activities.get(index);
    }

    public List<Activity.Type> getTypes() {
        ArrayList<Activity.Type> types = new ArrayList<Activity.Type>();
        for (Activity activity : this.activities) {
            if (types.contains((Object)activity.getType())) continue;
            types.add(activity.getType());
        }
        Collections.sort(types);
        return types;
    }
}

