/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading.api;

import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.trading.AccountSummary;
import org.yccheok.jstock.trading.OpenPosition;
import org.yccheok.jstock.trading.PendingOrder;
import org.yccheok.jstock.trading.Transaction;
import org.yccheok.jstock.trading.api.OrderManager;

public class AccountBlotter {
    private final Map<String, Object> resultMap;
    private List<OpenPosition> posList = null;
    private List<PendingOrder> ordList = null;
    private List<Transaction> txnList = null;
    private AccountSummary accModel = null;
    private Set symbolsSet = null;
    private static final Log log = LogFactory.getLog(AccountBlotter.class);

    public AccountBlotter(Map<String, Object> params) {
        this.resultMap = params;
    }

    public List<OpenPosition> getPositions() {
        if (this.posList != null) {
            return this.posList;
        }
        this.posList = new ArrayList<OpenPosition>();
        LinkedTreeMap equity = (LinkedTreeMap)this.resultMap.get("equity");
        List positions = (List)equity.get((Object)"equityPositions");
        for (LinkedTreeMap pos : positions) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("name", "");
            data.put("urlImage", "");
            data.put("symbol", pos.get((Object)"symbol"));
            data.put("instrumentID", pos.get((Object)"instrumentID"));
            data.put("openQty", pos.get((Object)"openQty"));
            data.put("tradingQty", pos.get((Object)"availableForTradingQty"));
            data.put("averagePrice", pos.get((Object)"avgPrice"));
            data.put("costBasis", pos.get((Object)"costBasis"));
            data.put("marketPrice", pos.get((Object)"mktPrice"));
            data.put("marketValue", pos.get((Object)"marketValue"));
            data.put("priorClose", pos.get((Object)"priorClose"));
            data.put("unrealizedPL", pos.get((Object)"unrealizedPL"));
            data.put("unrealizedDayPL", pos.get((Object)"unrealizedDayPL"));
            data.put("unrealizedDayPLPercent", pos.get((Object)"unrealizedDayPLPercent"));
            this.posList.add(new OpenPosition(data));
        }
        return this.posList;
    }

    public List<PendingOrder> getOrders() {
        if (this.ordList != null) {
            return this.ordList;
        }
        this.ordList = new ArrayList<PendingOrder>();
        List orders = (List)this.resultMap.get("orders");
        for (LinkedTreeMap ord : orders) {
            OrderManager.OrderType ordType;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("name", "");
            data.put("urlImage", "");
            data.put("marketPrice", 0.0);
            data.put("orderID", ord.get((Object)"orderID"));
            data.put("symbol", ord.get((Object)"symbol"));
            data.put("orderQty", ord.get((Object)"orderQty"));
            data.put("cumQty", ord.get((Object)"cumQty"));
            data.put("orderCashAmt", ord.get((Object)"orderCashAmt"));
            String side = ord.get((Object)"side").toString();
            OrderManager.OrderSide ordSide = side.equals("B") ? OrderManager.OrderSide.BUY : OrderManager.OrderSide.SELL;
            data.put("side", (Object)ordSide);
            int type = Integer.parseInt(ord.get((Object)"orderType").toString());
            if (type == OrderManager.OrderType.LIMIT.value) {
                ordType = OrderManager.OrderType.LIMIT;
                data.put("limitPrice", ord.get((Object)"limitPrice"));
            } else if (type == OrderManager.OrderType.STOP.value) {
                ordType = OrderManager.OrderType.STOP;
                data.put("stopPrice", ord.get((Object)"stopPrice"));
            } else {
                ordType = OrderManager.OrderType.MARKET;
            }
            data.put("orderType", (Object)ordType);
            String status = ord.get((Object)"orderStatus").toString();
            OrderManager.OrdStatus ordStatus = status.equals(OrderManager.OrdStatus.NEW.value) ? OrderManager.OrdStatus.NEW : (status.equals(OrderManager.OrdStatus.PARTIAL_FILLED.value) ? OrderManager.OrdStatus.PARTIAL_FILLED : (status.equals(OrderManager.OrdStatus.FILLED.value) ? OrderManager.OrdStatus.FILLED : (status.equals(OrderManager.OrdStatus.CANCELED.value) ? OrderManager.OrdStatus.CANCELED : (status.equals(OrderManager.OrdStatus.REJECTED.value) ? OrderManager.OrdStatus.REJECTED : null))));
            data.put("orderStatus", (Object)ordStatus);
            this.ordList.add(new PendingOrder(data));
        }
        return this.ordList;
    }

    public List<Transaction> getTransactions() {
        if (this.txnList != null) {
            return this.txnList;
        }
        this.txnList = new ArrayList<Transaction>();
        List txns = (List)this.resultMap.get("transactions");
        for (LinkedTreeMap txn : txns) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Map.Entry entry : txn.entrySet()) {
                data.put((String)entry.getKey(), entry.getValue());
            }
            this.txnList.add(new Transaction(data));
        }
        Collections.sort(this.txnList, new Comparator<Transaction>(){

            @Override
            public int compare(Transaction t1, Transaction t2) {
                Date date2;
                Date date1 = t1.updatedWhen != null ? t1.updatedWhen : t1.createdWhen;
                Date date = date2 = t2.updatedWhen != null ? t2.updatedWhen : t2.createdWhen;
                if (date1.before(date2)) {
                    return -1;
                }
                if (date1.after(date2)) {
                    return 1;
                }
                return 0;
            }
        });
        return this.txnList;
    }

    public AccountSummary getAccSummary() {
        LinkedTreeMap equity = (LinkedTreeMap)this.resultMap.get("equity");
        LinkedTreeMap balance = (LinkedTreeMap)this.resultMap.get("cash");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("equity", equity.get((Object)"equityValue"));
        params.put("cashBalance", balance.get((Object)"cashBalance"));
        params.put("cashForTrade", balance.get((Object)"cashAvailableForTrade"));
        params.put("cashForWithdraw", balance.get((Object)"cashAvailableForWithdrawal"));
        double totalUnrealizedPL = 0.0;
        for (OpenPosition pos : this.getPositions()) {
            totalUnrealizedPL += pos.getPl().doubleValue();
        }
        params.put("totalUnrealizedPL", totalUnrealizedPL);
        this.accModel = new AccountSummary(params);
        return this.accModel;
    }

    public Set getSymbols() {
        if (this.symbolsSet != null) {
            return this.symbolsSet;
        }
        this.symbolsSet = new HashSet();
        for (OpenPosition pos : this.getPositions()) {
            this.symbolsSet.add(pos.getSymbol());
        }
        for (PendingOrder ord : this.getOrders()) {
            this.symbolsSet.add(ord.getSymbol());
        }
        return this.symbolsSet;
    }

    public double getAvailableTradingQty(String instrumentID) {
        double qty = 0.0;
        for (OpenPosition pos : this.getPositions()) {
            if (!pos.getInstrumentID().equals(instrumentID)) continue;
            qty = pos.getTradingQty();
            break;
        }
        return qty;
    }

    public double getTradingBalance() {
        LinkedTreeMap cash = (LinkedTreeMap)this.resultMap.get("cash");
        double balance = (Double)cash.get((Object)"cashAvailableForTrade");
        return balance;
    }
}

