/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.stream.events;

import com.bea.xml.stream.events.NamedEvent;
import com.bea.xml.stream.util.EmptyIterator;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;

public class EndElementEvent
extends NamedEvent
implements EndElement {
    private List outOfScopeNamespaces;

    public EndElementEvent() {
        this.init();
    }

    public EndElementEvent(QName name) {
        super(name);
        this.init();
    }

    protected void init() {
        this.setEventType(2);
    }

    public Iterator getNamespaces() {
        if (this.outOfScopeNamespaces == null) {
            return EmptyIterator.emptyIterator;
        }
        return this.outOfScopeNamespaces.iterator();
    }

    public void addNamespace(Namespace n) {
        if (this.outOfScopeNamespaces == null) {
            this.outOfScopeNamespaces = new ArrayList();
        }
        this.outOfScopeNamespaces.add(n);
    }

    public void reset() {
        if (this.outOfScopeNamespaces != null) {
            this.outOfScopeNamespaces.clear();
        }
    }

    public String toString() {
        String value = "</" + this.nameAsString();
        Iterator ni = this.getNamespaces();
        while (ni.hasNext()) {
            value = value + " " + ni.next().toString();
        }
        value = value + ">";
        return value;
    }

    protected void doWriteAsEncodedUnicode(Writer writer) throws IOException {
        writer.write("</");
        QName name = this.getName();
        String prefix = name.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            writer.write(prefix);
            writer.write(58);
        }
        writer.write(name.getLocalPart());
        writer.write(62);
    }
}

