/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.feed4j;

import it.sauronsoftware.feed4j.Constants;
import it.sauronsoftware.feed4j.TypeAbstract;
import it.sauronsoftware.feed4j.bean.Feed;
import it.sauronsoftware.feed4j.bean.FeedHeader;
import it.sauronsoftware.feed4j.bean.FeedImage;
import it.sauronsoftware.feed4j.bean.FeedItem;
import it.sauronsoftware.feed4j.bean.RawElement;
import it.sauronsoftware.feed4j.bean.RawNode;
import it.sauronsoftware.feed4j.html.HTMLFragmentHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;

class TypeRSS_1_0
extends TypeAbstract {
    TypeRSS_1_0() {
    }

    public static Feed feed(URL source, Document document) {
        Element root = document.getRootElement();
        Feed feed = new Feed();
        FeedHeader header = new FeedHeader();
        header.setURL(source);
        Element channel = null;
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            Element aux = (Element)i.next();
            String nsuri = aux.getNamespaceURI();
            if (!nsuri.equals("http://purl.org/rss/1.0/")) continue;
            String name = aux.getName();
            if (name.equals("item")) {
                FeedItem item = TypeRSS_1_0.handleItem(source, aux);
                if (item == null) continue;
                feed.addItem(item);
                continue;
            }
            if (channel != null || !name.equals("channel")) continue;
            channel = aux;
        }
        if (channel != null) {
            TypeRSS_1_0.populateRawElement((RawElement)header, channel);
            int i2 = 0;
            while (i2 < header.getNodeCount()) {
                RawNode node = header.getNode(i2);
                if (node instanceof RawElement) {
                    FeedImage image;
                    RawElement element = (RawElement)node;
                    String ensuri = element.getNamespaceURI();
                    String ename = element.getName();
                    String evalue = element.getValue();
                    if (evalue != null) {
                        if (ensuri.equals("http://purl.org/rss/1.0/")) {
                            if (ename.equals("title")) {
                                header.setTitle(evalue);
                            } else if (ename.equals("description")) {
                                header.setDescription(evalue);
                            } else if (ename.equals("link")) {
                                try {
                                    header.setLink(new URL(evalue));
                                }
                                catch (MalformedURLException malformedURLException) {}
                            }
                        } else if (ensuri.equals("http://purl.org/dc/elements/1.1/") && evalue != null) {
                            if (ename.equals("date")) {
                                try {
                                    header.setPubDate(Constants.ISO_8601_DATE_FORMAT.parse(evalue));
                                }
                                catch (ParseException parseException) {}
                            } else if (ename.equals("language") && TypeRSS_1_0.isValidLanguageCode(evalue)) {
                                header.setLanguage(evalue);
                            }
                        }
                    } else if (ensuri.equals("http://purl.org/rss/1.0/") && ename.equals("image") && (image = TypeRSS_1_0.handleImage(element)) != null) {
                        header.setImage(image);
                    }
                }
                ++i2;
            }
        }
        RawElement[] rawimages = header.getElements("http://purl.org/rss/1.0/", "image");
        int i3 = 0;
        while (i3 < rawimages.length) {
            header.removeNode(rawimages[i3]);
            ++i3;
        }
        feed.setHeader(header);
        return feed;
    }

    private static FeedItem handleItem(URL source, Element el) {
        FeedItem item = new FeedItem();
        TypeRSS_1_0.populateRawElement((RawElement)item, el);
        String rssGuid = item.getAttributeValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
        int i = 0;
        while (i < item.getNodeCount()) {
            RawNode node = item.getNode(i);
            if (node instanceof RawElement) {
                RawElement element = (RawElement)node;
                String ensuri = element.getNamespaceURI();
                String ename = element.getName();
                String evalue = element.getValue();
                if (evalue != null) {
                    if (ensuri.equals("http://purl.org/rss/1.0/")) {
                        if (ename.equals("title")) {
                            item.setTitle(evalue);
                        } else if (ename.equals("link")) {
                            try {
                                item.setLink(new URL(evalue));
                            }
                            catch (MalformedURLException malformedURLException) {}
                        } else if (ename.equals("description")) {
                            item.setDescriptionAsText(evalue);
                            item.setDescriptionAsHTML(HTMLFragmentHelper.fromTextPlainToHTML(evalue));
                        }
                    } else if (ensuri.equals("http://purl.org/dc/elements/1.1/") && evalue != null && ename.equals("date")) {
                        try {
                            item.setPubDate(Constants.ISO_8601_DATE_FORMAT.parse(evalue));
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
        if (item.getTitle() == null || item.getLink() == null) {
            return null;
        }
        if (rssGuid == null) {
            rssGuid = item.getLink().toExternalForm();
        }
        item.setGUID(TypeRSS_1_0.buildGUID(source.hashCode(), rssGuid.hashCode()));
        return item;
    }

    private static FeedImage handleImage(RawElement rawImage) {
        FeedImage image = new FeedImage();
        TypeRSS_1_0.populateRawElement((RawElement)image, rawImage);
        String value = image.getElementValue("http://purl.org/rss/1.0/", "url");
        if (value != null) {
            try {
                image.setURL(new URL(value));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if ((value = image.getElementValue("http://purl.org/rss/1.0/", "title")) != null) {
            image.setDescription(value);
        }
        if (image.getURL() == null) {
            return null;
        }
        return image;
    }
}

