/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.encryption.pbe;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.jasypt.encryption.pbe.PBEByteEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.exceptions.AlreadyInitializedException;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.normalization.Normalizer;
import org.jasypt.salt.RandomSaltGenerator;
import org.jasypt.salt.SaltGenerator;

public final class StandardPBEByteEncryptor
implements PBEByteEncryptor {
    public static final String DEFAULT_ALGORITHM = "PBEWithMD5AndDES";
    public static final int DEFAULT_KEY_OBTENTION_ITERATIONS = 1000;
    public static final int DEFAULT_SALT_SIZE_BYTES = 8;
    private String algorithm = "PBEWithMD5AndDES";
    private String providerName = null;
    private Provider provider = null;
    private String password = null;
    private int keyObtentionIterations = 1000;
    private SaltGenerator saltGenerator = null;
    private int saltSizeBytes = 8;
    private PBEConfig config = null;
    private boolean algorithmSet = false;
    private boolean passwordSet = false;
    private boolean iterationsSet = false;
    private boolean saltGeneratorSet = false;
    private boolean providerNameSet = false;
    private boolean providerSet = false;
    private boolean initialized = false;
    private SecretKey key = null;
    private Cipher encryptCipher = null;
    private Cipher decryptCipher = null;

    public synchronized void setConfig(PBEConfig config) {
        Validate.notNull((Object)config, (String)"Config cannot be set null");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.config = config;
    }

    public synchronized void setAlgorithm(String algorithm) {
        Validate.notEmpty((String)algorithm, (String)"Algorithm cannot be set empty");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.algorithm = algorithm;
        this.algorithmSet = true;
    }

    public synchronized void setPassword(String password) {
        Validate.notEmpty((String)password, (String)"Password cannot be set empty");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.password = password;
        this.passwordSet = true;
    }

    public synchronized void setKeyObtentionIterations(int keyObtentionIterations) {
        Validate.isTrue((keyObtentionIterations > 0 ? 1 : 0) != 0, (String)"Number of iterations for key obtention must be greater than zero");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.keyObtentionIterations = keyObtentionIterations;
        this.iterationsSet = true;
    }

    public synchronized void setSaltGenerator(SaltGenerator saltGenerator) {
        Validate.notNull((Object)saltGenerator, (String)"Salt generator cannot be set null");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.saltGenerator = saltGenerator;
        this.saltGeneratorSet = true;
    }

    public synchronized void setProviderName(String providerName) {
        Validate.notNull((Object)providerName, (String)"Provider name cannot be set null");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.providerName = providerName;
        this.providerNameSet = true;
    }

    public synchronized void setProvider(Provider provider) {
        Validate.notNull((Object)provider, (String)"Provider cannot be set null");
        if (this.isInitialized()) {
            throw new AlreadyInitializedException();
        }
        this.provider = provider;
        this.providerSet = true;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void initialize() {
        if (!this.initialized) {
            if (this.config != null) {
                Integer configKeyObtentionIterations;
                String configPassword;
                String configAlgorithm = this.config.getAlgorithm();
                if (configAlgorithm != null) {
                    Validate.notEmpty((String)configAlgorithm, (String)"Algorithm cannot be set empty");
                }
                if ((configPassword = this.config.getPassword()) != null) {
                    Validate.notEmpty((String)configPassword, (String)"Password cannot be set empty");
                }
                if ((configKeyObtentionIterations = this.config.getKeyObtentionIterations()) != null) {
                    Validate.isTrue((configKeyObtentionIterations > 0 ? 1 : 0) != 0, (String)"Number of iterations for key obtention must be greater than zero");
                }
                SaltGenerator configSaltGenerator = this.config.getSaltGenerator();
                String configProviderName = this.config.getProviderName();
                if (configProviderName != null) {
                    Validate.notEmpty((String)configProviderName, (String)"Provider name cannot be empty");
                }
                Provider configProvider = this.config.getProvider();
                this.algorithm = this.algorithmSet || configAlgorithm == null ? this.algorithm : configAlgorithm;
                this.password = this.passwordSet || configPassword == null ? this.password : configPassword;
                this.keyObtentionIterations = this.iterationsSet || configKeyObtentionIterations == null ? this.keyObtentionIterations : configKeyObtentionIterations;
                this.saltGenerator = this.saltGeneratorSet || configSaltGenerator == null ? this.saltGenerator : configSaltGenerator;
                this.providerName = this.providerNameSet || configProviderName == null ? this.providerName : configProviderName;
                Provider provider = this.provider = this.providerSet || configProvider == null ? this.provider : configProvider;
            }
            if (this.saltGenerator == null) {
                this.saltGenerator = new RandomSaltGenerator();
            }
            try {
                SecretKeyFactory factory;
                if (this.password == null) {
                    throw new EncryptionInitializationException("Password not set for Password Based Encryptor");
                }
                this.password = Normalizer.normalizeToNfc(this.password);
                PBEKeySpec pbeKeySpec = new PBEKeySpec(this.password.toCharArray());
                if (this.provider != null) {
                    factory = SecretKeyFactory.getInstance(this.algorithm, this.provider);
                    this.key = factory.generateSecret(pbeKeySpec);
                    this.encryptCipher = Cipher.getInstance(this.algorithm, this.provider);
                    this.decryptCipher = Cipher.getInstance(this.algorithm, this.provider);
                } else if (this.providerName != null) {
                    factory = SecretKeyFactory.getInstance(this.algorithm, this.providerName);
                    this.key = factory.generateSecret(pbeKeySpec);
                    this.encryptCipher = Cipher.getInstance(this.algorithm, this.providerName);
                    this.decryptCipher = Cipher.getInstance(this.algorithm, this.providerName);
                } else {
                    factory = SecretKeyFactory.getInstance(this.algorithm);
                    this.key = factory.generateSecret(pbeKeySpec);
                    this.encryptCipher = Cipher.getInstance(this.algorithm);
                    this.decryptCipher = Cipher.getInstance(this.algorithm);
                }
            }
            catch (EncryptionInitializationException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new EncryptionInitializationException(t);
            }
            int algorithmBlockSize = this.encryptCipher.getBlockSize();
            if (algorithmBlockSize > 0) {
                this.saltSizeBytes = algorithmBlockSize;
            }
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] message) throws EncryptionOperationNotPossibleException {
        if (message == null) {
            return null;
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        try {
            byte[] salt = this.saltGenerator.generateSalt(this.saltSizeBytes);
            PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, this.keyObtentionIterations);
            byte[] encryptedMessage = null;
            Cipher cipher = this.encryptCipher;
            synchronized (cipher) {
                this.encryptCipher.init(1, (Key)this.key, parameterSpec);
                encryptedMessage = this.encryptCipher.doFinal(message);
            }
            if (this.saltGenerator.includePlainSaltInEncryptionResults()) {
                encryptedMessage = ArrayUtils.addAll((byte[])salt, (byte[])encryptedMessage);
            }
            return encryptedMessage;
        }
        catch (InvalidKeyException e) {
            this.handleInvalidKeyException(e);
            throw new EncryptionOperationNotPossibleException();
        }
        catch (Exception e) {
            throw new EncryptionOperationNotPossibleException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(byte[] encryptedMessage) throws EncryptionOperationNotPossibleException {
        if (encryptedMessage == null) {
            return null;
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        if (this.saltGenerator.includePlainSaltInEncryptionResults() && encryptedMessage.length <= this.saltSizeBytes) {
            throw new EncryptionOperationNotPossibleException();
        }
        try {
            byte[] salt = null;
            salt = this.saltGenerator.includePlainSaltInEncryptionResults() ? ArrayUtils.subarray((byte[])encryptedMessage, (int)0, (int)this.saltSizeBytes) : this.saltGenerator.generateSalt(this.saltSizeBytes);
            PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, this.keyObtentionIterations);
            byte[] decryptedMessage = null;
            byte[] encryptedMessageKernel = null;
            encryptedMessageKernel = this.saltGenerator.includePlainSaltInEncryptionResults() ? ArrayUtils.subarray((byte[])encryptedMessage, (int)this.saltSizeBytes, (int)encryptedMessage.length) : encryptedMessage;
            Cipher cipher = this.decryptCipher;
            synchronized (cipher) {
                this.decryptCipher.init(2, (Key)this.key, parameterSpec);
                decryptedMessage = this.decryptCipher.doFinal(encryptedMessageKernel);
            }
            return decryptedMessage;
        }
        catch (InvalidKeyException e) {
            this.handleInvalidKeyException(e);
            throw new EncryptionOperationNotPossibleException();
        }
        catch (Exception e) {
            throw new EncryptionOperationNotPossibleException();
        }
    }

    private void handleInvalidKeyException(InvalidKeyException e) {
        if (e.getMessage() != null && e.getMessage().toUpperCase().indexOf("KEY SIZE") != -1) {
            throw new EncryptionOperationNotPossibleException("Encryption raised an exception. A possible cause is you are using strong encryption algorithms and you have not installed the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files in this Java Virtual Machine");
        }
    }
}

