/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.customizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.nachocalendar.components.CalendarPanel;
import net.sf.nachocalendar.components.DateField;
import net.sf.nachocalendar.components.DatePanel;
import net.sf.nachocalendar.customizer.DirectSetter;
import net.sf.nachocalendar.customizer.PropertiesCustomizer;
import net.sf.nachocalendar.customizer.PropertiesSetter;
import net.sf.nachocalendar.customizer.XMLCustomizer;
import org.xml.sax.SAXException;

public class CustomizerFactory {
    PropertiesSetter setter;

    public CustomizerFactory(File config) throws FileNotFoundException, IOException, SAXException, ParserConfigurationException {
        if (config.getName().toLowerCase().endsWith(".properties")) {
            this.setter = new DirectSetter(new PropertiesCustomizer(new FileInputStream(config)));
        }
        if (config.getName().toLowerCase().endsWith(".xml")) {
            this.setter = new DirectSetter(new XMLCustomizer(new FileInputStream(config)));
        }
        if (this.setter == null) {
            throw new IllegalArgumentException("Configuration file not valid");
        }
    }

    public DateField createDateField() {
        DateField retorno = new DateField();
        this.setter.customize(retorno);
        return retorno;
    }

    public DateField createDateField(boolean showWeekNumbers) {
        DateField retorno = new DateField(showWeekNumbers);
        this.setter.customize(retorno);
        return retorno;
    }

    public DatePanel createDatePanel() {
        DatePanel retorno = new DatePanel();
        this.setter.customize(retorno);
        return retorno;
    }

    public DatePanel createDatePanel(boolean showWeekNumbers) {
        DatePanel retorno = new DatePanel(showWeekNumbers);
        this.setter.customize(retorno);
        return retorno;
    }

    public CalendarPanel createCalendarPanel() {
        CalendarPanel retorno = new CalendarPanel();
        this.setter.customize(retorno);
        return retorno;
    }

    public CalendarPanel createCalendarPanel(boolean showWeekNumbers) {
        CalendarPanel retorno = new CalendarPanel(showWeekNumbers);
        this.setter.customize(retorno);
        return retorno;
    }
}

