/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.tasks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JList;
import net.sf.nachocalendar.components.DayPanel;
import net.sf.nachocalendar.components.DayRenderer;

public class TaskQuantityRenderer
extends JLabel
implements DayRenderer {
    private Calendar cal = Calendar.getInstance();
    private Color selectedbg;
    private Color unselectedbg;
    private Color unselectedfg;
    private Color selectedfg;
    private Color notworking;
    private Color taskBg;
    private Color taskColor;
    private int taskq;

    public TaskQuantityRenderer() {
        JList jl = new JList();
        this.unselectedbg = Color.white;
        this.unselectedfg = jl.getForeground();
        this.selectedbg = jl.getSelectionBackground();
        this.selectedfg = jl.getSelectionForeground();
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.setOpaque(true);
        this.notworking = new Color(240, 240, 255);
        this.taskBg = Color.yellow;
        this.taskColor = Color.RED;
    }

    @Override
    public Component getDayRenderer(DayPanel daypanel, Date day, Object data, boolean selected, boolean working, boolean enabled) {
        this.taskq = 0;
        if (selected) {
            this.setBackground(this.selectedbg);
        } else if (working) {
            this.setBackground(this.unselectedbg);
        } else {
            this.setBackground(this.notworking);
        }
        if (working) {
            if (selected) {
                this.setForeground(this.selectedfg);
            } else {
                this.setForeground(this.unselectedfg);
            }
        } else if (selected) {
            this.setForeground(this.selectedfg);
        } else {
            this.setForeground(Color.GRAY);
        }
        if (!enabled) {
            this.setText("");
            return this;
        }
        this.cal.setTime(day);
        this.setText(Integer.toString(this.cal.get(5)));
        daypanel.setToolTipText(null);
        if (data != null && data instanceof Collection) {
            if (selected) {
                this.setBackground(Color.magenta);
            } else {
                this.setBackground(this.taskBg);
            }
            Collection col = (Collection)data;
            this.taskq = col.size();
            daypanel.setToolTipText(Integer.toString(this.taskq) + " tasks");
        } else {
            daypanel.setToolTipText(null);
        }
        return this;
    }

    public Color getTaskBg() {
        return this.taskBg;
    }

    public void setTaskBg(Color taskBg) {
        this.taskBg = taskBg;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.taskq > 0) {
            int x = this.getWidth() / 4;
            int y = this.getHeight() / 4;
            g.setColor(this.taskColor);
            g.fillOval(x - 1, y - 1, 2, 2);
            if (this.taskq > 1) {
                g.fillOval(x - 1, y * 3 - 1, 2, 2);
            }
            if (this.taskq > 2) {
                g.fillOval(x * 3 - 1, y - 1, 2, 2);
            }
            if (this.taskq > 3) {
                g.fillOval(x * 3 - 1, y * 3 - 1, 2, 2);
            }
        }
    }
}

